@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.DomainArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.DomainDefaultSpaceSettingsArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.DomainDefaultSpaceSettingsArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.DomainDefaultUserSettingsArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.DomainDefaultUserSettingsArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.DomainDomainSettingsArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.DomainDomainSettingsArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.DomainRetentionPolicyArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.DomainRetentionPolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Domain resource.
 * ## Example Usage
 * ### Basic usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.iam.getPolicyDocument({
 *     statements: [{
 *         actions: ["sts:AssumeRole"],
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["sagemaker&#46;amazonaws&#46;com"],
 *         }],
 *     }],
 * });
 * const exampleRole = new aws.iam.Role("example", {
 *     name: "example",
 *     path: "/",
 *     assumeRolePolicy: example.then(example => example.json),
 * });
 * const exampleDomain = new aws.sagemaker.Domain("example", {
 *     domainName: "example",
 *     authMode: "IAM",
 *     vpcId: exampleAwsVpc.id,
 *     subnetIds: [exampleAwsSubnet&#46;id],
 *     defaultUserSettings: {
 *         executionRole: exampleRole.arn,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.iam.get_policy_document(statements=[{
 *     "actions": ["sts:AssumeRole"],
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["sagemaker&#46;amazonaws&#46;com"],
 *     }],
 * }])
 * example_role = aws.iam.Role("example",
 *     name="example",
 *     path="/",
 *     assume_role_policy=example.json)
 * example_domain = aws.sagemaker.Domain("example",
 *     domain_name="example",
 *     auth_mode="IAM",
 *     vpc_id=example_aws_vpc["id"],
 *     subnet_ids=[example_aws_subnet["id"]],
 *     default_user_settings={
 *         "execution_role": example_role.arn,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "sagemaker.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRole = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "example",
 *         Path = "/",
 *         AssumeRolePolicy = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var exampleDomain = new Aws.Sagemaker.Domain("example", new()
 *     {
 *         DomainName = "example",
 *         AuthMode = "IAM",
 *         VpcId = exampleAwsVpc.Id,
 *         SubnetIds = new[]
 *         {
 *             exampleAwsSubnet.Id,
 *         },
 *         DefaultUserSettings = new Aws.Sagemaker.Inputs.DomainDefaultUserSettingsArgs
 *         {
 *             ExecutionRole = exampleRole.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"sagemaker.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleRole, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			Name:             pulumi.String("example"),
 * 			Path:             pulumi.String("/"),
 * 			AssumeRolePolicy: pulumi.String(example.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sagemaker.NewDomain(ctx, "example", &sagemaker.DomainArgs{
 * 			DomainName: pulumi.String("example"),
 * 			AuthMode:   pulumi.String("IAM"),
 * 			VpcId:      pulumi.Any(exampleAwsVpc.Id),
 * 			SubnetIds: pulumi.StringArray{
 * 				exampleAwsSubnet.Id,
 * 			},
 * 			DefaultUserSettings: &sagemaker.DomainDefaultUserSettingsArgs{
 * 				ExecutionRole: exampleRole.Arn,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.sagemaker.Domain;
 * import com.pulumi.aws.sagemaker.DomainArgs;
 * import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("sagemaker.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .name("example")
 *             .path("/")
 *             .assumeRolePolicy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .domainName("example")
 *             .authMode("IAM")
 *             .vpcId(exampleAwsVpc.id())
 *             .subnetIds(exampleAwsSubnet.id())
 *             .defaultUserSettings(DomainDefaultUserSettingsArgs.builder()
 *                 .executionRole(exampleRole.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleDomain:
 *     type: aws:sagemaker:Domain
 *     name: example
 *     properties:
 *       domainName: example
 *       authMode: IAM
 *       vpcId: ${exampleAwsVpc.id}
 *       subnetIds:
 *         - ${exampleAwsSubnet.id}
 *       defaultUserSettings:
 *         executionRole: ${exampleRole.arn}
 *   exampleRole:
 *     type: aws:iam:Role
 *     name: example
 *     properties:
 *       name: example
 *       path: /
 *       assumeRolePolicy: ${example.json}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - sts:AssumeRole
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - sagemaker.amazonaws.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Using Custom Images
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Image;
 * import com.pulumi.aws.sagemaker.ImageArgs;
 * import com.pulumi.aws.sagemaker.AppImageConfig;
 * import com.pulumi.aws.sagemaker.AppImageConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.AppImageConfigKernelGatewayImageConfigArgs;
 * import com.pulumi.aws.sagemaker.ImageVersion;
 * import com.pulumi.aws.sagemaker.ImageVersionArgs;
 * import com.pulumi.aws.sagemaker.Domain;
 * import com.pulumi.aws.sagemaker.DomainArgs;
 * import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsArgs;
 * import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsKernelGatewayAppSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Image("example", ImageArgs.builder()
 *             .imageName("example")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .build());
 *         var exampleAppImageConfig = new AppImageConfig("exampleAppImageConfig", AppImageConfigArgs.builder()
 *             .appImageConfigName("example")
 *             .kernelGatewayImageConfig(AppImageConfigKernelGatewayImageConfigArgs.builder()
 *                 .kernelSpecs(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                 .build())
 *             .build());
 *         var exampleImageVersion = new ImageVersion("exampleImageVersion", ImageVersionArgs.builder()
 *             .imageName(example.id())
 *             .baseImage("base-image")
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .domainName("example")
 *             .authMode("IAM")
 *             .vpcId(exampleAwsVpc.id())
 *             .subnetIds(exampleAwsSubnet.id())
 *             .defaultUserSettings(DomainDefaultUserSettingsArgs.builder()
 *                 .executionRole(exampleAwsIamRole.arn())
 *                 .kernelGatewayAppSettings(DomainDefaultUserSettingsKernelGatewayAppSettingsArgs.builder()
 *                     .customImages(DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImageArgs.builder()
 *                         .appImageConfigName(exampleAppImageConfig.appImageConfigName())
 *                         .imageName(exampleImageVersion.imageName())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:Image
 *     properties:
 *       imageName: example
 *       roleArn: ${exampleAwsIamRole.arn}
 *   exampleAppImageConfig:
 *     type: aws:sagemaker:AppImageConfig
 *     name: example
 *     properties:
 *       appImageConfigName: example
 *       kernelGatewayImageConfig:
 *         kernelSpecs:
 *           - name: example
 *   exampleImageVersion:
 *     type: aws:sagemaker:ImageVersion
 *     name: example
 *     properties:
 *       imageName: ${example.id}
 *       baseImage: base-image
 *   exampleDomain:
 *     type: aws:sagemaker:Domain
 *     name: example
 *     properties:
 *       domainName: example
 *       authMode: IAM
 *       vpcId: ${exampleAwsVpc.id}
 *       subnetIds:
 *         - ${exampleAwsSubnet.id}
 *       defaultUserSettings:
 *         executionRole: ${exampleAwsIamRole.arn}
 *         kernelGatewayAppSettings:
 *           customImages:
 *             - appImageConfigName: ${exampleAppImageConfig.appImageConfigName}
 *               imageName: ${exampleImageVersion.imageName}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker Domains using the `id`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/domain:Domain test_domain d-8jgsjtilstu8
 * ```
 * @property appNetworkAccessType Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly`. Valid values are `PublicInternetOnly` and `VpcOnly`.
 * @property appSecurityGroupManagement The entity that creates and manages the required security groups for inter-app communication in `VPCOnly` mode. Valid values are `Service` and `Customer`.
 * @property authMode The mode of authentication that members use to access the domain. Valid values are `IAM` and `SSO`.
 * @property defaultSpaceSettings The default space settings. See `default_space_settings` Block below.
 * @property defaultUserSettings The default user settings. See `default_user_settings` Block below.
 * @property domainName The domain name.
 * @property domainSettings The domain settings. See `domain_settings` Block below.
 * @property kmsKeyId The AWS KMS customer managed CMK used to encrypt the EFS volume attached to the domain.
 * @property retentionPolicy The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained. See `retention_policy` Block below.
 * @property subnetIds The VPC subnets that Studio uses for communication.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcId The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
 * The following arguments are optional:
 */
public data class DomainArgs(
    public val appNetworkAccessType: Output<String>? = null,
    public val appSecurityGroupManagement: Output<String>? = null,
    public val authMode: Output<String>? = null,
    public val defaultSpaceSettings: Output<DomainDefaultSpaceSettingsArgs>? = null,
    public val defaultUserSettings: Output<DomainDefaultUserSettingsArgs>? = null,
    public val domainName: Output<String>? = null,
    public val domainSettings: Output<DomainDomainSettingsArgs>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val retentionPolicy: Output<DomainRetentionPolicyArgs>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.DomainArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.DomainArgs =
        com.pulumi.aws.sagemaker.DomainArgs.builder()
            .appNetworkAccessType(appNetworkAccessType?.applyValue({ args0 -> args0 }))
            .appSecurityGroupManagement(appSecurityGroupManagement?.applyValue({ args0 -> args0 }))
            .authMode(authMode?.applyValue({ args0 -> args0 }))
            .defaultSpaceSettings(
                defaultSpaceSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .defaultUserSettings(
                defaultUserSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .domainSettings(domainSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .retentionPolicy(retentionPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainArgs].
 */
@PulumiTagMarker
public class DomainArgsBuilder internal constructor() {
    private var appNetworkAccessType: Output<String>? = null

    private var appSecurityGroupManagement: Output<String>? = null

    private var authMode: Output<String>? = null

    private var defaultSpaceSettings: Output<DomainDefaultSpaceSettingsArgs>? = null

    private var defaultUserSettings: Output<DomainDefaultUserSettingsArgs>? = null

    private var domainName: Output<String>? = null

    private var domainSettings: Output<DomainDomainSettingsArgs>? = null

    private var kmsKeyId: Output<String>? = null

    private var retentionPolicy: Output<DomainRetentionPolicyArgs>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly`. Valid values are `PublicInternetOnly` and `VpcOnly`.
     */
    @JvmName("kbbpfmbhurfoguig")
    public suspend fun appNetworkAccessType(`value`: Output<String>) {
        this.appNetworkAccessType = value
    }

    /**
     * @param value The entity that creates and manages the required security groups for inter-app communication in `VPCOnly` mode. Valid values are `Service` and `Customer`.
     */
    @JvmName("ifgswoqbvlpxdvwj")
    public suspend fun appSecurityGroupManagement(`value`: Output<String>) {
        this.appSecurityGroupManagement = value
    }

    /**
     * @param value The mode of authentication that members use to access the domain. Valid values are `IAM` and `SSO`.
     */
    @JvmName("rekuoewkmpdeprli")
    public suspend fun authMode(`value`: Output<String>) {
        this.authMode = value
    }

    /**
     * @param value The default space settings. See `default_space_settings` Block below.
     */
    @JvmName("ojpxliamfjhwjchp")
    public suspend fun defaultSpaceSettings(`value`: Output<DomainDefaultSpaceSettingsArgs>) {
        this.defaultSpaceSettings = value
    }

    /**
     * @param value The default user settings. See `default_user_settings` Block below.
     */
    @JvmName("vkviacstgehershk")
    public suspend fun defaultUserSettings(`value`: Output<DomainDefaultUserSettingsArgs>) {
        this.defaultUserSettings = value
    }

    /**
     * @param value The domain name.
     */
    @JvmName("whviisvusmlubwid")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The domain settings. See `domain_settings` Block below.
     */
    @JvmName("yaienejylnejywme")
    public suspend fun domainSettings(`value`: Output<DomainDomainSettingsArgs>) {
        this.domainSettings = value
    }

    /**
     * @param value The AWS KMS customer managed CMK used to encrypt the EFS volume attached to the domain.
     */
    @JvmName("tfmvnsfcmlfkcuto")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained. See `retention_policy` Block below.
     */
    @JvmName("byrptmbbqrjkbsjf")
    public suspend fun retentionPolicy(`value`: Output<DomainRetentionPolicyArgs>) {
        this.retentionPolicy = value
    }

    /**
     * @param value The VPC subnets that Studio uses for communication.
     */
    @JvmName("alowqhnsngymyqoo")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("baxndqdljpirjjwu")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values The VPC subnets that Studio uses for communication.
     */
    @JvmName("dyyvjlryfwxxeket")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xnxpspvssthohyjp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
     * The following arguments are optional:
     */
    @JvmName("ksrhmtafasqkkptq")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Specifies the VPC used for non-EFS traffic. The default value is `PublicInternetOnly`. Valid values are `PublicInternetOnly` and `VpcOnly`.
     */
    @JvmName("sqjpeprdjbnoqbkr")
    public suspend fun appNetworkAccessType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appNetworkAccessType = mapped
    }

    /**
     * @param value The entity that creates and manages the required security groups for inter-app communication in `VPCOnly` mode. Valid values are `Service` and `Customer`.
     */
    @JvmName("gobkxxnlivnlikqy")
    public suspend fun appSecurityGroupManagement(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appSecurityGroupManagement = mapped
    }

    /**
     * @param value The mode of authentication that members use to access the domain. Valid values are `IAM` and `SSO`.
     */
    @JvmName("wcxjuqmripyginjp")
    public suspend fun authMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authMode = mapped
    }

    /**
     * @param value The default space settings. See `default_space_settings` Block below.
     */
    @JvmName("vcvahthhtknyrjto")
    public suspend fun defaultSpaceSettings(`value`: DomainDefaultSpaceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultSpaceSettings = mapped
    }

    /**
     * @param argument The default space settings. See `default_space_settings` Block below.
     */
    @JvmName("ruofcvnstwfvnejh")
    public suspend fun defaultSpaceSettings(argument: suspend DomainDefaultSpaceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultSpaceSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultSpaceSettings = mapped
    }

    /**
     * @param value The default user settings. See `default_user_settings` Block below.
     */
    @JvmName("bhpvgqphyolteqbt")
    public suspend fun defaultUserSettings(`value`: DomainDefaultUserSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultUserSettings = mapped
    }

    /**
     * @param argument The default user settings. See `default_user_settings` Block below.
     */
    @JvmName("ywdjtvvnhxgdvwlt")
    public suspend fun defaultUserSettings(argument: suspend DomainDefaultUserSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultUserSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultUserSettings = mapped
    }

    /**
     * @param value The domain name.
     */
    @JvmName("qhmjfvwnqcptgbvb")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The domain settings. See `domain_settings` Block below.
     */
    @JvmName("kjfqcinhaldyxidl")
    public suspend fun domainSettings(`value`: DomainDomainSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainSettings = mapped
    }

    /**
     * @param argument The domain settings. See `domain_settings` Block below.
     */
    @JvmName("ajymvghijtrfqssy")
    public suspend fun domainSettings(argument: suspend DomainDomainSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDomainSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.domainSettings = mapped
    }

    /**
     * @param value The AWS KMS customer managed CMK used to encrypt the EFS volume attached to the domain.
     */
    @JvmName("xysqhankofqmjdmr")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained. See `retention_policy` Block below.
     */
    @JvmName("cnupapthquwiwupf")
    public suspend fun retentionPolicy(`value`: DomainRetentionPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPolicy = mapped
    }

    /**
     * @param argument The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained. See `retention_policy` Block below.
     */
    @JvmName("pyiyhfrfchimoond")
    public suspend fun retentionPolicy(argument: suspend DomainRetentionPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = DomainRetentionPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retentionPolicy = mapped
    }

    /**
     * @param value The VPC subnets that Studio uses for communication.
     */
    @JvmName("lotmmubpxhumcswd")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values The VPC subnets that Studio uses for communication.
     */
    @JvmName("gbwwmskrltlotwti")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("frwgmvvjglaefwww")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wxuvexvjishfbnks")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.
     * The following arguments are optional:
     */
    @JvmName("hrfdyievikmakrfk")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): DomainArgs = DomainArgs(
        appNetworkAccessType = appNetworkAccessType,
        appSecurityGroupManagement = appSecurityGroupManagement,
        authMode = authMode,
        defaultSpaceSettings = defaultSpaceSettings,
        defaultUserSettings = defaultUserSettings,
        domainName = domainName,
        domainSettings = domainSettings,
        kmsKeyId = kmsKeyId,
        retentionPolicy = retentionPolicy,
        subnetIds = subnetIds,
        tags = tags,
        vpcId = vpcId,
    )
}
