@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.EndpointArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.EndpointDeploymentConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.EndpointDeploymentConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Endpoint resource.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const e = new aws.sagemaker.Endpoint("e", {
 *     name: "my-endpoint",
 *     endpointConfigName: ec.name,
 *     tags: {
 *         Name: "foo",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * e = aws.sagemaker.Endpoint("e",
 *     name="my-endpoint",
 *     endpoint_config_name=ec["name"],
 *     tags={
 *         "Name": "foo",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var e = new Aws.Sagemaker.Endpoint("e", new()
 *     {
 *         Name = "my-endpoint",
 *         EndpointConfigName = ec.Name,
 *         Tags =
 *         {
 *             { "Name", "foo" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewEndpoint(ctx, "e", &sagemaker.EndpointArgs{
 * 			Name:               pulumi.String("my-endpoint"),
 * 			EndpointConfigName: pulumi.Any(ec.Name),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("foo"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Endpoint;
 * import com.pulumi.aws.sagemaker.EndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var e = new Endpoint("e", EndpointArgs.builder()
 *             .name("my-endpoint")
 *             .endpointConfigName(ec.name())
 *             .tags(Map.of("Name", "foo"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   e:
 *     type: aws:sagemaker:Endpoint
 *     properties:
 *       name: my-endpoint
 *       endpointConfigName: ${ec.name}
 *       tags:
 *         Name: foo
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import endpoints using the `name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/endpoint:Endpoint test_endpoint my-endpoint
 * ```
 * @property deploymentConfig The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations. See Deployment Config.
 * @property endpointConfigName The name of the endpoint configuration to use.
 * @property name The name of the endpoint. If omitted, the provider will assign a random, unique name.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class EndpointArgs(
    public val deploymentConfig: Output<EndpointDeploymentConfigArgs>? = null,
    public val endpointConfigName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.EndpointArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.EndpointArgs =
        com.pulumi.aws.sagemaker.EndpointArgs.builder()
            .deploymentConfig(deploymentConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .endpointConfigName(endpointConfigName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EndpointArgs].
 */
@PulumiTagMarker
public class EndpointArgsBuilder internal constructor() {
    private var deploymentConfig: Output<EndpointDeploymentConfigArgs>? = null

    private var endpointConfigName: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations. See Deployment Config.
     */
    @JvmName("lgddbyhpaqfewqog")
    public suspend fun deploymentConfig(`value`: Output<EndpointDeploymentConfigArgs>) {
        this.deploymentConfig = value
    }

    /**
     * @param value The name of the endpoint configuration to use.
     */
    @JvmName("jqstuogweqrqecke")
    public suspend fun endpointConfigName(`value`: Output<String>) {
        this.endpointConfigName = value
    }

    /**
     * @param value The name of the endpoint. If omitted, the provider will assign a random, unique name.
     */
    @JvmName("fgkjqjarbbtfsfsu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yifrrkqpjanwpflv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations. See Deployment Config.
     */
    @JvmName("htkelvnjpgmjoqfq")
    public suspend fun deploymentConfig(`value`: EndpointDeploymentConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentConfig = mapped
    }

    /**
     * @param argument The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations. See Deployment Config.
     */
    @JvmName("bndwpvtgmdwjpiuf")
    public suspend fun deploymentConfig(argument: suspend EndpointDeploymentConfigArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointDeploymentConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deploymentConfig = mapped
    }

    /**
     * @param value The name of the endpoint configuration to use.
     */
    @JvmName("wfrvhnlevgycsfqw")
    public suspend fun endpointConfigName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointConfigName = mapped
    }

    /**
     * @param value The name of the endpoint. If omitted, the provider will assign a random, unique name.
     */
    @JvmName("oooengiligqtcles")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xlglvfpedfxvhroa")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("whjvgmqyeyjopugs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EndpointArgs = EndpointArgs(
        deploymentConfig = deploymentConfig,
        endpointConfigName = endpointConfigName,
        name = name,
        tags = tags,
    )
}
