@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.FeatureGroupFeatureDefinition
import com.pulumi.aws.sagemaker.kotlin.outputs.FeatureGroupOfflineStoreConfig
import com.pulumi.aws.sagemaker.kotlin.outputs.FeatureGroupOnlineStoreConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.sagemaker.kotlin.outputs.FeatureGroupFeatureDefinition.Companion.toKotlin as featureGroupFeatureDefinitionToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.FeatureGroupOfflineStoreConfig.Companion.toKotlin as featureGroupOfflineStoreConfigToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.FeatureGroupOnlineStoreConfig.Companion.toKotlin as featureGroupOnlineStoreConfigToKotlin

/**
 * Builder for [FeatureGroup].
 */
@PulumiTagMarker
public class FeatureGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FeatureGroupArgs = FeatureGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FeatureGroupArgsBuilder.() -> Unit) {
        val builder = FeatureGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FeatureGroup {
        val builtJavaResource = com.pulumi.aws.sagemaker.FeatureGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FeatureGroup(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Feature Group resource.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.FeatureGroup("example", {
 *     featureGroupName: "example",
 *     recordIdentifierFeatureName: "example",
 *     eventTimeFeatureName: "example",
 *     roleArn: test.arn,
 *     featureDefinitions: [{
 *         featureName: "example",
 *         featureType: "String",
 *     }],
 *     onlineStoreConfig: {
 *         enableOnlineStore: true,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.FeatureGroup("example",
 *     feature_group_name="example",
 *     record_identifier_feature_name="example",
 *     event_time_feature_name="example",
 *     role_arn=test["arn"],
 *     feature_definitions=[{
 *         "feature_name": "example",
 *         "feature_type": "String",
 *     }],
 *     online_store_config={
 *         "enable_online_store": True,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.FeatureGroup("example", new()
 *     {
 *         FeatureGroupName = "example",
 *         RecordIdentifierFeatureName = "example",
 *         EventTimeFeatureName = "example",
 *         RoleArn = test.Arn,
 *         FeatureDefinitions = new[]
 *         {
 *             new Aws.Sagemaker.Inputs.FeatureGroupFeatureDefinitionArgs
 *             {
 *                 FeatureName = "example",
 *                 FeatureType = "String",
 *             },
 *         },
 *         OnlineStoreConfig = new Aws.Sagemaker.Inputs.FeatureGroupOnlineStoreConfigArgs
 *         {
 *             EnableOnlineStore = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewFeatureGroup(ctx, "example", &sagemaker.FeatureGroupArgs{
 * 			FeatureGroupName:            pulumi.String("example"),
 * 			RecordIdentifierFeatureName: pulumi.String("example"),
 * 			EventTimeFeatureName:        pulumi.String("example"),
 * 			RoleArn:                     pulumi.Any(test.Arn),
 * 			FeatureDefinitions: sagemaker.FeatureGroupFeatureDefinitionArray{
 * 				&sagemaker.FeatureGroupFeatureDefinitionArgs{
 * 					FeatureName: pulumi.String("example"),
 * 					FeatureType: pulumi.String("String"),
 * 				},
 * 			},
 * 			OnlineStoreConfig: &sagemaker.FeatureGroupOnlineStoreConfigArgs{
 * 				EnableOnlineStore: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.FeatureGroup;
 * import com.pulumi.aws.sagemaker.FeatureGroupArgs;
 * import com.pulumi.aws.sagemaker.inputs.FeatureGroupFeatureDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.FeatureGroupOnlineStoreConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FeatureGroup("example", FeatureGroupArgs.builder()
 *             .featureGroupName("example")
 *             .recordIdentifierFeatureName("example")
 *             .eventTimeFeatureName("example")
 *             .roleArn(test.arn())
 *             .featureDefinitions(FeatureGroupFeatureDefinitionArgs.builder()
 *                 .featureName("example")
 *                 .featureType("String")
 *                 .build())
 *             .onlineStoreConfig(FeatureGroupOnlineStoreConfigArgs.builder()
 *                 .enableOnlineStore(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:FeatureGroup
 *     properties:
 *       featureGroupName: example
 *       recordIdentifierFeatureName: example
 *       eventTimeFeatureName: example
 *       roleArn: ${test.arn}
 *       featureDefinitions:
 *         - featureName: example
 *           featureType: String
 *       onlineStoreConfig:
 *         enableOnlineStore: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Feature Groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/featureGroup:FeatureGroup test_feature_group feature_group-foo
 * ```
 */
public class FeatureGroup internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.FeatureGroup,
) : KotlinCustomResource(javaResource, FeatureGroupMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this feature_group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A free-form description of a Feature Group.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the feature that stores the EventTime of a Record in a Feature Group.
     */
    public val eventTimeFeatureName: Output<String>
        get() = javaResource.eventTimeFeatureName().applyValue({ args0 -> args0 })

    /**
     * A list of Feature names and types. See Feature Definition Below.
     */
    public val featureDefinitions: Output<List<FeatureGroupFeatureDefinition>>
        get() = javaResource.featureDefinitions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> featureGroupFeatureDefinitionToKotlin(args0) })
            })
        })

    /**
     * The name of the Feature Group. The name must be unique within an AWS Region in an AWS account.
     */
    public val featureGroupName: Output<String>
        get() = javaResource.featureGroupName().applyValue({ args0 -> args0 })

    /**
     * The Offline Feature Store Configuration. See Offline Store Config Below.
     */
    public val offlineStoreConfig: Output<FeatureGroupOfflineStoreConfig>?
        get() = javaResource.offlineStoreConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> featureGroupOfflineStoreConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The Online Feature Store Configuration. See Online Store Config Below.
     */
    public val onlineStoreConfig: Output<FeatureGroupOnlineStoreConfig>?
        get() = javaResource.onlineStoreConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> featureGroupOnlineStoreConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the Feature whose value uniquely identifies a Record defined in the Feature Store. Only the latest record per identifier value will be stored in the Online Store.
     */
    public val recordIdentifierFeatureName: Output<String>
        get() = javaResource.recordIdentifierFeatureName().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the Offline Store if an `offline_store_config` is provided.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * Map of resource tags for the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object FeatureGroupMapper : ResourceMapper<FeatureGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.FeatureGroup::class == javaResource::class

    override fun map(javaResource: Resource): FeatureGroup = FeatureGroup(
        javaResource as
            com.pulumi.aws.sagemaker.FeatureGroup,
    )
}

/**
 * @see [FeatureGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FeatureGroup].
 */
public suspend fun featureGroup(
    name: String,
    block: suspend FeatureGroupResourceBuilder.() -> Unit,
): FeatureGroup {
    val builder = FeatureGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FeatureGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun featureGroup(name: String): FeatureGroup {
    val builder = FeatureGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
