@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.FeatureGroupArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.FeatureGroupFeatureDefinitionArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.FeatureGroupFeatureDefinitionArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.FeatureGroupOfflineStoreConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.FeatureGroupOfflineStoreConfigArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.FeatureGroupOnlineStoreConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.FeatureGroupOnlineStoreConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Feature Group resource.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.FeatureGroup("example", {
 *     featureGroupName: "example",
 *     recordIdentifierFeatureName: "example",
 *     eventTimeFeatureName: "example",
 *     roleArn: test.arn,
 *     featureDefinitions: [{
 *         featureName: "example",
 *         featureType: "String",
 *     }],
 *     onlineStoreConfig: {
 *         enableOnlineStore: true,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.FeatureGroup("example",
 *     feature_group_name="example",
 *     record_identifier_feature_name="example",
 *     event_time_feature_name="example",
 *     role_arn=test["arn"],
 *     feature_definitions=[{
 *         "feature_name": "example",
 *         "feature_type": "String",
 *     }],
 *     online_store_config={
 *         "enable_online_store": True,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.FeatureGroup("example", new()
 *     {
 *         FeatureGroupName = "example",
 *         RecordIdentifierFeatureName = "example",
 *         EventTimeFeatureName = "example",
 *         RoleArn = test.Arn,
 *         FeatureDefinitions = new[]
 *         {
 *             new Aws.Sagemaker.Inputs.FeatureGroupFeatureDefinitionArgs
 *             {
 *                 FeatureName = "example",
 *                 FeatureType = "String",
 *             },
 *         },
 *         OnlineStoreConfig = new Aws.Sagemaker.Inputs.FeatureGroupOnlineStoreConfigArgs
 *         {
 *             EnableOnlineStore = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewFeatureGroup(ctx, "example", &sagemaker.FeatureGroupArgs{
 * 			FeatureGroupName:            pulumi.String("example"),
 * 			RecordIdentifierFeatureName: pulumi.String("example"),
 * 			EventTimeFeatureName:        pulumi.String("example"),
 * 			RoleArn:                     pulumi.Any(test.Arn),
 * 			FeatureDefinitions: sagemaker.FeatureGroupFeatureDefinitionArray{
 * 				&sagemaker.FeatureGroupFeatureDefinitionArgs{
 * 					FeatureName: pulumi.String("example"),
 * 					FeatureType: pulumi.String("String"),
 * 				},
 * 			},
 * 			OnlineStoreConfig: &sagemaker.FeatureGroupOnlineStoreConfigArgs{
 * 				EnableOnlineStore: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.FeatureGroup;
 * import com.pulumi.aws.sagemaker.FeatureGroupArgs;
 * import com.pulumi.aws.sagemaker.inputs.FeatureGroupFeatureDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.FeatureGroupOnlineStoreConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FeatureGroup("example", FeatureGroupArgs.builder()
 *             .featureGroupName("example")
 *             .recordIdentifierFeatureName("example")
 *             .eventTimeFeatureName("example")
 *             .roleArn(test.arn())
 *             .featureDefinitions(FeatureGroupFeatureDefinitionArgs.builder()
 *                 .featureName("example")
 *                 .featureType("String")
 *                 .build())
 *             .onlineStoreConfig(FeatureGroupOnlineStoreConfigArgs.builder()
 *                 .enableOnlineStore(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:FeatureGroup
 *     properties:
 *       featureGroupName: example
 *       recordIdentifierFeatureName: example
 *       eventTimeFeatureName: example
 *       roleArn: ${test.arn}
 *       featureDefinitions:
 *         - featureName: example
 *           featureType: String
 *       onlineStoreConfig:
 *         enableOnlineStore: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Feature Groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/featureGroup:FeatureGroup test_feature_group feature_group-foo
 * ```
 * @property description A free-form description of a Feature Group.
 * @property eventTimeFeatureName The name of the feature that stores the EventTime of a Record in a Feature Group.
 * @property featureDefinitions A list of Feature names and types. See Feature Definition Below.
 * @property featureGroupName The name of the Feature Group. The name must be unique within an AWS Region in an AWS account.
 * @property offlineStoreConfig The Offline Feature Store Configuration. See Offline Store Config Below.
 * @property onlineStoreConfig The Online Feature Store Configuration. See Online Store Config Below.
 * @property recordIdentifierFeatureName The name of the Feature whose value uniquely identifies a Record defined in the Feature Store. Only the latest record per identifier value will be stored in the Online Store.
 * @property roleArn The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the Offline Store if an `offline_store_config` is provided.
 * @property tags Map of resource tags for the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class FeatureGroupArgs(
    public val description: Output<String>? = null,
    public val eventTimeFeatureName: Output<String>? = null,
    public val featureDefinitions: Output<List<FeatureGroupFeatureDefinitionArgs>>? = null,
    public val featureGroupName: Output<String>? = null,
    public val offlineStoreConfig: Output<FeatureGroupOfflineStoreConfigArgs>? = null,
    public val onlineStoreConfig: Output<FeatureGroupOnlineStoreConfigArgs>? = null,
    public val recordIdentifierFeatureName: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.FeatureGroupArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.FeatureGroupArgs =
        com.pulumi.aws.sagemaker.FeatureGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .eventTimeFeatureName(eventTimeFeatureName?.applyValue({ args0 -> args0 }))
            .featureDefinitions(
                featureDefinitions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .featureGroupName(featureGroupName?.applyValue({ args0 -> args0 }))
            .offlineStoreConfig(
                offlineStoreConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .onlineStoreConfig(onlineStoreConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .recordIdentifierFeatureName(recordIdentifierFeatureName?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FeatureGroupArgs].
 */
@PulumiTagMarker
public class FeatureGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var eventTimeFeatureName: Output<String>? = null

    private var featureDefinitions: Output<List<FeatureGroupFeatureDefinitionArgs>>? = null

    private var featureGroupName: Output<String>? = null

    private var offlineStoreConfig: Output<FeatureGroupOfflineStoreConfigArgs>? = null

    private var onlineStoreConfig: Output<FeatureGroupOnlineStoreConfigArgs>? = null

    private var recordIdentifierFeatureName: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A free-form description of a Feature Group.
     */
    @JvmName("dqbiboefdgxkkwiw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the feature that stores the EventTime of a Record in a Feature Group.
     */
    @JvmName("fgsryvcajpvpwuvl")
    public suspend fun eventTimeFeatureName(`value`: Output<String>) {
        this.eventTimeFeatureName = value
    }

    /**
     * @param value A list of Feature names and types. See Feature Definition Below.
     */
    @JvmName("qgoycunvpritpxhm")
    public suspend fun featureDefinitions(`value`: Output<List<FeatureGroupFeatureDefinitionArgs>>) {
        this.featureDefinitions = value
    }

    @JvmName("qokwflsvgttdlhgl")
    public suspend fun featureDefinitions(vararg values: Output<FeatureGroupFeatureDefinitionArgs>) {
        this.featureDefinitions = Output.all(values.asList())
    }

    /**
     * @param values A list of Feature names and types. See Feature Definition Below.
     */
    @JvmName("tkxwtymqugwygceq")
    public suspend fun featureDefinitions(values: List<Output<FeatureGroupFeatureDefinitionArgs>>) {
        this.featureDefinitions = Output.all(values)
    }

    /**
     * @param value The name of the Feature Group. The name must be unique within an AWS Region in an AWS account.
     */
    @JvmName("qbewwegfgsxbrgss")
    public suspend fun featureGroupName(`value`: Output<String>) {
        this.featureGroupName = value
    }

    /**
     * @param value The Offline Feature Store Configuration. See Offline Store Config Below.
     */
    @JvmName("dxyleerqnkpnfrre")
    public suspend fun offlineStoreConfig(`value`: Output<FeatureGroupOfflineStoreConfigArgs>) {
        this.offlineStoreConfig = value
    }

    /**
     * @param value The Online Feature Store Configuration. See Online Store Config Below.
     */
    @JvmName("qbpfblqwsrbcdxai")
    public suspend fun onlineStoreConfig(`value`: Output<FeatureGroupOnlineStoreConfigArgs>) {
        this.onlineStoreConfig = value
    }

    /**
     * @param value The name of the Feature whose value uniquely identifies a Record defined in the Feature Store. Only the latest record per identifier value will be stored in the Online Store.
     */
    @JvmName("fvnhvppnmvrpoggo")
    public suspend fun recordIdentifierFeatureName(`value`: Output<String>) {
        this.recordIdentifierFeatureName = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the Offline Store if an `offline_store_config` is provided.
     */
    @JvmName("eslcnmudsdrjtuft")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Map of resource tags for the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("elqhsxdevcdexlsy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A free-form description of a Feature Group.
     */
    @JvmName("roafygyspswtyaco")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the feature that stores the EventTime of a Record in a Feature Group.
     */
    @JvmName("hcvykifhfeippons")
    public suspend fun eventTimeFeatureName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventTimeFeatureName = mapped
    }

    /**
     * @param value A list of Feature names and types. See Feature Definition Below.
     */
    @JvmName("dnwycwfswprddodf")
    public suspend fun featureDefinitions(`value`: List<FeatureGroupFeatureDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featureDefinitions = mapped
    }

    /**
     * @param argument A list of Feature names and types. See Feature Definition Below.
     */
    @JvmName("bmdrbkhdmirrlkqm")
    public suspend fun featureDefinitions(argument: List<suspend FeatureGroupFeatureDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FeatureGroupFeatureDefinitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.featureDefinitions = mapped
    }

    /**
     * @param argument A list of Feature names and types. See Feature Definition Below.
     */
    @JvmName("mlrcslsqplorbrlj")
    public suspend fun featureDefinitions(vararg argument: suspend FeatureGroupFeatureDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FeatureGroupFeatureDefinitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.featureDefinitions = mapped
    }

    /**
     * @param argument A list of Feature names and types. See Feature Definition Below.
     */
    @JvmName("kbhkfhmjjpnwxagc")
    public suspend fun featureDefinitions(argument: suspend FeatureGroupFeatureDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FeatureGroupFeatureDefinitionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.featureDefinitions = mapped
    }

    /**
     * @param values A list of Feature names and types. See Feature Definition Below.
     */
    @JvmName("bujxvqjfkfdgteuk")
    public suspend fun featureDefinitions(vararg values: FeatureGroupFeatureDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.featureDefinitions = mapped
    }

    /**
     * @param value The name of the Feature Group. The name must be unique within an AWS Region in an AWS account.
     */
    @JvmName("qmtblolhbjlkhjrr")
    public suspend fun featureGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featureGroupName = mapped
    }

    /**
     * @param value The Offline Feature Store Configuration. See Offline Store Config Below.
     */
    @JvmName("laqfqfghnnywgeis")
    public suspend fun offlineStoreConfig(`value`: FeatureGroupOfflineStoreConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offlineStoreConfig = mapped
    }

    /**
     * @param argument The Offline Feature Store Configuration. See Offline Store Config Below.
     */
    @JvmName("abltfrtitxhnfgss")
    public suspend fun offlineStoreConfig(argument: suspend FeatureGroupOfflineStoreConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FeatureGroupOfflineStoreConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.offlineStoreConfig = mapped
    }

    /**
     * @param value The Online Feature Store Configuration. See Online Store Config Below.
     */
    @JvmName("npaioncyyvpedivx")
    public suspend fun onlineStoreConfig(`value`: FeatureGroupOnlineStoreConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onlineStoreConfig = mapped
    }

    /**
     * @param argument The Online Feature Store Configuration. See Online Store Config Below.
     */
    @JvmName("hjlducplxdbkkscl")
    public suspend fun onlineStoreConfig(argument: suspend FeatureGroupOnlineStoreConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FeatureGroupOnlineStoreConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.onlineStoreConfig = mapped
    }

    /**
     * @param value The name of the Feature whose value uniquely identifies a Record defined in the Feature Store. Only the latest record per identifier value will be stored in the Online Store.
     */
    @JvmName("avkvlhcyhqfqedfi")
    public suspend fun recordIdentifierFeatureName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordIdentifierFeatureName = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the Offline Store if an `offline_store_config` is provided.
     */
    @JvmName("wwvwidloitvakckr")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Map of resource tags for the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xwmbcwpdmwlsbgtd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of resource tags for the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bcqiftknjujhdqmo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FeatureGroupArgs = FeatureGroupArgs(
        description = description,
        eventTimeFeatureName = eventTimeFeatureName,
        featureDefinitions = featureDefinitions,
        featureGroupName = featureGroupName,
        offlineStoreConfig = offlineStoreConfig,
        onlineStoreConfig = onlineStoreConfig,
        recordIdentifierFeatureName = recordIdentifierFeatureName,
        roleArn = roleArn,
        tags = tags,
    )
}
