@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.FlowDefinitionHumanLoopActivationConfig
import com.pulumi.aws.sagemaker.kotlin.outputs.FlowDefinitionHumanLoopConfig
import com.pulumi.aws.sagemaker.kotlin.outputs.FlowDefinitionHumanLoopRequestSource
import com.pulumi.aws.sagemaker.kotlin.outputs.FlowDefinitionOutputConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.sagemaker.kotlin.outputs.FlowDefinitionHumanLoopActivationConfig.Companion.toKotlin as flowDefinitionHumanLoopActivationConfigToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.FlowDefinitionHumanLoopConfig.Companion.toKotlin as flowDefinitionHumanLoopConfigToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.FlowDefinitionHumanLoopRequestSource.Companion.toKotlin as flowDefinitionHumanLoopRequestSourceToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.FlowDefinitionOutputConfig.Companion.toKotlin as flowDefinitionOutputConfigToKotlin

/**
 * Builder for [FlowDefinition].
 */
@PulumiTagMarker
public class FlowDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FlowDefinitionArgs = FlowDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FlowDefinitionArgsBuilder.() -> Unit) {
        val builder = FlowDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FlowDefinition {
        val builtJavaResource = com.pulumi.aws.sagemaker.FlowDefinition(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FlowDefinition(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Flow Definition resource.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.FlowDefinition("example", {
 *     flowDefinitionName: "example",
 *     roleArn: exampleAwsIamRole.arn,
 *     humanLoopConfig: {
 *         humanTaskUiArn: exampleAwsSagemakerHumanTaskUi.arn,
 *         taskAvailabilityLifetimeInSeconds: 1,
 *         taskCount: 1,
 *         taskDescription: "example",
 *         taskTitle: "example",
 *         workteamArn: exampleAwsSagemakerWorkteam.arn,
 *     },
 *     outputConfig: {
 *         s3OutputPath: `s3://${exampleAwsS3Bucket.bucket}/`,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.FlowDefinition("example",
 *     flow_definition_name="example",
 *     role_arn=example_aws_iam_role["arn"],
 *     human_loop_config={
 *         "human_task_ui_arn": example_aws_sagemaker_human_task_ui["arn"],
 *         "task_availability_lifetime_in_seconds": 1,
 *         "task_count": 1,
 *         "task_description": "example",
 *         "task_title": "example",
 *         "workteam_arn": example_aws_sagemaker_workteam["arn"],
 *     },
 *     output_config={
 *         "s3_output_path": f"s3://{example_aws_s3_bucket['bucket']}/",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.FlowDefinition("example", new()
 *     {
 *         FlowDefinitionName = "example",
 *         RoleArn = exampleAwsIamRole.Arn,
 *         HumanLoopConfig = new Aws.Sagemaker.Inputs.FlowDefinitionHumanLoopConfigArgs
 *         {
 *             HumanTaskUiArn = exampleAwsSagemakerHumanTaskUi.Arn,
 *             TaskAvailabilityLifetimeInSeconds = 1,
 *             TaskCount = 1,
 *             TaskDescription = "example",
 *             TaskTitle = "example",
 *             WorkteamArn = exampleAwsSagemakerWorkteam.Arn,
 *         },
 *         OutputConfig = new Aws.Sagemaker.Inputs.FlowDefinitionOutputConfigArgs
 *         {
 *             S3OutputPath = $"s3://{exampleAwsS3Bucket.Bucket}/",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewFlowDefinition(ctx, "example", &sagemaker.FlowDefinitionArgs{
 * 			FlowDefinitionName: pulumi.String("example"),
 * 			RoleArn:            pulumi.Any(exampleAwsIamRole.Arn),
 * 			HumanLoopConfig: &sagemaker.FlowDefinitionHumanLoopConfigArgs{
 * 				HumanTaskUiArn:                    pulumi.Any(exampleAwsSagemakerHumanTaskUi.Arn),
 * 				TaskAvailabilityLifetimeInSeconds: pulumi.Int(1),
 * 				TaskCount:                         pulumi.Int(1),
 * 				TaskDescription:                   pulumi.String("example"),
 * 				TaskTitle:                         pulumi.String("example"),
 * 				WorkteamArn:                       pulumi.Any(exampleAwsSagemakerWorkteam.Arn),
 * 			},
 * 			OutputConfig: &sagemaker.FlowDefinitionOutputConfigArgs{
 * 				S3OutputPath: pulumi.Sprintf("s3://%v/", exampleAwsS3Bucket.Bucket),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.FlowDefinition;
 * import com.pulumi.aws.sagemaker.FlowDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionOutputConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FlowDefinition("example", FlowDefinitionArgs.builder()
 *             .flowDefinitionName("example")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .humanLoopConfig(FlowDefinitionHumanLoopConfigArgs.builder()
 *                 .humanTaskUiArn(exampleAwsSagemakerHumanTaskUi.arn())
 *                 .taskAvailabilityLifetimeInSeconds(1)
 *                 .taskCount(1)
 *                 .taskDescription("example")
 *                 .taskTitle("example")
 *                 .workteamArn(exampleAwsSagemakerWorkteam.arn())
 *                 .build())
 *             .outputConfig(FlowDefinitionOutputConfigArgs.builder()
 *                 .s3OutputPath(String.format("s3://%s/", exampleAwsS3Bucket.bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:FlowDefinition
 *     properties:
 *       flowDefinitionName: example
 *       roleArn: ${exampleAwsIamRole.arn}
 *       humanLoopConfig:
 *         humanTaskUiArn: ${exampleAwsSagemakerHumanTaskUi.arn}
 *         taskAvailabilityLifetimeInSeconds: 1
 *         taskCount: 1
 *         taskDescription: example
 *         taskTitle: example
 *         workteamArn: ${exampleAwsSagemakerWorkteam.arn}
 *       outputConfig:
 *         s3OutputPath: s3://${exampleAwsS3Bucket.bucket}/
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Public Workteam Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.FlowDefinition("example", {
 *     flowDefinitionName: "example",
 *     roleArn: exampleAwsIamRole.arn,
 *     humanLoopConfig: {
 *         humanTaskUiArn: exampleAwsSagemakerHumanTaskUi.arn,
 *         taskAvailabilityLifetimeInSeconds: 1,
 *         taskCount: 1,
 *         taskDescription: "example",
 *         taskTitle: "example",
 *         workteamArn: `arn:aws:sagemaker:${current.name}:394669845002:workteam/public-crowd/default`,
 *         publicWorkforceTaskPrice: {
 *             amountInUsd: {
 *                 cents: 1,
 *                 tenthFractionsOfACent: 2,
 *             },
 *         },
 *     },
 *     outputConfig: {
 *         s3OutputPath: `s3://${exampleAwsS3Bucket.bucket}/`,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.FlowDefinition("example",
 *     flow_definition_name="example",
 *     role_arn=example_aws_iam_role["arn"],
 *     human_loop_config={
 *         "human_task_ui_arn": example_aws_sagemaker_human_task_ui["arn"],
 *         "task_availability_lifetime_in_seconds": 1,
 *         "task_count": 1,
 *         "task_description": "example",
 *         "task_title": "example",
 *         "workteam_arn": f"arn:aws:sagemaker:{current['name']}:394669845002:workteam/public-crowd/default",
 *         "public_workforce_task_price": {
 *             "amount_in_usd": {
 *                 "cents": 1,
 *                 "tenth_fractions_of_a_cent": 2,
 *             },
 *         },
 *     },
 *     output_config={
 *         "s3_output_path": f"s3://{example_aws_s3_bucket['bucket']}/",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.FlowDefinition("example", new()
 *     {
 *         FlowDefinitionName = "example",
 *         RoleArn = exampleAwsIamRole.Arn,
 *         HumanLoopConfig = new Aws.Sagemaker.Inputs.FlowDefinitionHumanLoopConfigArgs
 *         {
 *             HumanTaskUiArn = exampleAwsSagemakerHumanTaskUi.Arn,
 *             TaskAvailabilityLifetimeInSeconds = 1,
 *             TaskCount = 1,
 *             TaskDescription = "example",
 *             TaskTitle = "example",
 *             WorkteamArn = $"arn:aws:sagemaker:{current.Name}:394669845002:workteam/public-crowd/default",
 *             PublicWorkforceTaskPrice = new Aws.Sagemaker.Inputs.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs
 *             {
 *                 AmountInUsd = new Aws.Sagemaker.Inputs.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs
 *                 {
 *                     Cents = 1,
 *                     TenthFractionsOfACent = 2,
 *                 },
 *             },
 *         },
 *         OutputConfig = new Aws.Sagemaker.Inputs.FlowDefinitionOutputConfigArgs
 *         {
 *             S3OutputPath = $"s3://{exampleAwsS3Bucket.Bucket}/",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewFlowDefinition(ctx, "example", &sagemaker.FlowDefinitionArgs{
 * 			FlowDefinitionName: pulumi.String("example"),
 * 			RoleArn:            pulumi.Any(exampleAwsIamRole.Arn),
 * 			HumanLoopConfig: &sagemaker.FlowDefinitionHumanLoopConfigArgs{
 * 				HumanTaskUiArn:                    pulumi.Any(exampleAwsSagemakerHumanTaskUi.Arn),
 * 				TaskAvailabilityLifetimeInSeconds: pulumi.Int(1),
 * 				TaskCount:                         pulumi.Int(1),
 * 				TaskDescription:                   pulumi.String("example"),
 * 				TaskTitle:                         pulumi.String("example"),
 * 				WorkteamArn:                       pulumi.Sprintf("arn:aws:sagemaker:%v:394669845002:workteam/public-crowd/default", current.Name),
 * 				PublicWorkforceTaskPrice: &sagemaker.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs{
 * 					AmountInUsd: &sagemaker.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs{
 * 						Cents:                 pulumi.Int(1),
 * 						TenthFractionsOfACent: pulumi.Int(2),
 * 					},
 * 				},
 * 			},
 * 			OutputConfig: &sagemaker.FlowDefinitionOutputConfigArgs{
 * 				S3OutputPath: pulumi.Sprintf("s3://%v/", exampleAwsS3Bucket.Bucket),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.FlowDefinition;
 * import com.pulumi.aws.sagemaker.FlowDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionOutputConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FlowDefinition("example", FlowDefinitionArgs.builder()
 *             .flowDefinitionName("example")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .humanLoopConfig(FlowDefinitionHumanLoopConfigArgs.builder()
 *                 .humanTaskUiArn(exampleAwsSagemakerHumanTaskUi.arn())
 *                 .taskAvailabilityLifetimeInSeconds(1)
 *                 .taskCount(1)
 *                 .taskDescription("example")
 *                 .taskTitle("example")
 *                 .workteamArn(String.format("arn:aws:sagemaker:%s:394669845002:workteam/public-crowd/default", current.name()))
 *                 .publicWorkforceTaskPrice(FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs.builder()
 *                     .amountInUsd(FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs.builder()
 *                         .cents(1)
 *                         .tenthFractionsOfACent(2)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .outputConfig(FlowDefinitionOutputConfigArgs.builder()
 *                 .s3OutputPath(String.format("s3://%s/", exampleAwsS3Bucket.bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:FlowDefinition
 *     properties:
 *       flowDefinitionName: example
 *       roleArn: ${exampleAwsIamRole.arn}
 *       humanLoopConfig:
 *         humanTaskUiArn: ${exampleAwsSagemakerHumanTaskUi.arn}
 *         taskAvailabilityLifetimeInSeconds: 1
 *         taskCount: 1
 *         taskDescription: example
 *         taskTitle: example
 *         workteamArn: arn:aws:sagemaker:${current.name}:394669845002:workteam/public-crowd/default
 *         publicWorkforceTaskPrice:
 *           amountInUsd:
 *             cents: 1
 *             tenthFractionsOfACent: 2
 *       outputConfig:
 *         s3OutputPath: s3://${exampleAwsS3Bucket.bucket}/
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Human Loop Activation Config Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.FlowDefinition("example", {
 *     flowDefinitionName: "example",
 *     roleArn: exampleAwsIamRole.arn,
 *     humanLoopConfig: {
 *         humanTaskUiArn: exampleAwsSagemakerHumanTaskUi.arn,
 *         taskAvailabilityLifetimeInSeconds: 1,
 *         taskCount: 1,
 *         taskDescription: "example",
 *         taskTitle: "example",
 *         workteamArn: exampleAwsSagemakerWorkteam.arn,
 *     },
 *     humanLoopRequestSource: {
 *         awsManagedHumanLoopRequestSource: "AWS/Textract/AnalyzeDocument/Forms/V1",
 *     },
 *     humanLoopActivationConfig: {
 *         humanLoopActivationConditionsConfig: {
 *             humanLoopActivationConditions: `        {
 * \x09\x09\x09"Conditions": [
 * \x09\x09\x09  {
 * \x09\x09\x09\x09"ConditionType": "Sampling",
 * \x09\x09\x09\x09"ConditionParameters": {
 * \x09\x09\x09\x09  "RandomSamplingPercentage": 5
 * \x09\x09\x09\x09}
 * \x09\x09\x09  }
 * \x09\x09\x09]
 * \x09\x09}
 * `,
 *         },
 *     },
 *     outputConfig: {
 *         s3OutputPath: `s3://${exampleAwsS3Bucket.bucket}/`,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.FlowDefinition("example",
 *     flow_definition_name="example",
 *     role_arn=example_aws_iam_role["arn"],
 *     human_loop_config={
 *         "human_task_ui_arn": example_aws_sagemaker_human_task_ui["arn"],
 *         "task_availability_lifetime_in_seconds": 1,
 *         "task_count": 1,
 *         "task_description": "example",
 *         "task_title": "example",
 *         "workteam_arn": example_aws_sagemaker_workteam["arn"],
 *     },
 *     human_loop_request_source={
 *         "aws_managed_human_loop_request_source": "AWS/Textract/AnalyzeDocument/Forms/V1",
 *     },
 *     human_loop_activation_config={
 *         "human_loop_activation_conditions_config": {
 *             "human_loop_activation_conditions": """        {
 * \x09\x09\x09"Conditions": [
 * \x09\x09\x09  {
 * \x09\x09\x09\x09"ConditionType": "Sampling",
 * \x09\x09\x09\x09"ConditionParameters": {
 * \x09\x09\x09\x09  "RandomSamplingPercentage": 5
 * \x09\x09\x09\x09}
 * \x09\x09\x09  }
 * \x09\x09\x09]
 * \x09\x09}
 * """,
 *         },
 *     },
 *     output_config={
 *         "s3_output_path": f"s3://{example_aws_s3_bucket['bucket']}/",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.FlowDefinition("example", new()
 *     {
 *         FlowDefinitionName = "example",
 *         RoleArn = exampleAwsIamRole.Arn,
 *         HumanLoopConfig = new Aws.Sagemaker.Inputs.FlowDefinitionHumanLoopConfigArgs
 *         {
 *             HumanTaskUiArn = exampleAwsSagemakerHumanTaskUi.Arn,
 *             TaskAvailabilityLifetimeInSeconds = 1,
 *             TaskCount = 1,
 *             TaskDescription = "example",
 *             TaskTitle = "example",
 *             WorkteamArn = exampleAwsSagemakerWorkteam.Arn,
 *         },
 *         HumanLoopRequestSource = new Aws.Sagemaker.Inputs.FlowDefinitionHumanLoopRequestSourceArgs
 *         {
 *             AwsManagedHumanLoopRequestSource = "AWS/Textract/AnalyzeDocument/Forms/V1",
 *         },
 *         HumanLoopActivationConfig = new Aws.Sagemaker.Inputs.FlowDefinitionHumanLoopActivationConfigArgs
 *         {
 *             HumanLoopActivationConditionsConfig = new Aws.Sagemaker.Inputs.FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs
 *             {
 *                 HumanLoopActivationConditions = @"        {
 * 			""Conditions"": [
 * 			  {
 * 				""ConditionType"": ""Sampling"",
 * 				""ConditionParameters"": {
 * 				  ""RandomSamplingPercentage"": 5
 * 				}
 * 			  }
 * 			]
 * 		}
 * ",
 *             },
 *         },
 *         OutputConfig = new Aws.Sagemaker.Inputs.FlowDefinitionOutputConfigArgs
 *         {
 *             S3OutputPath = $"s3://{exampleAwsS3Bucket.Bucket}/",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewFlowDefinition(ctx, "example", &sagemaker.FlowDefinitionArgs{
 * 			FlowDefinitionName: pulumi.String("example"),
 * 			RoleArn:            pulumi.Any(exampleAwsIamRole.Arn),
 * 			HumanLoopConfig: &sagemaker.FlowDefinitionHumanLoopConfigArgs{
 * 				HumanTaskUiArn:                    pulumi.Any(exampleAwsSagemakerHumanTaskUi.Arn),
 * 				TaskAvailabilityLifetimeInSeconds: pulumi.Int(1),
 * 				TaskCount:                         pulumi.Int(1),
 * 				TaskDescription:                   pulumi.String("example"),
 * 				TaskTitle:                         pulumi.String("example"),
 * 				WorkteamArn:                       pulumi.Any(exampleAwsSagemakerWorkteam.Arn),
 * 			},
 * 			HumanLoopRequestSource: &sagemaker.FlowDefinitionHumanLoopRequestSourceArgs{
 * 				AwsManagedHumanLoopRequestSource: pulumi.String("AWS/Textract/AnalyzeDocument/Forms/V1"),
 * 			},
 * 			HumanLoopActivationConfig: &sagemaker.FlowDefinitionHumanLoopActivationConfigArgs{
 * 				HumanLoopActivationConditionsConfig: &sagemaker.FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs{
 * 					HumanLoopActivationConditions: pulumi.String(`        {
 * 			"Conditions": [
 * 			  {
 * 				"ConditionType": "Sampling",
 * 				"ConditionParameters": {
 * 				  "RandomSamplingPercentage": 5
 * 				}
 * 			  }
 * 			]
 * 		}
 * `),
 * 				},
 * 			},
 * 			OutputConfig: &sagemaker.FlowDefinitionOutputConfigArgs{
 * 				S3OutputPath: pulumi.Sprintf("s3://%v/", exampleAwsS3Bucket.Bucket),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.FlowDefinition;
 * import com.pulumi.aws.sagemaker.FlowDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopRequestSourceArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopActivationConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionOutputConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FlowDefinition("example", FlowDefinitionArgs.builder()
 *             .flowDefinitionName("example")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .humanLoopConfig(FlowDefinitionHumanLoopConfigArgs.builder()
 *                 .humanTaskUiArn(exampleAwsSagemakerHumanTaskUi.arn())
 *                 .taskAvailabilityLifetimeInSeconds(1)
 *                 .taskCount(1)
 *                 .taskDescription("example")
 *                 .taskTitle("example")
 *                 .workteamArn(exampleAwsSagemakerWorkteam.arn())
 *                 .build())
 *             .humanLoopRequestSource(FlowDefinitionHumanLoopRequestSourceArgs.builder()
 *                 .awsManagedHumanLoopRequestSource("AWS/Textract/AnalyzeDocument/Forms/V1")
 *                 .build())
 *             .humanLoopActivationConfig(FlowDefinitionHumanLoopActivationConfigArgs.builder()
 *                 .humanLoopActivationConditionsConfig(FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs.builder()
 *                     .humanLoopActivationConditions("""
 *         {
 * 			"Conditions": [
 * 			  {
 * 				"ConditionType": "Sampling",
 * 				"ConditionParameters": {
 * 				  "RandomSamplingPercentage": 5
 * 				}
 * 			  }
 * 			]
 * 		}
 *                     """)
 *                     .build())
 *                 .build())
 *             .outputConfig(FlowDefinitionOutputConfigArgs.builder()
 *                 .s3OutputPath(String.format("s3://%s/", exampleAwsS3Bucket.bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:FlowDefinition
 *     properties:
 *       flowDefinitionName: example
 *       roleArn: ${exampleAwsIamRole.arn}
 *       humanLoopConfig:
 *         humanTaskUiArn: ${exampleAwsSagemakerHumanTaskUi.arn}
 *         taskAvailabilityLifetimeInSeconds: 1
 *         taskCount: 1
 *         taskDescription: example
 *         taskTitle: example
 *         workteamArn: ${exampleAwsSagemakerWorkteam.arn}
 *       humanLoopRequestSource:
 *         awsManagedHumanLoopRequestSource: AWS/Textract/AnalyzeDocument/Forms/V1
 *       humanLoopActivationConfig:
 *         humanLoopActivationConditionsConfig:
 *           humanLoopActivationConditions: |2
 *                     {
 *             			"Conditions": [
 *             			  {
 *             				"ConditionType": "Sampling",
 *             				"ConditionParameters": {
 *             				  "RandomSamplingPercentage": 5
 *             				}
 *             			  }
 *             			]
 *             		}
 *       outputConfig:
 *         s3OutputPath: s3://${exampleAwsS3Bucket.bucket}/
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker Flow Definitions using the `flow_definition_name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/flowDefinition:FlowDefinition example example
 * ```
 */
public class FlowDefinition internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.FlowDefinition,
) : KotlinCustomResource(javaResource, FlowDefinitionMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this Flow Definition.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of your flow definition.
     */
    public val flowDefinitionName: Output<String>
        get() = javaResource.flowDefinitionName().applyValue({ args0 -> args0 })

    /**
     * An object containing information about the events that trigger a human workflow. See Human Loop Activation Config details below.
     */
    public val humanLoopActivationConfig: Output<FlowDefinitionHumanLoopActivationConfig>?
        get() = javaResource.humanLoopActivationConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    flowDefinitionHumanLoopActivationConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * An object containing information about the tasks the human reviewers will perform. See Human Loop Config details below.
     */
    public val humanLoopConfig: Output<FlowDefinitionHumanLoopConfig>
        get() = javaResource.humanLoopConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                flowDefinitionHumanLoopConfigToKotlin(args0)
            })
        })

    /**
     * Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or Amazon Textract is used as an integration source. See Human Loop Request Source details below.
     */
    public val humanLoopRequestSource: Output<FlowDefinitionHumanLoopRequestSource>?
        get() = javaResource.humanLoopRequestSource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> flowDefinitionHumanLoopRequestSourceToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * An object containing information about where the human review results will be uploaded. See Output Config details below.
     */
    public val outputConfig: Output<FlowDefinitionOutputConfig>
        get() = javaResource.outputConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                flowDefinitionOutputConfigToKotlin(args0)
            })
        })

    /**
     * The Amazon Resource Name (ARN) of the role needed to call other services on your behalf.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object FlowDefinitionMapper : ResourceMapper<FlowDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.FlowDefinition::class == javaResource::class

    override fun map(javaResource: Resource): FlowDefinition = FlowDefinition(
        javaResource as
            com.pulumi.aws.sagemaker.FlowDefinition,
    )
}

/**
 * @see [FlowDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FlowDefinition].
 */
public suspend fun flowDefinition(
    name: String,
    block: suspend FlowDefinitionResourceBuilder.() -> Unit,
): FlowDefinition {
    val builder = FlowDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FlowDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun flowDefinition(name: String): FlowDefinition {
    val builder = FlowDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
