@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.FlowDefinitionArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.FlowDefinitionHumanLoopActivationConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.FlowDefinitionHumanLoopActivationConfigArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.FlowDefinitionHumanLoopConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.FlowDefinitionHumanLoopConfigArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.FlowDefinitionHumanLoopRequestSourceArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.FlowDefinitionHumanLoopRequestSourceArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.FlowDefinitionOutputConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.FlowDefinitionOutputConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Flow Definition resource.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.FlowDefinition("example", {
 *     flowDefinitionName: "example",
 *     roleArn: exampleAwsIamRole.arn,
 *     humanLoopConfig: {
 *         humanTaskUiArn: exampleAwsSagemakerHumanTaskUi.arn,
 *         taskAvailabilityLifetimeInSeconds: 1,
 *         taskCount: 1,
 *         taskDescription: "example",
 *         taskTitle: "example",
 *         workteamArn: exampleAwsSagemakerWorkteam.arn,
 *     },
 *     outputConfig: {
 *         s3OutputPath: `s3://${exampleAwsS3Bucket.bucket}/`,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.FlowDefinition("example",
 *     flow_definition_name="example",
 *     role_arn=example_aws_iam_role["arn"],
 *     human_loop_config={
 *         "human_task_ui_arn": example_aws_sagemaker_human_task_ui["arn"],
 *         "task_availability_lifetime_in_seconds": 1,
 *         "task_count": 1,
 *         "task_description": "example",
 *         "task_title": "example",
 *         "workteam_arn": example_aws_sagemaker_workteam["arn"],
 *     },
 *     output_config={
 *         "s3_output_path": f"s3://{example_aws_s3_bucket['bucket']}/",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.FlowDefinition("example", new()
 *     {
 *         FlowDefinitionName = "example",
 *         RoleArn = exampleAwsIamRole.Arn,
 *         HumanLoopConfig = new Aws.Sagemaker.Inputs.FlowDefinitionHumanLoopConfigArgs
 *         {
 *             HumanTaskUiArn = exampleAwsSagemakerHumanTaskUi.Arn,
 *             TaskAvailabilityLifetimeInSeconds = 1,
 *             TaskCount = 1,
 *             TaskDescription = "example",
 *             TaskTitle = "example",
 *             WorkteamArn = exampleAwsSagemakerWorkteam.Arn,
 *         },
 *         OutputConfig = new Aws.Sagemaker.Inputs.FlowDefinitionOutputConfigArgs
 *         {
 *             S3OutputPath = $"s3://{exampleAwsS3Bucket.Bucket}/",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewFlowDefinition(ctx, "example", &sagemaker.FlowDefinitionArgs{
 * 			FlowDefinitionName: pulumi.String("example"),
 * 			RoleArn:            pulumi.Any(exampleAwsIamRole.Arn),
 * 			HumanLoopConfig: &sagemaker.FlowDefinitionHumanLoopConfigArgs{
 * 				HumanTaskUiArn:                    pulumi.Any(exampleAwsSagemakerHumanTaskUi.Arn),
 * 				TaskAvailabilityLifetimeInSeconds: pulumi.Int(1),
 * 				TaskCount:                         pulumi.Int(1),
 * 				TaskDescription:                   pulumi.String("example"),
 * 				TaskTitle:                         pulumi.String("example"),
 * 				WorkteamArn:                       pulumi.Any(exampleAwsSagemakerWorkteam.Arn),
 * 			},
 * 			OutputConfig: &sagemaker.FlowDefinitionOutputConfigArgs{
 * 				S3OutputPath: pulumi.Sprintf("s3://%v/", exampleAwsS3Bucket.Bucket),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.FlowDefinition;
 * import com.pulumi.aws.sagemaker.FlowDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionOutputConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FlowDefinition("example", FlowDefinitionArgs.builder()
 *             .flowDefinitionName("example")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .humanLoopConfig(FlowDefinitionHumanLoopConfigArgs.builder()
 *                 .humanTaskUiArn(exampleAwsSagemakerHumanTaskUi.arn())
 *                 .taskAvailabilityLifetimeInSeconds(1)
 *                 .taskCount(1)
 *                 .taskDescription("example")
 *                 .taskTitle("example")
 *                 .workteamArn(exampleAwsSagemakerWorkteam.arn())
 *                 .build())
 *             .outputConfig(FlowDefinitionOutputConfigArgs.builder()
 *                 .s3OutputPath(String.format("s3://%s/", exampleAwsS3Bucket.bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:FlowDefinition
 *     properties:
 *       flowDefinitionName: example
 *       roleArn: ${exampleAwsIamRole.arn}
 *       humanLoopConfig:
 *         humanTaskUiArn: ${exampleAwsSagemakerHumanTaskUi.arn}
 *         taskAvailabilityLifetimeInSeconds: 1
 *         taskCount: 1
 *         taskDescription: example
 *         taskTitle: example
 *         workteamArn: ${exampleAwsSagemakerWorkteam.arn}
 *       outputConfig:
 *         s3OutputPath: s3://${exampleAwsS3Bucket.bucket}/
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Public Workteam Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.FlowDefinition("example", {
 *     flowDefinitionName: "example",
 *     roleArn: exampleAwsIamRole.arn,
 *     humanLoopConfig: {
 *         humanTaskUiArn: exampleAwsSagemakerHumanTaskUi.arn,
 *         taskAvailabilityLifetimeInSeconds: 1,
 *         taskCount: 1,
 *         taskDescription: "example",
 *         taskTitle: "example",
 *         workteamArn: `arn:aws:sagemaker:${current.name}:394669845002:workteam/public-crowd/default`,
 *         publicWorkforceTaskPrice: {
 *             amountInUsd: {
 *                 cents: 1,
 *                 tenthFractionsOfACent: 2,
 *             },
 *         },
 *     },
 *     outputConfig: {
 *         s3OutputPath: `s3://${exampleAwsS3Bucket.bucket}/`,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.FlowDefinition("example",
 *     flow_definition_name="example",
 *     role_arn=example_aws_iam_role["arn"],
 *     human_loop_config={
 *         "human_task_ui_arn": example_aws_sagemaker_human_task_ui["arn"],
 *         "task_availability_lifetime_in_seconds": 1,
 *         "task_count": 1,
 *         "task_description": "example",
 *         "task_title": "example",
 *         "workteam_arn": f"arn:aws:sagemaker:{current['name']}:394669845002:workteam/public-crowd/default",
 *         "public_workforce_task_price": {
 *             "amount_in_usd": {
 *                 "cents": 1,
 *                 "tenth_fractions_of_a_cent": 2,
 *             },
 *         },
 *     },
 *     output_config={
 *         "s3_output_path": f"s3://{example_aws_s3_bucket['bucket']}/",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.FlowDefinition("example", new()
 *     {
 *         FlowDefinitionName = "example",
 *         RoleArn = exampleAwsIamRole.Arn,
 *         HumanLoopConfig = new Aws.Sagemaker.Inputs.FlowDefinitionHumanLoopConfigArgs
 *         {
 *             HumanTaskUiArn = exampleAwsSagemakerHumanTaskUi.Arn,
 *             TaskAvailabilityLifetimeInSeconds = 1,
 *             TaskCount = 1,
 *             TaskDescription = "example",
 *             TaskTitle = "example",
 *             WorkteamArn = $"arn:aws:sagemaker:{current.Name}:394669845002:workteam/public-crowd/default",
 *             PublicWorkforceTaskPrice = new Aws.Sagemaker.Inputs.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs
 *             {
 *                 AmountInUsd = new Aws.Sagemaker.Inputs.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs
 *                 {
 *                     Cents = 1,
 *                     TenthFractionsOfACent = 2,
 *                 },
 *             },
 *         },
 *         OutputConfig = new Aws.Sagemaker.Inputs.FlowDefinitionOutputConfigArgs
 *         {
 *             S3OutputPath = $"s3://{exampleAwsS3Bucket.Bucket}/",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewFlowDefinition(ctx, "example", &sagemaker.FlowDefinitionArgs{
 * 			FlowDefinitionName: pulumi.String("example"),
 * 			RoleArn:            pulumi.Any(exampleAwsIamRole.Arn),
 * 			HumanLoopConfig: &sagemaker.FlowDefinitionHumanLoopConfigArgs{
 * 				HumanTaskUiArn:                    pulumi.Any(exampleAwsSagemakerHumanTaskUi.Arn),
 * 				TaskAvailabilityLifetimeInSeconds: pulumi.Int(1),
 * 				TaskCount:                         pulumi.Int(1),
 * 				TaskDescription:                   pulumi.String("example"),
 * 				TaskTitle:                         pulumi.String("example"),
 * 				WorkteamArn:                       pulumi.Sprintf("arn:aws:sagemaker:%v:394669845002:workteam/public-crowd/default", current.Name),
 * 				PublicWorkforceTaskPrice: &sagemaker.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs{
 * 					AmountInUsd: &sagemaker.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs{
 * 						Cents:                 pulumi.Int(1),
 * 						TenthFractionsOfACent: pulumi.Int(2),
 * 					},
 * 				},
 * 			},
 * 			OutputConfig: &sagemaker.FlowDefinitionOutputConfigArgs{
 * 				S3OutputPath: pulumi.Sprintf("s3://%v/", exampleAwsS3Bucket.Bucket),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.FlowDefinition;
 * import com.pulumi.aws.sagemaker.FlowDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionOutputConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FlowDefinition("example", FlowDefinitionArgs.builder()
 *             .flowDefinitionName("example")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .humanLoopConfig(FlowDefinitionHumanLoopConfigArgs.builder()
 *                 .humanTaskUiArn(exampleAwsSagemakerHumanTaskUi.arn())
 *                 .taskAvailabilityLifetimeInSeconds(1)
 *                 .taskCount(1)
 *                 .taskDescription("example")
 *                 .taskTitle("example")
 *                 .workteamArn(String.format("arn:aws:sagemaker:%s:394669845002:workteam/public-crowd/default", current.name()))
 *                 .publicWorkforceTaskPrice(FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs.builder()
 *                     .amountInUsd(FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs.builder()
 *                         .cents(1)
 *                         .tenthFractionsOfACent(2)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .outputConfig(FlowDefinitionOutputConfigArgs.builder()
 *                 .s3OutputPath(String.format("s3://%s/", exampleAwsS3Bucket.bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:FlowDefinition
 *     properties:
 *       flowDefinitionName: example
 *       roleArn: ${exampleAwsIamRole.arn}
 *       humanLoopConfig:
 *         humanTaskUiArn: ${exampleAwsSagemakerHumanTaskUi.arn}
 *         taskAvailabilityLifetimeInSeconds: 1
 *         taskCount: 1
 *         taskDescription: example
 *         taskTitle: example
 *         workteamArn: arn:aws:sagemaker:${current.name}:394669845002:workteam/public-crowd/default
 *         publicWorkforceTaskPrice:
 *           amountInUsd:
 *             cents: 1
 *             tenthFractionsOfACent: 2
 *       outputConfig:
 *         s3OutputPath: s3://${exampleAwsS3Bucket.bucket}/
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Human Loop Activation Config Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.FlowDefinition("example", {
 *     flowDefinitionName: "example",
 *     roleArn: exampleAwsIamRole.arn,
 *     humanLoopConfig: {
 *         humanTaskUiArn: exampleAwsSagemakerHumanTaskUi.arn,
 *         taskAvailabilityLifetimeInSeconds: 1,
 *         taskCount: 1,
 *         taskDescription: "example",
 *         taskTitle: "example",
 *         workteamArn: exampleAwsSagemakerWorkteam.arn,
 *     },
 *     humanLoopRequestSource: {
 *         awsManagedHumanLoopRequestSource: "AWS/Textract/AnalyzeDocument/Forms/V1",
 *     },
 *     humanLoopActivationConfig: {
 *         humanLoopActivationConditionsConfig: {
 *             humanLoopActivationConditions: `        {
 * \x09\x09\x09"Conditions": [
 * \x09\x09\x09  {
 * \x09\x09\x09\x09"ConditionType": "Sampling",
 * \x09\x09\x09\x09"ConditionParameters": {
 * \x09\x09\x09\x09  "RandomSamplingPercentage": 5
 * \x09\x09\x09\x09}
 * \x09\x09\x09  }
 * \x09\x09\x09]
 * \x09\x09}
 * `,
 *         },
 *     },
 *     outputConfig: {
 *         s3OutputPath: `s3://${exampleAwsS3Bucket.bucket}/`,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.FlowDefinition("example",
 *     flow_definition_name="example",
 *     role_arn=example_aws_iam_role["arn"],
 *     human_loop_config={
 *         "human_task_ui_arn": example_aws_sagemaker_human_task_ui["arn"],
 *         "task_availability_lifetime_in_seconds": 1,
 *         "task_count": 1,
 *         "task_description": "example",
 *         "task_title": "example",
 *         "workteam_arn": example_aws_sagemaker_workteam["arn"],
 *     },
 *     human_loop_request_source={
 *         "aws_managed_human_loop_request_source": "AWS/Textract/AnalyzeDocument/Forms/V1",
 *     },
 *     human_loop_activation_config={
 *         "human_loop_activation_conditions_config": {
 *             "human_loop_activation_conditions": """        {
 * \x09\x09\x09"Conditions": [
 * \x09\x09\x09  {
 * \x09\x09\x09\x09"ConditionType": "Sampling",
 * \x09\x09\x09\x09"ConditionParameters": {
 * \x09\x09\x09\x09  "RandomSamplingPercentage": 5
 * \x09\x09\x09\x09}
 * \x09\x09\x09  }
 * \x09\x09\x09]
 * \x09\x09}
 * """,
 *         },
 *     },
 *     output_config={
 *         "s3_output_path": f"s3://{example_aws_s3_bucket['bucket']}/",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.FlowDefinition("example", new()
 *     {
 *         FlowDefinitionName = "example",
 *         RoleArn = exampleAwsIamRole.Arn,
 *         HumanLoopConfig = new Aws.Sagemaker.Inputs.FlowDefinitionHumanLoopConfigArgs
 *         {
 *             HumanTaskUiArn = exampleAwsSagemakerHumanTaskUi.Arn,
 *             TaskAvailabilityLifetimeInSeconds = 1,
 *             TaskCount = 1,
 *             TaskDescription = "example",
 *             TaskTitle = "example",
 *             WorkteamArn = exampleAwsSagemakerWorkteam.Arn,
 *         },
 *         HumanLoopRequestSource = new Aws.Sagemaker.Inputs.FlowDefinitionHumanLoopRequestSourceArgs
 *         {
 *             AwsManagedHumanLoopRequestSource = "AWS/Textract/AnalyzeDocument/Forms/V1",
 *         },
 *         HumanLoopActivationConfig = new Aws.Sagemaker.Inputs.FlowDefinitionHumanLoopActivationConfigArgs
 *         {
 *             HumanLoopActivationConditionsConfig = new Aws.Sagemaker.Inputs.FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs
 *             {
 *                 HumanLoopActivationConditions = @"        {
 * 			""Conditions"": [
 * 			  {
 * 				""ConditionType"": ""Sampling"",
 * 				""ConditionParameters"": {
 * 				  ""RandomSamplingPercentage"": 5
 * 				}
 * 			  }
 * 			]
 * 		}
 * ",
 *             },
 *         },
 *         OutputConfig = new Aws.Sagemaker.Inputs.FlowDefinitionOutputConfigArgs
 *         {
 *             S3OutputPath = $"s3://{exampleAwsS3Bucket.Bucket}/",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewFlowDefinition(ctx, "example", &sagemaker.FlowDefinitionArgs{
 * 			FlowDefinitionName: pulumi.String("example"),
 * 			RoleArn:            pulumi.Any(exampleAwsIamRole.Arn),
 * 			HumanLoopConfig: &sagemaker.FlowDefinitionHumanLoopConfigArgs{
 * 				HumanTaskUiArn:                    pulumi.Any(exampleAwsSagemakerHumanTaskUi.Arn),
 * 				TaskAvailabilityLifetimeInSeconds: pulumi.Int(1),
 * 				TaskCount:                         pulumi.Int(1),
 * 				TaskDescription:                   pulumi.String("example"),
 * 				TaskTitle:                         pulumi.String("example"),
 * 				WorkteamArn:                       pulumi.Any(exampleAwsSagemakerWorkteam.Arn),
 * 			},
 * 			HumanLoopRequestSource: &sagemaker.FlowDefinitionHumanLoopRequestSourceArgs{
 * 				AwsManagedHumanLoopRequestSource: pulumi.String("AWS/Textract/AnalyzeDocument/Forms/V1"),
 * 			},
 * 			HumanLoopActivationConfig: &sagemaker.FlowDefinitionHumanLoopActivationConfigArgs{
 * 				HumanLoopActivationConditionsConfig: &sagemaker.FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs{
 * 					HumanLoopActivationConditions: pulumi.String(`        {
 * 			"Conditions": [
 * 			  {
 * 				"ConditionType": "Sampling",
 * 				"ConditionParameters": {
 * 				  "RandomSamplingPercentage": 5
 * 				}
 * 			  }
 * 			]
 * 		}
 * `),
 * 				},
 * 			},
 * 			OutputConfig: &sagemaker.FlowDefinitionOutputConfigArgs{
 * 				S3OutputPath: pulumi.Sprintf("s3://%v/", exampleAwsS3Bucket.Bucket),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.FlowDefinition;
 * import com.pulumi.aws.sagemaker.FlowDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopRequestSourceArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopActivationConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs;
 * import com.pulumi.aws.sagemaker.inputs.FlowDefinitionOutputConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FlowDefinition("example", FlowDefinitionArgs.builder()
 *             .flowDefinitionName("example")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .humanLoopConfig(FlowDefinitionHumanLoopConfigArgs.builder()
 *                 .humanTaskUiArn(exampleAwsSagemakerHumanTaskUi.arn())
 *                 .taskAvailabilityLifetimeInSeconds(1)
 *                 .taskCount(1)
 *                 .taskDescription("example")
 *                 .taskTitle("example")
 *                 .workteamArn(exampleAwsSagemakerWorkteam.arn())
 *                 .build())
 *             .humanLoopRequestSource(FlowDefinitionHumanLoopRequestSourceArgs.builder()
 *                 .awsManagedHumanLoopRequestSource("AWS/Textract/AnalyzeDocument/Forms/V1")
 *                 .build())
 *             .humanLoopActivationConfig(FlowDefinitionHumanLoopActivationConfigArgs.builder()
 *                 .humanLoopActivationConditionsConfig(FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs.builder()
 *                     .humanLoopActivationConditions("""
 *         {
 * 			"Conditions": [
 * 			  {
 * 				"ConditionType": "Sampling",
 * 				"ConditionParameters": {
 * 				  "RandomSamplingPercentage": 5
 * 				}
 * 			  }
 * 			]
 * 		}
 *                     """)
 *                     .build())
 *                 .build())
 *             .outputConfig(FlowDefinitionOutputConfigArgs.builder()
 *                 .s3OutputPath(String.format("s3://%s/", exampleAwsS3Bucket.bucket()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:FlowDefinition
 *     properties:
 *       flowDefinitionName: example
 *       roleArn: ${exampleAwsIamRole.arn}
 *       humanLoopConfig:
 *         humanTaskUiArn: ${exampleAwsSagemakerHumanTaskUi.arn}
 *         taskAvailabilityLifetimeInSeconds: 1
 *         taskCount: 1
 *         taskDescription: example
 *         taskTitle: example
 *         workteamArn: ${exampleAwsSagemakerWorkteam.arn}
 *       humanLoopRequestSource:
 *         awsManagedHumanLoopRequestSource: AWS/Textract/AnalyzeDocument/Forms/V1
 *       humanLoopActivationConfig:
 *         humanLoopActivationConditionsConfig:
 *           humanLoopActivationConditions: |2
 *                     {
 *             			"Conditions": [
 *             			  {
 *             				"ConditionType": "Sampling",
 *             				"ConditionParameters": {
 *             				  "RandomSamplingPercentage": 5
 *             				}
 *             			  }
 *             			]
 *             		}
 *       outputConfig:
 *         s3OutputPath: s3://${exampleAwsS3Bucket.bucket}/
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker Flow Definitions using the `flow_definition_name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/flowDefinition:FlowDefinition example example
 * ```
 * @property flowDefinitionName The name of your flow definition.
 * @property humanLoopActivationConfig An object containing information about the events that trigger a human workflow. See Human Loop Activation Config details below.
 * @property humanLoopConfig An object containing information about the tasks the human reviewers will perform. See Human Loop Config details below.
 * @property humanLoopRequestSource Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or Amazon Textract is used as an integration source. See Human Loop Request Source details below.
 * @property outputConfig An object containing information about where the human review results will be uploaded. See Output Config details below.
 * @property roleArn The Amazon Resource Name (ARN) of the role needed to call other services on your behalf.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class FlowDefinitionArgs(
    public val flowDefinitionName: Output<String>? = null,
    public val humanLoopActivationConfig: Output<FlowDefinitionHumanLoopActivationConfigArgs>? = null,
    public val humanLoopConfig: Output<FlowDefinitionHumanLoopConfigArgs>? = null,
    public val humanLoopRequestSource: Output<FlowDefinitionHumanLoopRequestSourceArgs>? = null,
    public val outputConfig: Output<FlowDefinitionOutputConfigArgs>? = null,
    public val roleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.FlowDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.FlowDefinitionArgs =
        com.pulumi.aws.sagemaker.FlowDefinitionArgs.builder()
            .flowDefinitionName(flowDefinitionName?.applyValue({ args0 -> args0 }))
            .humanLoopActivationConfig(
                humanLoopActivationConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .humanLoopConfig(humanLoopConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .humanLoopRequestSource(
                humanLoopRequestSource?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .outputConfig(outputConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FlowDefinitionArgs].
 */
@PulumiTagMarker
public class FlowDefinitionArgsBuilder internal constructor() {
    private var flowDefinitionName: Output<String>? = null

    private var humanLoopActivationConfig: Output<FlowDefinitionHumanLoopActivationConfigArgs>? = null

    private var humanLoopConfig: Output<FlowDefinitionHumanLoopConfigArgs>? = null

    private var humanLoopRequestSource: Output<FlowDefinitionHumanLoopRequestSourceArgs>? = null

    private var outputConfig: Output<FlowDefinitionOutputConfigArgs>? = null

    private var roleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of your flow definition.
     */
    @JvmName("aaqylnjuvdddbngf")
    public suspend fun flowDefinitionName(`value`: Output<String>) {
        this.flowDefinitionName = value
    }

    /**
     * @param value An object containing information about the events that trigger a human workflow. See Human Loop Activation Config details below.
     */
    @JvmName("eavtsmdactlkqkrm")
    public suspend fun humanLoopActivationConfig(`value`: Output<FlowDefinitionHumanLoopActivationConfigArgs>) {
        this.humanLoopActivationConfig = value
    }

    /**
     * @param value An object containing information about the tasks the human reviewers will perform. See Human Loop Config details below.
     */
    @JvmName("ddoikdttndiddwmp")
    public suspend fun humanLoopConfig(`value`: Output<FlowDefinitionHumanLoopConfigArgs>) {
        this.humanLoopConfig = value
    }

    /**
     * @param value Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or Amazon Textract is used as an integration source. See Human Loop Request Source details below.
     */
    @JvmName("yotcsjnxlacodats")
    public suspend fun humanLoopRequestSource(`value`: Output<FlowDefinitionHumanLoopRequestSourceArgs>) {
        this.humanLoopRequestSource = value
    }

    /**
     * @param value An object containing information about where the human review results will be uploaded. See Output Config details below.
     */
    @JvmName("mhwjpjanifmjcuqb")
    public suspend fun outputConfig(`value`: Output<FlowDefinitionOutputConfigArgs>) {
        this.outputConfig = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the role needed to call other services on your behalf.
     */
    @JvmName("ghwbnegyonsavrjt")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tvpyybvyxpumwvxp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of your flow definition.
     */
    @JvmName("lwbpaedebckishop")
    public suspend fun flowDefinitionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowDefinitionName = mapped
    }

    /**
     * @param value An object containing information about the events that trigger a human workflow. See Human Loop Activation Config details below.
     */
    @JvmName("qyukhkmhtfqcysav")
    public suspend fun humanLoopActivationConfig(`value`: FlowDefinitionHumanLoopActivationConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.humanLoopActivationConfig = mapped
    }

    /**
     * @param argument An object containing information about the events that trigger a human workflow. See Human Loop Activation Config details below.
     */
    @JvmName("iikiexihadvhtemg")
    public suspend fun humanLoopActivationConfig(argument: suspend FlowDefinitionHumanLoopActivationConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FlowDefinitionHumanLoopActivationConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.humanLoopActivationConfig = mapped
    }

    /**
     * @param value An object containing information about the tasks the human reviewers will perform. See Human Loop Config details below.
     */
    @JvmName("bmwaqlhceyrfqokk")
    public suspend fun humanLoopConfig(`value`: FlowDefinitionHumanLoopConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.humanLoopConfig = mapped
    }

    /**
     * @param argument An object containing information about the tasks the human reviewers will perform. See Human Loop Config details below.
     */
    @JvmName("rdffngovpdebuelw")
    public suspend fun humanLoopConfig(argument: suspend FlowDefinitionHumanLoopConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FlowDefinitionHumanLoopConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.humanLoopConfig = mapped
    }

    /**
     * @param value Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or Amazon Textract is used as an integration source. See Human Loop Request Source details below.
     */
    @JvmName("nykxfsmiwbbufard")
    public suspend fun humanLoopRequestSource(`value`: FlowDefinitionHumanLoopRequestSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.humanLoopRequestSource = mapped
    }

    /**
     * @param argument Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or Amazon Textract is used as an integration source. See Human Loop Request Source details below.
     */
    @JvmName("aqeoscsufiiamyxn")
    public suspend fun humanLoopRequestSource(argument: suspend FlowDefinitionHumanLoopRequestSourceArgsBuilder.() -> Unit) {
        val toBeMapped = FlowDefinitionHumanLoopRequestSourceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.humanLoopRequestSource = mapped
    }

    /**
     * @param value An object containing information about where the human review results will be uploaded. See Output Config details below.
     */
    @JvmName("vgepwaxlnthxywnq")
    public suspend fun outputConfig(`value`: FlowDefinitionOutputConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputConfig = mapped
    }

    /**
     * @param argument An object containing information about where the human review results will be uploaded. See Output Config details below.
     */
    @JvmName("xdydesmwkgppvxhp")
    public suspend fun outputConfig(argument: suspend FlowDefinitionOutputConfigArgsBuilder.() -> Unit) {
        val toBeMapped = FlowDefinitionOutputConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.outputConfig = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the role needed to call other services on your behalf.
     */
    @JvmName("njorogcygkorbidj")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wvqliiwyydnemupd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mheyrvvrqatqpnte")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FlowDefinitionArgs = FlowDefinitionArgs(
        flowDefinitionName = flowDefinitionName,
        humanLoopActivationConfig = humanLoopActivationConfig,
        humanLoopConfig = humanLoopConfig,
        humanLoopRequestSource = humanLoopRequestSource,
        outputConfig = outputConfig,
        roleArn = roleArn,
        tags = tags,
    )
}
