@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.HumanTaskUIUiTemplate
import com.pulumi.aws.sagemaker.kotlin.outputs.HumanTaskUIUiTemplate.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [HumanTaskUI].
 */
@PulumiTagMarker
public class HumanTaskUIResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HumanTaskUIArgs = HumanTaskUIArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HumanTaskUIArgsBuilder.() -> Unit) {
        val builder = HumanTaskUIArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HumanTaskUI {
        val builtJavaResource = com.pulumi.aws.sagemaker.HumanTaskUI(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return HumanTaskUI(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Human Task UI resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.sagemaker.HumanTaskUI("example", {
 *     humanTaskUiName: "example",
 *     uiTemplate: {
 *         content: std.file({
 *             input: "sagemaker-human-task-ui-template.html",
 *         }).then(invoke => invoke.result),
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.sagemaker.HumanTaskUI("example",
 *     human_task_ui_name="example",
 *     ui_template={
 *         "content": std.file(input="sagemaker-human-task-ui-template.html").result,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.HumanTaskUI("example", new()
 *     {
 *         HumanTaskUiName = "example",
 *         UiTemplate = new Aws.Sagemaker.Inputs.HumanTaskUIUiTemplateArgs
 *         {
 *             Content = Std.File.Invoke(new()
 *             {
 *                 Input = "sagemaker-human-task-ui-template.html",
 *             }).Apply(invoke => invoke.Result),
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "sagemaker-human-task-ui-template.html",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sagemaker.NewHumanTaskUI(ctx, "example", &sagemaker.HumanTaskUIArgs{
 * 			HumanTaskUiName: pulumi.String("example"),
 * 			UiTemplate: &sagemaker.HumanTaskUIUiTemplateArgs{
 * 				Content: pulumi.String(invokeFile.Result),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.HumanTaskUI;
 * import com.pulumi.aws.sagemaker.HumanTaskUIArgs;
 * import com.pulumi.aws.sagemaker.inputs.HumanTaskUIUiTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HumanTaskUI("example", HumanTaskUIArgs.builder()
 *             .humanTaskUiName("example")
 *             .uiTemplate(HumanTaskUIUiTemplateArgs.builder()
 *                 .content(StdFunctions.file(FileArgs.builder()
 *                     .input("sagemaker-human-task-ui-template.html")
 *                     .build()).result())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:HumanTaskUI
 *     properties:
 *       humanTaskUiName: example
 *       uiTemplate:
 *         content:
 *           fn::invoke:
 *             Function: std:file
 *             Arguments:
 *               input: sagemaker-human-task-ui-template.html
 *             Return: result
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker Human Task UIs using the `human_task_ui_name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/humanTaskUI:HumanTaskUI example example
 * ```
 */
public class HumanTaskUI internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.HumanTaskUI,
) : KotlinCustomResource(javaResource, HumanTaskUIMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this Human Task UI.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the Human Task UI.
     */
    public val humanTaskUiName: Output<String>
        get() = javaResource.humanTaskUiName().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The Liquid template for the worker user interface. See UI Template below.
     */
    public val uiTemplate: Output<HumanTaskUIUiTemplate>
        get() = javaResource.uiTemplate().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
}

public object HumanTaskUIMapper : ResourceMapper<HumanTaskUI> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.HumanTaskUI::class == javaResource::class

    override fun map(javaResource: Resource): HumanTaskUI = HumanTaskUI(
        javaResource as
            com.pulumi.aws.sagemaker.HumanTaskUI,
    )
}

/**
 * @see [HumanTaskUI].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HumanTaskUI].
 */
public suspend fun humanTaskUI(name: String, block: suspend HumanTaskUIResourceBuilder.() -> Unit): HumanTaskUI {
    val builder = HumanTaskUIResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HumanTaskUI].
 * @param name The _unique_ name of the resulting resource.
 */
public fun humanTaskUI(name: String): HumanTaskUI {
    val builder = HumanTaskUIResourceBuilder()
    builder.name(name)
    return builder.build()
}
