@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.HumanTaskUIArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.HumanTaskUIUiTemplateArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.HumanTaskUIUiTemplateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Human Task UI resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.sagemaker.HumanTaskUI("example", {
 *     humanTaskUiName: "example",
 *     uiTemplate: {
 *         content: std.file({
 *             input: "sagemaker-human-task-ui-template.html",
 *         }).then(invoke => invoke.result),
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.sagemaker.HumanTaskUI("example",
 *     human_task_ui_name="example",
 *     ui_template={
 *         "content": std.file(input="sagemaker-human-task-ui-template.html").result,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.HumanTaskUI("example", new()
 *     {
 *         HumanTaskUiName = "example",
 *         UiTemplate = new Aws.Sagemaker.Inputs.HumanTaskUIUiTemplateArgs
 *         {
 *             Content = Std.File.Invoke(new()
 *             {
 *                 Input = "sagemaker-human-task-ui-template.html",
 *             }).Apply(invoke => invoke.Result),
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "sagemaker-human-task-ui-template.html",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sagemaker.NewHumanTaskUI(ctx, "example", &sagemaker.HumanTaskUIArgs{
 * 			HumanTaskUiName: pulumi.String("example"),
 * 			UiTemplate: &sagemaker.HumanTaskUIUiTemplateArgs{
 * 				Content: pulumi.String(invokeFile.Result),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.HumanTaskUI;
 * import com.pulumi.aws.sagemaker.HumanTaskUIArgs;
 * import com.pulumi.aws.sagemaker.inputs.HumanTaskUIUiTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HumanTaskUI("example", HumanTaskUIArgs.builder()
 *             .humanTaskUiName("example")
 *             .uiTemplate(HumanTaskUIUiTemplateArgs.builder()
 *                 .content(StdFunctions.file(FileArgs.builder()
 *                     .input("sagemaker-human-task-ui-template.html")
 *                     .build()).result())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:HumanTaskUI
 *     properties:
 *       humanTaskUiName: example
 *       uiTemplate:
 *         content:
 *           fn::invoke:
 *             Function: std:file
 *             Arguments:
 *               input: sagemaker-human-task-ui-template.html
 *             Return: result
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker Human Task UIs using the `human_task_ui_name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/humanTaskUI:HumanTaskUI example example
 * ```
 * @property humanTaskUiName The name of the Human Task UI.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property uiTemplate The Liquid template for the worker user interface. See UI Template below.
 */
public data class HumanTaskUIArgs(
    public val humanTaskUiName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val uiTemplate: Output<HumanTaskUIUiTemplateArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.HumanTaskUIArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.HumanTaskUIArgs =
        com.pulumi.aws.sagemaker.HumanTaskUIArgs.builder()
            .humanTaskUiName(humanTaskUiName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .uiTemplate(uiTemplate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [HumanTaskUIArgs].
 */
@PulumiTagMarker
public class HumanTaskUIArgsBuilder internal constructor() {
    private var humanTaskUiName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var uiTemplate: Output<HumanTaskUIUiTemplateArgs>? = null

    /**
     * @param value The name of the Human Task UI.
     */
    @JvmName("lajwjqckaxuhesah")
    public suspend fun humanTaskUiName(`value`: Output<String>) {
        this.humanTaskUiName = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gjrclxkjymxxblrd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Liquid template for the worker user interface. See UI Template below.
     */
    @JvmName("qcvuyjcjomhdbgse")
    public suspend fun uiTemplate(`value`: Output<HumanTaskUIUiTemplateArgs>) {
        this.uiTemplate = value
    }

    /**
     * @param value The name of the Human Task UI.
     */
    @JvmName("hjksisargvhomixt")
    public suspend fun humanTaskUiName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.humanTaskUiName = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ebqhliasytschagk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("puqqncpcmrkijwel")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Liquid template for the worker user interface. See UI Template below.
     */
    @JvmName("ebkcvauyewqxqvsd")
    public suspend fun uiTemplate(`value`: HumanTaskUIUiTemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uiTemplate = mapped
    }

    /**
     * @param argument The Liquid template for the worker user interface. See UI Template below.
     */
    @JvmName("xciumgnarnxyvxgg")
    public suspend fun uiTemplate(argument: suspend HumanTaskUIUiTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = HumanTaskUIUiTemplateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.uiTemplate = mapped
    }

    internal fun build(): HumanTaskUIArgs = HumanTaskUIArgs(
        humanTaskUiName = humanTaskUiName,
        tags = tags,
        uiTemplate = uiTemplate,
    )
}
