@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.ImageVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Image Version resource.
 * ## Example Usage
 * ### Basic usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.sagemaker.ImageVersion("test", {
 *     imageName: testAwsSagemakerImage.id,
 *     baseImage: "012345678912.dkr.ecr.us-west-2.amazonaws.com/image:latest",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.sagemaker.ImageVersion("test",
 *     image_name=test_aws_sagemaker_image["id"],
 *     base_image="012345678912.dkr.ecr.us-west-2.amazonaws.com/image:latest")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Sagemaker.ImageVersion("test", new()
 *     {
 *         ImageName = testAwsSagemakerImage.Id,
 *         BaseImage = "012345678912.dkr.ecr.us-west-2.amazonaws.com/image:latest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewImageVersion(ctx, "test", &sagemaker.ImageVersionArgs{
 * 			ImageName: pulumi.Any(testAwsSagemakerImage.Id),
 * 			BaseImage: pulumi.String("012345678912.dkr.ecr.us-west-2.amazonaws.com/image:latest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.ImageVersion;
 * import com.pulumi.aws.sagemaker.ImageVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ImageVersion("test", ImageVersionArgs.builder()
 *             .imageName(testAwsSagemakerImage.id())
 *             .baseImage("012345678912.dkr.ecr.us-west-2.amazonaws.com/image:latest")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:sagemaker:ImageVersion
 *     properties:
 *       imageName: ${testAwsSagemakerImage.id}
 *       baseImage: 012345678912.dkr.ecr.us-west-2.amazonaws.com/image:latest
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker Image Versions using the `name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/imageVersion:ImageVersion test_image my-code-repo
 * ```
 * @property baseImage The registry path of the container image on which this image version is based.
 * @property imageName The name of the image. Must be unique to your account.
 */
public data class ImageVersionArgs(
    public val baseImage: Output<String>? = null,
    public val imageName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.ImageVersionArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.ImageVersionArgs =
        com.pulumi.aws.sagemaker.ImageVersionArgs.builder()
            .baseImage(baseImage?.applyValue({ args0 -> args0 }))
            .imageName(imageName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageVersionArgs].
 */
@PulumiTagMarker
public class ImageVersionArgsBuilder internal constructor() {
    private var baseImage: Output<String>? = null

    private var imageName: Output<String>? = null

    /**
     * @param value The registry path of the container image on which this image version is based.
     */
    @JvmName("bixgjgqednuxbbpg")
    public suspend fun baseImage(`value`: Output<String>) {
        this.baseImage = value
    }

    /**
     * @param value The name of the image. Must be unique to your account.
     */
    @JvmName("rpehmvrlhuvqqgfp")
    public suspend fun imageName(`value`: Output<String>) {
        this.imageName = value
    }

    /**
     * @param value The registry path of the container image on which this image version is based.
     */
    @JvmName("vsjfebogtkcxcxdh")
    public suspend fun baseImage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseImage = mapped
    }

    /**
     * @param value The name of the image. Must be unique to your account.
     */
    @JvmName("kvfqhucrggwnghha")
    public suspend fun imageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageName = mapped
    }

    internal fun build(): ImageVersionArgs = ImageVersionArgs(
        baseImage = baseImage,
        imageName = imageName,
    )
}
