@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.ModelArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.ModelContainerArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.ModelContainerArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.ModelInferenceExecutionConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.ModelInferenceExecutionConfigArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.ModelPrimaryContainerArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.ModelPrimaryContainerArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.ModelVpcConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.ModelVpcConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker model resource.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         actions: ["sts:AssumeRole"],
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["sagemaker&#46;amazonaws&#46;com"],
 *         }],
 *     }],
 * });
 * const exampleRole = new aws.iam.Role("example", {assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json)});
 * const test = aws.sagemaker.getPrebuiltEcrImage({
 *     repositoryName: "kmeans",
 * });
 * const example = new aws.sagemaker.Model("example", {
 *     name: "my-model",
 *     executionRoleArn: exampleRole.arn,
 *     primaryContainer: {
 *         image: test.then(test => test.registryPath),
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "actions": ["sts:AssumeRole"],
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["sagemaker&#46;amazonaws&#46;com"],
 *     }],
 * }])
 * example_role = aws.iam.Role("example", assume_role_policy=assume_role.json)
 * test = aws.sagemaker.get_prebuilt_ecr_image(repository_name="kmeans")
 * example = aws.sagemaker.Model("example",
 *     name="my-model",
 *     execution_role_arn=example_role.arn,
 *     primary_container={
 *         "image": test.registry_path,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "sagemaker.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRole = new Aws.Iam.Role("example", new()
 *     {
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var test = Aws.Sagemaker.GetPrebuiltEcrImage.Invoke(new()
 *     {
 *         RepositoryName = "kmeans",
 *     });
 *     var example = new Aws.Sagemaker.Model("example", new()
 *     {
 *         Name = "my-model",
 *         ExecutionRoleArn = exampleRole.Arn,
 *         PrimaryContainer = new Aws.Sagemaker.Inputs.ModelPrimaryContainerArgs
 *         {
 *             Image = test.Apply(getPrebuiltEcrImageResult => getPrebuiltEcrImageResult.RegistryPath),
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"sagemaker.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleRole, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		test, err := sagemaker.GetPrebuiltEcrImage(ctx, &sagemaker.GetPrebuiltEcrImageArgs{
 * 			RepositoryName: "kmeans",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sagemaker.NewModel(ctx, "example", &sagemaker.ModelArgs{
 * 			Name:             pulumi.String("my-model"),
 * 			ExecutionRoleArn: exampleRole.Arn,
 * 			PrimaryContainer: &sagemaker.ModelPrimaryContainerArgs{
 * 				Image: pulumi.String(test.RegistryPath),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.sagemaker.SagemakerFunctions;
 * import com.pulumi.aws.sagemaker.inputs.GetPrebuiltEcrImageArgs;
 * import com.pulumi.aws.sagemaker.Model;
 * import com.pulumi.aws.sagemaker.ModelArgs;
 * import com.pulumi.aws.sagemaker.inputs.ModelPrimaryContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("sagemaker.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var test = SagemakerFunctions.getPrebuiltEcrImage(GetPrebuiltEcrImageArgs.builder()
 *             .repositoryName("kmeans")
 *             .build());
 *         var example = new Model("example", ModelArgs.builder()
 *             .name("my-model")
 *             .executionRoleArn(exampleRole.arn())
 *             .primaryContainer(ModelPrimaryContainerArgs.builder()
 *                 .image(test.applyValue(getPrebuiltEcrImageResult -> getPrebuiltEcrImageResult.registryPath()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:Model
 *     properties:
 *       name: my-model
 *       executionRoleArn: ${exampleRole.arn}
 *       primaryContainer:
 *         image: ${test.registryPath}
 *   exampleRole:
 *     type: aws:iam:Role
 *     name: example
 *     properties:
 *       assumeRolePolicy: ${assumeRole.json}
 * variables:
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - sts:AssumeRole
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - sagemaker.amazonaws.com
 *   test:
 *     fn::invoke:
 *       Function: aws:sagemaker:getPrebuiltEcrImage
 *       Arguments:
 *         repositoryName: kmeans
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Inference Execution Config
 * * `mode` - (Required) How containers in a multi-container are run. The following values are valid `Serial` and `Direct`.
 * ## Import
 * Using `pulumi import`, import models using the `name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/model:Model test_model model-foo
 * ```
 * @property containers Specifies containers in the inference pipeline. If not specified, the `primary_container` argument is required. Fields are documented below.
 * @property enableNetworkIsolation Isolates the model container. No inbound or outbound network calls can be made to or from the model container.
 * @property executionRoleArn A role that SageMaker can assume to access model artifacts and docker images for deployment.
 * @property inferenceExecutionConfig Specifies details of how containers in a multi-container endpoint are called. see Inference Execution Config.
 * @property name The name of the model (must be unique). If omitted, this provider will assign a random, unique name.
 * @property primaryContainer The primary docker image containing inference code that is used when the model is deployed for predictions.  If not specified, the `container` argument is required. Fields are documented below.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcConfig Specifies the VPC that you want your model to connect to. VpcConfig is used in hosting services and in batch transform.
 */
public data class ModelArgs(
    public val containers: Output<List<ModelContainerArgs>>? = null,
    public val enableNetworkIsolation: Output<Boolean>? = null,
    public val executionRoleArn: Output<String>? = null,
    public val inferenceExecutionConfig: Output<ModelInferenceExecutionConfigArgs>? = null,
    public val name: Output<String>? = null,
    public val primaryContainer: Output<ModelPrimaryContainerArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcConfig: Output<ModelVpcConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.ModelArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.ModelArgs =
        com.pulumi.aws.sagemaker.ModelArgs.builder()
            .containers(
                containers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enableNetworkIsolation(enableNetworkIsolation?.applyValue({ args0 -> args0 }))
            .executionRoleArn(executionRoleArn?.applyValue({ args0 -> args0 }))
            .inferenceExecutionConfig(
                inferenceExecutionConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .primaryContainer(primaryContainer?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcConfig(vpcConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ModelArgs].
 */
@PulumiTagMarker
public class ModelArgsBuilder internal constructor() {
    private var containers: Output<List<ModelContainerArgs>>? = null

    private var enableNetworkIsolation: Output<Boolean>? = null

    private var executionRoleArn: Output<String>? = null

    private var inferenceExecutionConfig: Output<ModelInferenceExecutionConfigArgs>? = null

    private var name: Output<String>? = null

    private var primaryContainer: Output<ModelPrimaryContainerArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcConfig: Output<ModelVpcConfigArgs>? = null

    /**
     * @param value Specifies containers in the inference pipeline. If not specified, the `primary_container` argument is required. Fields are documented below.
     */
    @JvmName("hjgmlyjjsnhxqqch")
    public suspend fun containers(`value`: Output<List<ModelContainerArgs>>) {
        this.containers = value
    }

    @JvmName("jajdgibqdcdlkxca")
    public suspend fun containers(vararg values: Output<ModelContainerArgs>) {
        this.containers = Output.all(values.asList())
    }

    /**
     * @param values Specifies containers in the inference pipeline. If not specified, the `primary_container` argument is required. Fields are documented below.
     */
    @JvmName("rwyfccbludtdaold")
    public suspend fun containers(values: List<Output<ModelContainerArgs>>) {
        this.containers = Output.all(values)
    }

    /**
     * @param value Isolates the model container. No inbound or outbound network calls can be made to or from the model container.
     */
    @JvmName("qwbanbeubhuucqfq")
    public suspend fun enableNetworkIsolation(`value`: Output<Boolean>) {
        this.enableNetworkIsolation = value
    }

    /**
     * @param value A role that SageMaker can assume to access model artifacts and docker images for deployment.
     */
    @JvmName("geblhouwoadtujxw")
    public suspend fun executionRoleArn(`value`: Output<String>) {
        this.executionRoleArn = value
    }

    /**
     * @param value Specifies details of how containers in a multi-container endpoint are called. see Inference Execution Config.
     */
    @JvmName("wbiyockmufhgqtoe")
    public suspend fun inferenceExecutionConfig(`value`: Output<ModelInferenceExecutionConfigArgs>) {
        this.inferenceExecutionConfig = value
    }

    /**
     * @param value The name of the model (must be unique). If omitted, this provider will assign a random, unique name.
     */
    @JvmName("nyftgwlkphbcsjhh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The primary docker image containing inference code that is used when the model is deployed for predictions.  If not specified, the `container` argument is required. Fields are documented below.
     */
    @JvmName("hywvecwkbkodcwft")
    public suspend fun primaryContainer(`value`: Output<ModelPrimaryContainerArgs>) {
        this.primaryContainer = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eganxdtgnkyewnar")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the VPC that you want your model to connect to. VpcConfig is used in hosting services and in batch transform.
     */
    @JvmName("gnwrlrpyfqdkbyvo")
    public suspend fun vpcConfig(`value`: Output<ModelVpcConfigArgs>) {
        this.vpcConfig = value
    }

    /**
     * @param value Specifies containers in the inference pipeline. If not specified, the `primary_container` argument is required. Fields are documented below.
     */
    @JvmName("ghwyyjiybnkeqvys")
    public suspend fun containers(`value`: List<ModelContainerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param argument Specifies containers in the inference pipeline. If not specified, the `primary_container` argument is required. Fields are documented below.
     */
    @JvmName("evhrkqfjslhjeyjk")
    public suspend fun containers(argument: List<suspend ModelContainerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ModelContainerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param argument Specifies containers in the inference pipeline. If not specified, the `primary_container` argument is required. Fields are documented below.
     */
    @JvmName("itldeldhbvasesgs")
    public suspend fun containers(vararg argument: suspend ModelContainerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ModelContainerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param argument Specifies containers in the inference pipeline. If not specified, the `primary_container` argument is required. Fields are documented below.
     */
    @JvmName("lmvmqtoihnjjusvd")
    public suspend fun containers(argument: suspend ModelContainerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ModelContainerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param values Specifies containers in the inference pipeline. If not specified, the `primary_container` argument is required. Fields are documented below.
     */
    @JvmName("chlhngibthoddfbr")
    public suspend fun containers(vararg values: ModelContainerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param value Isolates the model container. No inbound or outbound network calls can be made to or from the model container.
     */
    @JvmName("atvtouvqpkwdlaxx")
    public suspend fun enableNetworkIsolation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableNetworkIsolation = mapped
    }

    /**
     * @param value A role that SageMaker can assume to access model artifacts and docker images for deployment.
     */
    @JvmName("kqjjwakykmqdysia")
    public suspend fun executionRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionRoleArn = mapped
    }

    /**
     * @param value Specifies details of how containers in a multi-container endpoint are called. see Inference Execution Config.
     */
    @JvmName("ohclwmovedywdeie")
    public suspend fun inferenceExecutionConfig(`value`: ModelInferenceExecutionConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inferenceExecutionConfig = mapped
    }

    /**
     * @param argument Specifies details of how containers in a multi-container endpoint are called. see Inference Execution Config.
     */
    @JvmName("qiefgipcmaoyyqgm")
    public suspend fun inferenceExecutionConfig(argument: suspend ModelInferenceExecutionConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ModelInferenceExecutionConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.inferenceExecutionConfig = mapped
    }

    /**
     * @param value The name of the model (must be unique). If omitted, this provider will assign a random, unique name.
     */
    @JvmName("wtckdskjlvvilgdn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The primary docker image containing inference code that is used when the model is deployed for predictions.  If not specified, the `container` argument is required. Fields are documented below.
     */
    @JvmName("tfidhylurdcjctde")
    public suspend fun primaryContainer(`value`: ModelPrimaryContainerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryContainer = mapped
    }

    /**
     * @param argument The primary docker image containing inference code that is used when the model is deployed for predictions.  If not specified, the `container` argument is required. Fields are documented below.
     */
    @JvmName("dnfuxxreinppikak")
    public suspend fun primaryContainer(argument: suspend ModelPrimaryContainerArgsBuilder.() -> Unit) {
        val toBeMapped = ModelPrimaryContainerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.primaryContainer = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ldaomfnkcxrwqewo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kxoqgfopugtwdaka")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies the VPC that you want your model to connect to. VpcConfig is used in hosting services and in batch transform.
     */
    @JvmName("odqkvfccitvrtgod")
    public suspend fun vpcConfig(`value`: ModelVpcConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfig = mapped
    }

    /**
     * @param argument Specifies the VPC that you want your model to connect to. VpcConfig is used in hosting services and in batch transform.
     */
    @JvmName("qbbyvfvkwsywhjvx")
    public suspend fun vpcConfig(argument: suspend ModelVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ModelVpcConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcConfig = mapped
    }

    internal fun build(): ModelArgs = ModelArgs(
        containers = containers,
        enableNetworkIsolation = enableNetworkIsolation,
        executionRoleArn = executionRoleArn,
        inferenceExecutionConfig = inferenceExecutionConfig,
        name = name,
        primaryContainer = primaryContainer,
        tags = tags,
        vpcConfig = vpcConfig,
    )
}
