@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ModelPackageGroup].
 */
@PulumiTagMarker
public class ModelPackageGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ModelPackageGroupArgs = ModelPackageGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ModelPackageGroupArgsBuilder.() -> Unit) {
        val builder = ModelPackageGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ModelPackageGroup {
        val builtJavaResource = com.pulumi.aws.sagemaker.ModelPackageGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ModelPackageGroup(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Model Package Group resource.
 * ## Example Usage
 * ### Basic usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.ModelPackageGroup("example", {modelPackageGroupName: "example"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.ModelPackageGroup("example", model_package_group_name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.ModelPackageGroup("example", new()
 *     {
 *         ModelPackageGroupName = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewModelPackageGroup(ctx, "example", &sagemaker.ModelPackageGroupArgs{
 * 			ModelPackageGroupName: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.ModelPackageGroup;
 * import com.pulumi.aws.sagemaker.ModelPackageGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ModelPackageGroup("example", ModelPackageGroupArgs.builder()
 *             .modelPackageGroupName("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:ModelPackageGroup
 *     properties:
 *       modelPackageGroupName: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker Model Package Groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/modelPackageGroup:ModelPackageGroup test_model_package_group my-code-repo
 * ```
 */
public class ModelPackageGroup internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.ModelPackageGroup,
) : KotlinCustomResource(javaResource, ModelPackageGroupMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this Model Package Group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A description for the model group.
     */
    public val modelPackageGroupDescription: Output<String>?
        get() = javaResource.modelPackageGroupDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the model group.
     */
    public val modelPackageGroupName: Output<String>
        get() = javaResource.modelPackageGroupName().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ModelPackageGroupMapper : ResourceMapper<ModelPackageGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.ModelPackageGroup::class == javaResource::class

    override fun map(javaResource: Resource): ModelPackageGroup = ModelPackageGroup(
        javaResource as
            com.pulumi.aws.sagemaker.ModelPackageGroup,
    )
}

/**
 * @see [ModelPackageGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ModelPackageGroup].
 */
public suspend fun modelPackageGroup(
    name: String,
    block: suspend ModelPackageGroupResourceBuilder.() -> Unit,
): ModelPackageGroup {
    val builder = ModelPackageGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ModelPackageGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun modelPackageGroup(name: String): ModelPackageGroup {
    val builder = ModelPackageGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
