@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.ModelPackageGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Model Package Group resource.
 * ## Example Usage
 * ### Basic usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.ModelPackageGroup("example", {modelPackageGroupName: "example"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.ModelPackageGroup("example", model_package_group_name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.ModelPackageGroup("example", new()
 *     {
 *         ModelPackageGroupName = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewModelPackageGroup(ctx, "example", &sagemaker.ModelPackageGroupArgs{
 * 			ModelPackageGroupName: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.ModelPackageGroup;
 * import com.pulumi.aws.sagemaker.ModelPackageGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ModelPackageGroup("example", ModelPackageGroupArgs.builder()
 *             .modelPackageGroupName("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:ModelPackageGroup
 *     properties:
 *       modelPackageGroupName: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker Model Package Groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/modelPackageGroup:ModelPackageGroup test_model_package_group my-code-repo
 * ```
 * @property modelPackageGroupDescription A description for the model group.
 * @property modelPackageGroupName The name of the model group.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ModelPackageGroupArgs(
    public val modelPackageGroupDescription: Output<String>? = null,
    public val modelPackageGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.ModelPackageGroupArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.ModelPackageGroupArgs =
        com.pulumi.aws.sagemaker.ModelPackageGroupArgs.builder()
            .modelPackageGroupDescription(modelPackageGroupDescription?.applyValue({ args0 -> args0 }))
            .modelPackageGroupName(modelPackageGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ModelPackageGroupArgs].
 */
@PulumiTagMarker
public class ModelPackageGroupArgsBuilder internal constructor() {
    private var modelPackageGroupDescription: Output<String>? = null

    private var modelPackageGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A description for the model group.
     */
    @JvmName("dcxsrfidlwqlwwqs")
    public suspend fun modelPackageGroupDescription(`value`: Output<String>) {
        this.modelPackageGroupDescription = value
    }

    /**
     * @param value The name of the model group.
     */
    @JvmName("dbvggxnjdoilhkxy")
    public suspend fun modelPackageGroupName(`value`: Output<String>) {
        this.modelPackageGroupName = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uirdqlyybipyvhma")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A description for the model group.
     */
    @JvmName("sdcslkfbjfygqwqt")
    public suspend fun modelPackageGroupDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelPackageGroupDescription = mapped
    }

    /**
     * @param value The name of the model group.
     */
    @JvmName("kfhthjebhpbyaqnt")
    public suspend fun modelPackageGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelPackageGroupName = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iiahbdjjayqfcvjl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qunqvtkaprmlgiaj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ModelPackageGroupArgs = ModelPackageGroupArgs(
        modelPackageGroupDescription = modelPackageGroupDescription,
        modelPackageGroupName = modelPackageGroupName,
        tags = tags,
    )
}
