@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.MonitoringScheduleMonitoringScheduleConfig
import com.pulumi.aws.sagemaker.kotlin.outputs.MonitoringScheduleMonitoringScheduleConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [MonitoringSchedule].
 */
@PulumiTagMarker
public class MonitoringScheduleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MonitoringScheduleArgs = MonitoringScheduleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MonitoringScheduleArgsBuilder.() -> Unit) {
        val builder = MonitoringScheduleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MonitoringSchedule {
        val builtJavaResource = com.pulumi.aws.sagemaker.MonitoringSchedule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MonitoringSchedule(builtJavaResource)
    }
}

/**
 * Provides a SageMaker monitoring schedule resource.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.sagemaker.MonitoringSchedule("test", {
 *     name: "my-monitoring-schedule",
 *     monitoringScheduleConfig: {
 *         monitoringJobDefinitionName: testAwsSagemakerDataQualityJobDefinition.name,
 *         monitoringType: "DataQuality",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.sagemaker.MonitoringSchedule("test",
 *     name="my-monitoring-schedule",
 *     monitoring_schedule_config={
 *         "monitoring_job_definition_name": test_aws_sagemaker_data_quality_job_definition["name"],
 *         "monitoring_type": "DataQuality",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Sagemaker.MonitoringSchedule("test", new()
 *     {
 *         Name = "my-monitoring-schedule",
 *         MonitoringScheduleConfig = new Aws.Sagemaker.Inputs.MonitoringScheduleMonitoringScheduleConfigArgs
 *         {
 *             MonitoringJobDefinitionName = testAwsSagemakerDataQualityJobDefinition.Name,
 *             MonitoringType = "DataQuality",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewMonitoringSchedule(ctx, "test", &sagemaker.MonitoringScheduleArgs{
 * 			Name: pulumi.String("my-monitoring-schedule"),
 * 			MonitoringScheduleConfig: &sagemaker.MonitoringScheduleMonitoringScheduleConfigArgs{
 * 				MonitoringJobDefinitionName: pulumi.Any(testAwsSagemakerDataQualityJobDefinition.Name),
 * 				MonitoringType:              pulumi.String("DataQuality"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.MonitoringSchedule;
 * import com.pulumi.aws.sagemaker.MonitoringScheduleArgs;
 * import com.pulumi.aws.sagemaker.inputs.MonitoringScheduleMonitoringScheduleConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new MonitoringSchedule("test", MonitoringScheduleArgs.builder()
 *             .name("my-monitoring-schedule")
 *             .monitoringScheduleConfig(MonitoringScheduleMonitoringScheduleConfigArgs.builder()
 *                 .monitoringJobDefinitionName(testAwsSagemakerDataQualityJobDefinition.name())
 *                 .monitoringType("DataQuality")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:sagemaker:MonitoringSchedule
 *     properties:
 *       name: my-monitoring-schedule
 *       monitoringScheduleConfig:
 *         monitoringJobDefinitionName: ${testAwsSagemakerDataQualityJobDefinition.name}
 *         monitoringType: DataQuality
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import monitoring schedules using the `name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/monitoringSchedule:MonitoringSchedule test_monitoring_schedule monitoring-schedule-foo
 * ```
 */
public class MonitoringSchedule internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.MonitoringSchedule,
) : KotlinCustomResource(javaResource, MonitoringScheduleMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this monitoring schedule.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The configuration object that specifies the monitoring schedule and defines the monitoring job. Fields are documented below.
     */
    public val monitoringScheduleConfig: Output<MonitoringScheduleMonitoringScheduleConfig>
        get() = javaResource.monitoringScheduleConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The name of the monitoring schedule. The name must be unique within an AWS Region within an AWS account. If omitted, the provider will assign a random, unique name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object MonitoringScheduleMapper : ResourceMapper<MonitoringSchedule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.MonitoringSchedule::class == javaResource::class

    override fun map(javaResource: Resource): MonitoringSchedule = MonitoringSchedule(
        javaResource as
            com.pulumi.aws.sagemaker.MonitoringSchedule,
    )
}

/**
 * @see [MonitoringSchedule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MonitoringSchedule].
 */
public suspend fun monitoringSchedule(
    name: String,
    block: suspend MonitoringScheduleResourceBuilder.() -> Unit,
): MonitoringSchedule {
    val builder = MonitoringScheduleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MonitoringSchedule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun monitoringSchedule(name: String): MonitoringSchedule {
    val builder = MonitoringScheduleResourceBuilder()
    builder.name(name)
    return builder.build()
}
