@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.MonitoringScheduleArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.MonitoringScheduleMonitoringScheduleConfigArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.MonitoringScheduleMonitoringScheduleConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker monitoring schedule resource.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.sagemaker.MonitoringSchedule("test", {
 *     name: "my-monitoring-schedule",
 *     monitoringScheduleConfig: {
 *         monitoringJobDefinitionName: testAwsSagemakerDataQualityJobDefinition.name,
 *         monitoringType: "DataQuality",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.sagemaker.MonitoringSchedule("test",
 *     name="my-monitoring-schedule",
 *     monitoring_schedule_config={
 *         "monitoring_job_definition_name": test_aws_sagemaker_data_quality_job_definition["name"],
 *         "monitoring_type": "DataQuality",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Sagemaker.MonitoringSchedule("test", new()
 *     {
 *         Name = "my-monitoring-schedule",
 *         MonitoringScheduleConfig = new Aws.Sagemaker.Inputs.MonitoringScheduleMonitoringScheduleConfigArgs
 *         {
 *             MonitoringJobDefinitionName = testAwsSagemakerDataQualityJobDefinition.Name,
 *             MonitoringType = "DataQuality",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewMonitoringSchedule(ctx, "test", &sagemaker.MonitoringScheduleArgs{
 * 			Name: pulumi.String("my-monitoring-schedule"),
 * 			MonitoringScheduleConfig: &sagemaker.MonitoringScheduleMonitoringScheduleConfigArgs{
 * 				MonitoringJobDefinitionName: pulumi.Any(testAwsSagemakerDataQualityJobDefinition.Name),
 * 				MonitoringType:              pulumi.String("DataQuality"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.MonitoringSchedule;
 * import com.pulumi.aws.sagemaker.MonitoringScheduleArgs;
 * import com.pulumi.aws.sagemaker.inputs.MonitoringScheduleMonitoringScheduleConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new MonitoringSchedule("test", MonitoringScheduleArgs.builder()
 *             .name("my-monitoring-schedule")
 *             .monitoringScheduleConfig(MonitoringScheduleMonitoringScheduleConfigArgs.builder()
 *                 .monitoringJobDefinitionName(testAwsSagemakerDataQualityJobDefinition.name())
 *                 .monitoringType("DataQuality")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:sagemaker:MonitoringSchedule
 *     properties:
 *       name: my-monitoring-schedule
 *       monitoringScheduleConfig:
 *         monitoringJobDefinitionName: ${testAwsSagemakerDataQualityJobDefinition.name}
 *         monitoringType: DataQuality
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import monitoring schedules using the `name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/monitoringSchedule:MonitoringSchedule test_monitoring_schedule monitoring-schedule-foo
 * ```
 * @property monitoringScheduleConfig The configuration object that specifies the monitoring schedule and defines the monitoring job. Fields are documented below.
 * @property name The name of the monitoring schedule. The name must be unique within an AWS Region within an AWS account. If omitted, the provider will assign a random, unique name.
 * @property tags A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class MonitoringScheduleArgs(
    public val monitoringScheduleConfig: Output<MonitoringScheduleMonitoringScheduleConfigArgs>? =
        null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.MonitoringScheduleArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.MonitoringScheduleArgs =
        com.pulumi.aws.sagemaker.MonitoringScheduleArgs.builder()
            .monitoringScheduleConfig(
                monitoringScheduleConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MonitoringScheduleArgs].
 */
@PulumiTagMarker
public class MonitoringScheduleArgsBuilder internal constructor() {
    private var monitoringScheduleConfig: Output<MonitoringScheduleMonitoringScheduleConfigArgs>? =
        null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The configuration object that specifies the monitoring schedule and defines the monitoring job. Fields are documented below.
     */
    @JvmName("yyvwsqlflavvrned")
    public suspend fun monitoringScheduleConfig(`value`: Output<MonitoringScheduleMonitoringScheduleConfigArgs>) {
        this.monitoringScheduleConfig = value
    }

    /**
     * @param value The name of the monitoring schedule. The name must be unique within an AWS Region within an AWS account. If omitted, the provider will assign a random, unique name.
     */
    @JvmName("byueovxmjmbppjlb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lhxolnprtmrubrmv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The configuration object that specifies the monitoring schedule and defines the monitoring job. Fields are documented below.
     */
    @JvmName("ctipshcsagmornoa")
    public suspend fun monitoringScheduleConfig(`value`: MonitoringScheduleMonitoringScheduleConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoringScheduleConfig = mapped
    }

    /**
     * @param argument The configuration object that specifies the monitoring schedule and defines the monitoring job. Fields are documented below.
     */
    @JvmName("xjsuxgdbeioqapnr")
    public suspend fun monitoringScheduleConfig(argument: suspend MonitoringScheduleMonitoringScheduleConfigArgsBuilder.() -> Unit) {
        val toBeMapped = MonitoringScheduleMonitoringScheduleConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.monitoringScheduleConfig = mapped
    }

    /**
     * @param value The name of the monitoring schedule. The name must be unique within an AWS Region within an AWS account. If omitted, the provider will assign a random, unique name.
     */
    @JvmName("lbhoutiwufbcviif")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jrmnpbgkhdgrabws")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("togsxwpwjqjklnqh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MonitoringScheduleArgs = MonitoringScheduleArgs(
        monitoringScheduleConfig = monitoringScheduleConfig,
        name = name,
        tags = tags,
    )
}
