@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.NotebookInstanceInstanceMetadataServiceConfiguration
import com.pulumi.aws.sagemaker.kotlin.outputs.NotebookInstanceInstanceMetadataServiceConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [NotebookInstance].
 */
@PulumiTagMarker
public class NotebookInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NotebookInstanceArgs = NotebookInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NotebookInstanceArgsBuilder.() -> Unit) {
        val builder = NotebookInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NotebookInstance {
        val builtJavaResource = com.pulumi.aws.sagemaker.NotebookInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NotebookInstance(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Notebook Instance resource.
 * ## Example Usage
 * ### Basic usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const ni = new aws.sagemaker.NotebookInstance("ni", {
 *     name: "my-notebook-instance",
 *     roleArn: role.arn,
 *     instanceType: "ml.t2.medium",
 *     tags: {
 *         Name: "foo",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * ni = aws.sagemaker.NotebookInstance("ni",
 *     name="my-notebook-instance",
 *     role_arn=role["arn"],
 *     instance_type="ml.t2.medium",
 *     tags={
 *         "Name": "foo",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ni = new Aws.Sagemaker.NotebookInstance("ni", new()
 *     {
 *         Name = "my-notebook-instance",
 *         RoleArn = role.Arn,
 *         InstanceType = "ml.t2.medium",
 *         Tags =
 *         {
 *             { "Name", "foo" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewNotebookInstance(ctx, "ni", &sagemaker.NotebookInstanceArgs{
 * 			Name:         pulumi.String("my-notebook-instance"),
 * 			RoleArn:      pulumi.Any(role.Arn),
 * 			InstanceType: pulumi.String("ml.t2.medium"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("foo"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.NotebookInstance;
 * import com.pulumi.aws.sagemaker.NotebookInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ni = new NotebookInstance("ni", NotebookInstanceArgs.builder()
 *             .name("my-notebook-instance")
 *             .roleArn(role.arn())
 *             .instanceType("ml.t2.medium")
 *             .tags(Map.of("Name", "foo"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   ni:
 *     type: aws:sagemaker:NotebookInstance
 *     properties:
 *       name: my-notebook-instance
 *       roleArn: ${role.arn}
 *       instanceType: ml.t2.medium
 *       tags:
 *         Name: foo
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Code repository usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.CodeRepository("example", {
 *     codeRepositoryName: "my-notebook-instance-code-repo",
 *     gitConfig: {
 *         repositoryUrl: "https://github.com/github/docs.git",
 *     },
 * });
 * const ni = new aws.sagemaker.NotebookInstance("ni", {
 *     name: "my-notebook-instance",
 *     roleArn: role.arn,
 *     instanceType: "ml.t2.medium",
 *     defaultCodeRepository: example.codeRepositoryName,
 *     tags: {
 *         Name: "foo",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.CodeRepository("example",
 *     code_repository_name="my-notebook-instance-code-repo",
 *     git_config={
 *         "repository_url": "https://github.com/github/docs.git",
 *     })
 * ni = aws.sagemaker.NotebookInstance("ni",
 *     name="my-notebook-instance",
 *     role_arn=role["arn"],
 *     instance_type="ml.t2.medium",
 *     default_code_repository=example.code_repository_name,
 *     tags={
 *         "Name": "foo",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.CodeRepository("example", new()
 *     {
 *         CodeRepositoryName = "my-notebook-instance-code-repo",
 *         GitConfig = new Aws.Sagemaker.Inputs.CodeRepositoryGitConfigArgs
 *         {
 *             RepositoryUrl = "https://github.com/github/docs.git",
 *         },
 *     });
 *     var ni = new Aws.Sagemaker.NotebookInstance("ni", new()
 *     {
 *         Name = "my-notebook-instance",
 *         RoleArn = role.Arn,
 *         InstanceType = "ml.t2.medium",
 *         DefaultCodeRepository = example.CodeRepositoryName,
 *         Tags =
 *         {
 *             { "Name", "foo" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := sagemaker.NewCodeRepository(ctx, "example", &sagemaker.CodeRepositoryArgs{
 * 			CodeRepositoryName: pulumi.String("my-notebook-instance-code-repo"),
 * 			GitConfig: &sagemaker.CodeRepositoryGitConfigArgs{
 * 				RepositoryUrl: pulumi.String("https://github.com/github/docs.git"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sagemaker.NewNotebookInstance(ctx, "ni", &sagemaker.NotebookInstanceArgs{
 * 			Name:                  pulumi.String("my-notebook-instance"),
 * 			RoleArn:               pulumi.Any(role.Arn),
 * 			InstanceType:          pulumi.String("ml.t2.medium"),
 * 			DefaultCodeRepository: example.CodeRepositoryName,
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("foo"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.CodeRepository;
 * import com.pulumi.aws.sagemaker.CodeRepositoryArgs;
 * import com.pulumi.aws.sagemaker.inputs.CodeRepositoryGitConfigArgs;
 * import com.pulumi.aws.sagemaker.NotebookInstance;
 * import com.pulumi.aws.sagemaker.NotebookInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CodeRepository("example", CodeRepositoryArgs.builder()
 *             .codeRepositoryName("my-notebook-instance-code-repo")
 *             .gitConfig(CodeRepositoryGitConfigArgs.builder()
 *                 .repositoryUrl("https://github.com/github/docs.git")
 *                 .build())
 *             .build());
 *         var ni = new NotebookInstance("ni", NotebookInstanceArgs.builder()
 *             .name("my-notebook-instance")
 *             .roleArn(role.arn())
 *             .instanceType("ml.t2.medium")
 *             .defaultCodeRepository(example.codeRepositoryName())
 *             .tags(Map.of("Name", "foo"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:CodeRepository
 *     properties:
 *       codeRepositoryName: my-notebook-instance-code-repo
 *       gitConfig:
 *         repositoryUrl: https://github.com/github/docs.git
 *   ni:
 *     type: aws:sagemaker:NotebookInstance
 *     properties:
 *       name: my-notebook-instance
 *       roleArn: ${role.arn}
 *       instanceType: ml.t2.medium
 *       defaultCodeRepository: ${example.codeRepositoryName}
 *       tags:
 *         Name: foo
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker Notebook Instances using the `name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/notebookInstance:NotebookInstance test_notebook_instance my-notebook-instance
 * ```
 */
public class NotebookInstance internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.NotebookInstance,
) : KotlinCustomResource(javaResource, NotebookInstanceMapper) {
    /**
     * A list of Elastic Inference (EI) instance types to associate with this notebook instance. See [Elastic Inference Accelerator](https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html) for more details. Valid values: `ml.eia1.medium`, `ml.eia1.large`, `ml.eia1.xlarge`, `ml.eia2.medium`, `ml.eia2.large`, `ml.eia2.xlarge`.
     */
    public val acceleratorTypes: Output<List<String>>?
        get() = javaResource.acceleratorTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * An array of up to three Git repositories to associate with the notebook instance.
     * These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in [AWS CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance.
     */
    public val additionalCodeRepositories: Output<List<String>>?
        get() = javaResource.additionalCodeRepositories().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this notebook instance.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in [AWS CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html) or in any other Git repository.
     */
    public val defaultCodeRepository: Output<String>?
        get() = javaResource.defaultCodeRepository().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Set to `Disabled` to disable internet access to notebook. Requires `security_groups` and `subnet_id` to be set. Supported values: `Enabled` (Default) or `Disabled`. If set to `Disabled`, the notebook instance will be able to access resources only in your VPC, and will not be able to connect to Amazon SageMaker training and endpoint services unless your configure a NAT Gateway in your VPC.
     */
    public val directInternetAccess: Output<String>?
        get() = javaResource.directInternetAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Information on the IMDS configuration of the notebook instance. Conflicts with `instance_metadata_service_configuration`. see details below.
     */
    public val instanceMetadataServiceConfiguration:
        Output<NotebookInstanceInstanceMetadataServiceConfiguration>?
        get() = javaResource.instanceMetadataServiceConfiguration().applyValue({ args0 ->
            args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) }).orElse(null)
        })

    /**
     * The name of ML compute instance type.
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
     */
    public val kmsKeyId: Output<String>?
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of a lifecycle configuration to associate with the notebook instance.
     */
    public val lifecycleConfigName: Output<String>?
        get() = javaResource.lifecycleConfigName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the notebook instance (must be unique).
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The network interface ID that Amazon SageMaker created at the time of creating the instance. Only available when setting `subnet_id`.
     */
    public val networkInterfaceId: Output<String>
        get() = javaResource.networkInterfaceId().applyValue({ args0 -> args0 })

    /**
     * The platform identifier of the notebook instance runtime environment. This value can be either `notebook-al1-v1`, `notebook-al2-v1`, or  `notebook-al2-v2`, depending on which version of Amazon Linux you require.
     */
    public val platformIdentifier: Output<String>
        get() = javaResource.platformIdentifier().applyValue({ args0 -> args0 })

    /**
     * The ARN of the IAM role to be used by the notebook instance which allows SageMaker to call other services on your behalf.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * Whether root access is `Enabled` or `Disabled` for users of the notebook instance. The default value is `Enabled`.
     */
    public val rootAccess: Output<String>?
        get() = javaResource.rootAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The associated security groups.
     */
    public val securityGroups: Output<List<String>>
        get() = javaResource.securityGroups().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The VPC subnet ID.
     */
    public val subnetId: Output<String>?
        get() = javaResource.subnetId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The URL that you use to connect to the Jupyter notebook that is running in your notebook instance.
     */
    public val url: Output<String>
        get() = javaResource.url().applyValue({ args0 -> args0 })

    /**
     * The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB.
     */
    public val volumeSize: Output<Int>?
        get() = javaResource.volumeSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object NotebookInstanceMapper : ResourceMapper<NotebookInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.NotebookInstance::class == javaResource::class

    override fun map(javaResource: Resource): NotebookInstance = NotebookInstance(
        javaResource as
            com.pulumi.aws.sagemaker.NotebookInstance,
    )
}

/**
 * @see [NotebookInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NotebookInstance].
 */
public suspend fun notebookInstance(
    name: String,
    block: suspend NotebookInstanceResourceBuilder.() -> Unit,
): NotebookInstance {
    val builder = NotebookInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NotebookInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun notebookInstance(name: String): NotebookInstance {
    val builder = NotebookInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
