@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [NotebookInstanceLifecycleConfiguration].
 */
@PulumiTagMarker
public class NotebookInstanceLifecycleConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NotebookInstanceLifecycleConfigurationArgs =
        NotebookInstanceLifecycleConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NotebookInstanceLifecycleConfigurationArgsBuilder.() -> Unit) {
        val builder = NotebookInstanceLifecycleConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NotebookInstanceLifecycleConfiguration {
        val builtJavaResource =
            com.pulumi.aws.sagemaker.NotebookInstanceLifecycleConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NotebookInstanceLifecycleConfiguration(builtJavaResource)
    }
}

/**
 * Provides a lifecycle configuration for SageMaker Notebook Instances.
 * ## Example Usage
 * Usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const lc = new aws.sagemaker.NotebookInstanceLifecycleConfiguration("lc", {
 *     name: "foo",
 *     onCreate: std.base64encode({
 *         input: "echo foo",
 *     }).then(invoke => invoke.result),
 *     onStart: std.base64encode({
 *         input: "echo bar",
 *     }).then(invoke => invoke.result),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * lc = aws.sagemaker.NotebookInstanceLifecycleConfiguration("lc",
 *     name="foo",
 *     on_create=std.base64encode(input="echo foo").result,
 *     on_start=std.base64encode(input="echo bar").result)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var lc = new Aws.Sagemaker.NotebookInstanceLifecycleConfiguration("lc", new()
 *     {
 *         Name = "foo",
 *         OnCreate = Std.Base64encode.Invoke(new()
 *         {
 *             Input = "echo foo",
 *         }).Apply(invoke => invoke.Result),
 *         OnStart = Std.Base64encode.Invoke(new()
 *         {
 *             Input = "echo bar",
 *         }).Apply(invoke => invoke.Result),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeBase64encode, err := std.Base64encode(ctx, &std.Base64encodeArgs{
 * 			Input: "echo foo",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invokeBase64encode1, err := std.Base64encode(ctx, &std.Base64encodeArgs{
 * 			Input: "echo bar",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sagemaker.NewNotebookInstanceLifecycleConfiguration(ctx, "lc", &sagemaker.NotebookInstanceLifecycleConfigurationArgs{
 * 			Name:     pulumi.String("foo"),
 * 			OnCreate: pulumi.String(invokeBase64encode.Result),
 * 			OnStart:  pulumi.String(invokeBase64encode1.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.NotebookInstanceLifecycleConfiguration;
 * import com.pulumi.aws.sagemaker.NotebookInstanceLifecycleConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lc = new NotebookInstanceLifecycleConfiguration("lc", NotebookInstanceLifecycleConfigurationArgs.builder()
 *             .name("foo")
 *             .onCreate(StdFunctions.base64encode(Base64encodeArgs.builder()
 *                 .input("echo foo")
 *                 .build()).result())
 *             .onStart(StdFunctions.base64encode(Base64encodeArgs.builder()
 *                 .input("echo bar")
 *                 .build()).result())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   lc:
 *     type: aws:sagemaker:NotebookInstanceLifecycleConfiguration
 *     properties:
 *       name: foo
 *       onCreate:
 *         fn::invoke:
 *           Function: std:base64encode
 *           Arguments:
 *             input: echo foo
 *           Return: result
 *       onStart:
 *         fn::invoke:
 *           Function: std:base64encode
 *           Arguments:
 *             input: echo bar
 *           Return: result
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import models using the `name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/notebookInstanceLifecycleConfiguration:NotebookInstanceLifecycleConfiguration lc foo
 * ```
 */
public class NotebookInstanceLifecycleConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.NotebookInstanceLifecycleConfiguration,
) : KotlinCustomResource(javaResource, NotebookInstanceLifecycleConfigurationMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this lifecycle configuration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the lifecycle configuration (must be unique). If omitted, this provider will assign a random, unique name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A shell script (base64-encoded) that runs only once when the SageMaker Notebook Instance is created.
     */
    public val onCreate: Output<String>?
        get() = javaResource.onCreate().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A shell script (base64-encoded) that runs every time the SageMaker Notebook Instance is started including the time it's created.
     */
    public val onStart: Output<String>?
        get() = javaResource.onStart().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object NotebookInstanceLifecycleConfigurationMapper :
    ResourceMapper<NotebookInstanceLifecycleConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.NotebookInstanceLifecycleConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): NotebookInstanceLifecycleConfiguration =
        NotebookInstanceLifecycleConfiguration(
            javaResource as
                com.pulumi.aws.sagemaker.NotebookInstanceLifecycleConfiguration,
        )
}

/**
 * @see [NotebookInstanceLifecycleConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NotebookInstanceLifecycleConfiguration].
 */
public suspend fun notebookInstanceLifecycleConfiguration(
    name: String,
    block: suspend NotebookInstanceLifecycleConfigurationResourceBuilder.() -> Unit,
): NotebookInstanceLifecycleConfiguration {
    val builder = NotebookInstanceLifecycleConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NotebookInstanceLifecycleConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun notebookInstanceLifecycleConfiguration(name: String): NotebookInstanceLifecycleConfiguration {
    val builder = NotebookInstanceLifecycleConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
