@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.NotebookInstanceLifecycleConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a lifecycle configuration for SageMaker Notebook Instances.
 * ## Example Usage
 * Usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const lc = new aws.sagemaker.NotebookInstanceLifecycleConfiguration("lc", {
 *     name: "foo",
 *     onCreate: std.base64encode({
 *         input: "echo foo",
 *     }).then(invoke => invoke.result),
 *     onStart: std.base64encode({
 *         input: "echo bar",
 *     }).then(invoke => invoke.result),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * lc = aws.sagemaker.NotebookInstanceLifecycleConfiguration("lc",
 *     name="foo",
 *     on_create=std.base64encode(input="echo foo").result,
 *     on_start=std.base64encode(input="echo bar").result)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var lc = new Aws.Sagemaker.NotebookInstanceLifecycleConfiguration("lc", new()
 *     {
 *         Name = "foo",
 *         OnCreate = Std.Base64encode.Invoke(new()
 *         {
 *             Input = "echo foo",
 *         }).Apply(invoke => invoke.Result),
 *         OnStart = Std.Base64encode.Invoke(new()
 *         {
 *             Input = "echo bar",
 *         }).Apply(invoke => invoke.Result),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeBase64encode, err := std.Base64encode(ctx, &std.Base64encodeArgs{
 * 			Input: "echo foo",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invokeBase64encode1, err := std.Base64encode(ctx, &std.Base64encodeArgs{
 * 			Input: "echo bar",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sagemaker.NewNotebookInstanceLifecycleConfiguration(ctx, "lc", &sagemaker.NotebookInstanceLifecycleConfigurationArgs{
 * 			Name:     pulumi.String("foo"),
 * 			OnCreate: pulumi.String(invokeBase64encode.Result),
 * 			OnStart:  pulumi.String(invokeBase64encode1.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.NotebookInstanceLifecycleConfiguration;
 * import com.pulumi.aws.sagemaker.NotebookInstanceLifecycleConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lc = new NotebookInstanceLifecycleConfiguration("lc", NotebookInstanceLifecycleConfigurationArgs.builder()
 *             .name("foo")
 *             .onCreate(StdFunctions.base64encode(Base64encodeArgs.builder()
 *                 .input("echo foo")
 *                 .build()).result())
 *             .onStart(StdFunctions.base64encode(Base64encodeArgs.builder()
 *                 .input("echo bar")
 *                 .build()).result())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   lc:
 *     type: aws:sagemaker:NotebookInstanceLifecycleConfiguration
 *     properties:
 *       name: foo
 *       onCreate:
 *         fn::invoke:
 *           Function: std:base64encode
 *           Arguments:
 *             input: echo foo
 *           Return: result
 *       onStart:
 *         fn::invoke:
 *           Function: std:base64encode
 *           Arguments:
 *             input: echo bar
 *           Return: result
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import models using the `name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/notebookInstanceLifecycleConfiguration:NotebookInstanceLifecycleConfiguration lc foo
 * ```
 * @property name The name of the lifecycle configuration (must be unique). If omitted, this provider will assign a random, unique name.
 * @property onCreate A shell script (base64-encoded) that runs only once when the SageMaker Notebook Instance is created.
 * @property onStart A shell script (base64-encoded) that runs every time the SageMaker Notebook Instance is started including the time it's created.
 */
public data class NotebookInstanceLifecycleConfigurationArgs(
    public val name: Output<String>? = null,
    public val onCreate: Output<String>? = null,
    public val onStart: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.NotebookInstanceLifecycleConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.NotebookInstanceLifecycleConfigurationArgs =
        com.pulumi.aws.sagemaker.NotebookInstanceLifecycleConfigurationArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .onCreate(onCreate?.applyValue({ args0 -> args0 }))
            .onStart(onStart?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NotebookInstanceLifecycleConfigurationArgs].
 */
@PulumiTagMarker
public class NotebookInstanceLifecycleConfigurationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var onCreate: Output<String>? = null

    private var onStart: Output<String>? = null

    /**
     * @param value The name of the lifecycle configuration (must be unique). If omitted, this provider will assign a random, unique name.
     */
    @JvmName("fyymklgdfhdkbtum")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A shell script (base64-encoded) that runs only once when the SageMaker Notebook Instance is created.
     */
    @JvmName("wlhawgjygaoyvtwy")
    public suspend fun onCreate(`value`: Output<String>) {
        this.onCreate = value
    }

    /**
     * @param value A shell script (base64-encoded) that runs every time the SageMaker Notebook Instance is started including the time it's created.
     */
    @JvmName("myyrdlbnsupfmvhl")
    public suspend fun onStart(`value`: Output<String>) {
        this.onStart = value
    }

    /**
     * @param value The name of the lifecycle configuration (must be unique). If omitted, this provider will assign a random, unique name.
     */
    @JvmName("qbuswnuyeabxoflw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A shell script (base64-encoded) that runs only once when the SageMaker Notebook Instance is created.
     */
    @JvmName("ysdpoapycobhiuqa")
    public suspend fun onCreate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onCreate = mapped
    }

    /**
     * @param value A shell script (base64-encoded) that runs every time the SageMaker Notebook Instance is started including the time it's created.
     */
    @JvmName("xuqodkcgvxwwfyrc")
    public suspend fun onStart(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onStart = mapped
    }

    internal fun build(): NotebookInstanceLifecycleConfigurationArgs =
        NotebookInstanceLifecycleConfigurationArgs(
            name = name,
            onCreate = onCreate,
            onStart = onStart,
        )
}
