@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.PipelineArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.PipelineParallelismConfigurationArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.PipelineParallelismConfigurationArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.PipelinePipelineDefinitionS3LocationArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.PipelinePipelineDefinitionS3LocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Pipeline resource.
 * ## Example Usage
 * ### Basic usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.Pipeline("example", {
 *     pipelineName: "example",
 *     pipelineDisplayName: "example",
 *     roleArn: exampleAwsIamRole.arn,
 *     pipelineDefinition: JSON.stringify({
 *         Version: "2020-12-01",
 *         Steps: [{
 *             Name: "Test",
 *             Type: "Fail",
 *             Arguments: {
 *                 ErrorMessage: "test",
 *             },
 *         }],
 *     }),
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.sagemaker.Pipeline("example",
 *     pipeline_name="example",
 *     pipeline_display_name="example",
 *     role_arn=example_aws_iam_role["arn"],
 *     pipeline_definition=json.dumps({
 *         "Version": "2020-12-01",
 *         "Steps": [{
 *             "Name": "Test",
 *             "Type": "Fail",
 *             "Arguments": {
 *                 "ErrorMessage": "test",
 *             },
 *         }],
 *     }))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.Pipeline("example", new()
 *     {
 *         PipelineName = "example",
 *         PipelineDisplayName = "example",
 *         RoleArn = exampleAwsIamRole.Arn,
 *         PipelineDefinition = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2020-12-01",
 *             ["Steps"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Name"] = "Test",
 *                     ["Type"] = "Fail",
 *                     ["Arguments"] = new Dictionary<string, object?>
 *                     {
 *                         ["ErrorMessage"] = "test",
 *                     },
 *                 },
 *             },
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2020-12-01",
 * 			"Steps": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Name": "Test",
 * 					"Type": "Fail",
 * 					"Arguments": map[string]interface{}{
 * 						"ErrorMessage": "test",
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = sagemaker.NewPipeline(ctx, "example", &sagemaker.PipelineArgs{
 * 			PipelineName:        pulumi.String("example"),
 * 			PipelineDisplayName: pulumi.String("example"),
 * 			RoleArn:             pulumi.Any(exampleAwsIamRole.Arn),
 * 			PipelineDefinition:  pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Pipeline;
 * import com.pulumi.aws.sagemaker.PipelineArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Pipeline("example", PipelineArgs.builder()
 *             .pipelineName("example")
 *             .pipelineDisplayName("example")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .pipelineDefinition(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2020-12-01"),
 *                     jsonProperty("Steps", jsonArray(jsonObject(
 *                         jsonProperty("Name", "Test"),
 *                         jsonProperty("Type", "Fail"),
 *                         jsonProperty("Arguments", jsonObject(
 *                             jsonProperty("ErrorMessage", "test")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:Pipeline
 *     properties:
 *       pipelineName: example
 *       pipelineDisplayName: example
 *       roleArn: ${exampleAwsIamRole.arn}
 *       pipelineDefinition:
 *         fn::toJSON:
 *           Version: 2020-12-01
 *           Steps:
 *             - Name: Test
 *               Type: Fail
 *               Arguments:
 *                 ErrorMessage: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import pipelines using the `pipeline_name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/pipeline:Pipeline test_pipeline pipeline
 * ```
 * @property parallelismConfiguration This is the configuration that controls the parallelism of the pipeline. If specified, it applies to all runs of this pipeline by default. see Parallelism Configuration details below.
 * @property pipelineDefinition The [JSON pipeline definition](https://aws-sagemaker-mlops.github.io/sagemaker-model-building-pipeline-definition-JSON-schema/) of the pipeline.
 * @property pipelineDefinitionS3Location The location of the pipeline definition stored in Amazon S3. If specified, SageMaker will retrieve the pipeline definition from this location. see Pipeline Definition S3 Location details below.
 * @property pipelineDescription A description of the pipeline.
 * @property pipelineDisplayName The display name of the pipeline.
 * @property pipelineName The name of the pipeline.
 * @property roleArn The ARN of the IAM role the pipeline will execute as.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class PipelineArgs(
    public val parallelismConfiguration: Output<PipelineParallelismConfigurationArgs>? = null,
    public val pipelineDefinition: Output<String>? = null,
    public val pipelineDefinitionS3Location: Output<PipelinePipelineDefinitionS3LocationArgs>? = null,
    public val pipelineDescription: Output<String>? = null,
    public val pipelineDisplayName: Output<String>? = null,
    public val pipelineName: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.PipelineArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.PipelineArgs =
        com.pulumi.aws.sagemaker.PipelineArgs.builder()
            .parallelismConfiguration(
                parallelismConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .pipelineDefinition(pipelineDefinition?.applyValue({ args0 -> args0 }))
            .pipelineDefinitionS3Location(
                pipelineDefinitionS3Location?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .pipelineDescription(pipelineDescription?.applyValue({ args0 -> args0 }))
            .pipelineDisplayName(pipelineDisplayName?.applyValue({ args0 -> args0 }))
            .pipelineName(pipelineName?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PipelineArgs].
 */
@PulumiTagMarker
public class PipelineArgsBuilder internal constructor() {
    private var parallelismConfiguration: Output<PipelineParallelismConfigurationArgs>? = null

    private var pipelineDefinition: Output<String>? = null

    private var pipelineDefinitionS3Location: Output<PipelinePipelineDefinitionS3LocationArgs>? = null

    private var pipelineDescription: Output<String>? = null

    private var pipelineDisplayName: Output<String>? = null

    private var pipelineName: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value This is the configuration that controls the parallelism of the pipeline. If specified, it applies to all runs of this pipeline by default. see Parallelism Configuration details below.
     */
    @JvmName("wgjppkpooycfkqdk")
    public suspend fun parallelismConfiguration(`value`: Output<PipelineParallelismConfigurationArgs>) {
        this.parallelismConfiguration = value
    }

    /**
     * @param value The [JSON pipeline definition](https://aws-sagemaker-mlops.github.io/sagemaker-model-building-pipeline-definition-JSON-schema/) of the pipeline.
     */
    @JvmName("bdappshcolhsixgg")
    public suspend fun pipelineDefinition(`value`: Output<String>) {
        this.pipelineDefinition = value
    }

    /**
     * @param value The location of the pipeline definition stored in Amazon S3. If specified, SageMaker will retrieve the pipeline definition from this location. see Pipeline Definition S3 Location details below.
     */
    @JvmName("mfdfqxhwutinrwdj")
    public suspend fun pipelineDefinitionS3Location(`value`: Output<PipelinePipelineDefinitionS3LocationArgs>) {
        this.pipelineDefinitionS3Location = value
    }

    /**
     * @param value A description of the pipeline.
     */
    @JvmName("smpvmduchpdfrgrp")
    public suspend fun pipelineDescription(`value`: Output<String>) {
        this.pipelineDescription = value
    }

    /**
     * @param value The display name of the pipeline.
     */
    @JvmName("lqvhnwqkxoxmdqla")
    public suspend fun pipelineDisplayName(`value`: Output<String>) {
        this.pipelineDisplayName = value
    }

    /**
     * @param value The name of the pipeline.
     */
    @JvmName("gchjrmypnfusjuoj")
    public suspend fun pipelineName(`value`: Output<String>) {
        this.pipelineName = value
    }

    /**
     * @param value The ARN of the IAM role the pipeline will execute as.
     */
    @JvmName("edfyodejhnolrtlx")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wfhoarvvmfuyjucm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value This is the configuration that controls the parallelism of the pipeline. If specified, it applies to all runs of this pipeline by default. see Parallelism Configuration details below.
     */
    @JvmName("mdsgensxtdhvvsma")
    public suspend fun parallelismConfiguration(`value`: PipelineParallelismConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parallelismConfiguration = mapped
    }

    /**
     * @param argument This is the configuration that controls the parallelism of the pipeline. If specified, it applies to all runs of this pipeline by default. see Parallelism Configuration details below.
     */
    @JvmName("bdvjosmctvonxkak")
    public suspend fun parallelismConfiguration(argument: suspend PipelineParallelismConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineParallelismConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.parallelismConfiguration = mapped
    }

    /**
     * @param value The [JSON pipeline definition](https://aws-sagemaker-mlops.github.io/sagemaker-model-building-pipeline-definition-JSON-schema/) of the pipeline.
     */
    @JvmName("gbsjdbvadydeimgv")
    public suspend fun pipelineDefinition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineDefinition = mapped
    }

    /**
     * @param value The location of the pipeline definition stored in Amazon S3. If specified, SageMaker will retrieve the pipeline definition from this location. see Pipeline Definition S3 Location details below.
     */
    @JvmName("uwibouipbnrihtgt")
    public suspend fun pipelineDefinitionS3Location(`value`: PipelinePipelineDefinitionS3LocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineDefinitionS3Location = mapped
    }

    /**
     * @param argument The location of the pipeline definition stored in Amazon S3. If specified, SageMaker will retrieve the pipeline definition from this location. see Pipeline Definition S3 Location details below.
     */
    @JvmName("paepkqqtehpcirai")
    public suspend fun pipelineDefinitionS3Location(argument: suspend PipelinePipelineDefinitionS3LocationArgsBuilder.() -> Unit) {
        val toBeMapped = PipelinePipelineDefinitionS3LocationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.pipelineDefinitionS3Location = mapped
    }

    /**
     * @param value A description of the pipeline.
     */
    @JvmName("nlrxqbghihcatise")
    public suspend fun pipelineDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineDescription = mapped
    }

    /**
     * @param value The display name of the pipeline.
     */
    @JvmName("nxdxvwsubdttrpcn")
    public suspend fun pipelineDisplayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineDisplayName = mapped
    }

    /**
     * @param value The name of the pipeline.
     */
    @JvmName("xfsxtyasaqqmjdda")
    public suspend fun pipelineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineName = mapped
    }

    /**
     * @param value The ARN of the IAM role the pipeline will execute as.
     */
    @JvmName("lfangwuybcjhrtsa")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sdgfcdglabenafod")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("behnsmscradaqupr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PipelineArgs = PipelineArgs(
        parallelismConfiguration = parallelismConfiguration,
        pipelineDefinition = pipelineDefinition,
        pipelineDefinitionS3Location = pipelineDefinitionS3Location,
        pipelineDescription = pipelineDescription,
        pipelineDisplayName = pipelineDisplayName,
        pipelineName = pipelineName,
        roleArn = roleArn,
        tags = tags,
    )
}
