@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.ProjectArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.ProjectServiceCatalogProvisioningDetailsArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.ProjectServiceCatalogProvisioningDetailsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Project resource.
 *  > Note: If you are trying to use SageMaker projects with SageMaker studio you will need to add a tag with the key `sagemaker:studio-visibility` with value `true`. For more on requirements to use projects and permission needed see [AWS Docs](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-projects-templates-custom.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.Project("example", {
 *     projectName: "example",
 *     serviceCatalogProvisioningDetails: {
 *         productId: exampleAwsServicecatalogProduct.id,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.Project("example",
 *     project_name="example",
 *     service_catalog_provisioning_details={
 *         "product_id": example_aws_servicecatalog_product["id"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.Project("example", new()
 *     {
 *         ProjectName = "example",
 *         ServiceCatalogProvisioningDetails = new Aws.Sagemaker.Inputs.ProjectServiceCatalogProvisioningDetailsArgs
 *         {
 *             ProductId = exampleAwsServicecatalogProduct.Id,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewProject(ctx, "example", &sagemaker.ProjectArgs{
 * 			ProjectName: pulumi.String("example"),
 * 			ServiceCatalogProvisioningDetails: &sagemaker.ProjectServiceCatalogProvisioningDetailsArgs{
 * 				ProductId: pulumi.Any(exampleAwsServicecatalogProduct.Id),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Project;
 * import com.pulumi.aws.sagemaker.ProjectArgs;
 * import com.pulumi.aws.sagemaker.inputs.ProjectServiceCatalogProvisioningDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Project("example", ProjectArgs.builder()
 *             .projectName("example")
 *             .serviceCatalogProvisioningDetails(ProjectServiceCatalogProvisioningDetailsArgs.builder()
 *                 .productId(exampleAwsServicecatalogProduct.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:Project
 *     properties:
 *       projectName: example
 *       serviceCatalogProvisioningDetails:
 *         productId: ${exampleAwsServicecatalogProduct.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker Projects using the `project_name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/project:Project example example
 * ```
 * @property projectDescription A description for the project.
 * @property projectName The name of the Project.
 * @property serviceCatalogProvisioningDetails The product ID and provisioning artifact ID to provision a service catalog. See Service Catalog Provisioning Details below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ProjectArgs(
    public val projectDescription: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val serviceCatalogProvisioningDetails: Output<ProjectServiceCatalogProvisioningDetailsArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.ProjectArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.ProjectArgs =
        com.pulumi.aws.sagemaker.ProjectArgs.builder()
            .projectDescription(projectDescription?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .serviceCatalogProvisioningDetails(
                serviceCatalogProvisioningDetails?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ProjectArgs].
 */
@PulumiTagMarker
public class ProjectArgsBuilder internal constructor() {
    private var projectDescription: Output<String>? = null

    private var projectName: Output<String>? = null

    private var serviceCatalogProvisioningDetails:
        Output<ProjectServiceCatalogProvisioningDetailsArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A description for the project.
     */
    @JvmName("thwgscumhlpyqkpw")
    public suspend fun projectDescription(`value`: Output<String>) {
        this.projectDescription = value
    }

    /**
     * @param value The name of the Project.
     */
    @JvmName("lxatmblscakbujbl")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The product ID and provisioning artifact ID to provision a service catalog. See Service Catalog Provisioning Details below.
     */
    @JvmName("qvmkjhruqdjugsev")
    public suspend fun serviceCatalogProvisioningDetails(`value`: Output<ProjectServiceCatalogProvisioningDetailsArgs>) {
        this.serviceCatalogProvisioningDetails = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iewqpkejenxnmvyd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A description for the project.
     */
    @JvmName("gdgtadokyisbmucq")
    public suspend fun projectDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectDescription = mapped
    }

    /**
     * @param value The name of the Project.
     */
    @JvmName("jvxtvtncqmornoab")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The product ID and provisioning artifact ID to provision a service catalog. See Service Catalog Provisioning Details below.
     */
    @JvmName("ksotovnmyvebgyjs")
    public suspend fun serviceCatalogProvisioningDetails(`value`: ProjectServiceCatalogProvisioningDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceCatalogProvisioningDetails = mapped
    }

    /**
     * @param argument The product ID and provisioning artifact ID to provision a service catalog. See Service Catalog Provisioning Details below.
     */
    @JvmName("btieuccsjobmygbb")
    public suspend fun serviceCatalogProvisioningDetails(argument: suspend ProjectServiceCatalogProvisioningDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectServiceCatalogProvisioningDetailsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.serviceCatalogProvisioningDetails = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sgfjklwetjnnluqc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vbuichbphsloixdk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ProjectArgs = ProjectArgs(
        projectDescription = projectDescription,
        projectName = projectName,
        serviceCatalogProvisioningDetails = serviceCatalogProvisioningDetails,
        tags = tags,
    )
}
