@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.SagemakerFunctions.getPrebuiltEcrImagePlain
import com.pulumi.aws.sagemaker.kotlin.inputs.GetPrebuiltEcrImagePlainArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.GetPrebuiltEcrImagePlainArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.outputs.GetPrebuiltEcrImageResult
import com.pulumi.aws.sagemaker.kotlin.outputs.GetPrebuiltEcrImageResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object SagemakerFunctions {
    /**
     * Get information about prebuilt Amazon SageMaker Docker images.
     * > **NOTE:** The AWS provider creates a validly constructed `registry_path` but does not verify that the `registry_path` corresponds to an existing image. For example, using a `registry_path` containing an `image_tag` that does not correspond to a Docker image in the ECR repository, will result in an error.
     * ## Example Usage
     * Basic usage:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.sagemaker.getPrebuiltEcrImage({
     *     repositoryName: "sagemaker-scikit-learn",
     *     imageTag: "2.2-1.0.11.0",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.sagemaker.get_prebuilt_ecr_image(repository_name="sagemaker-scikit-learn",
     *     image_tag="2.2-1.0.11.0")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Sagemaker.GetPrebuiltEcrImage.Invoke(new()
     *     {
     *         RepositoryName = "sagemaker-scikit-learn",
     *         ImageTag = "2.2-1.0.11.0",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := sagemaker.GetPrebuiltEcrImage(ctx, &sagemaker.GetPrebuiltEcrImageArgs{
     * 			RepositoryName: "sagemaker-scikit-learn",
     * 			ImageTag:       pulumi.StringRef("2.2-1.0.11.0"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.sagemaker.SagemakerFunctions;
     * import com.pulumi.aws.sagemaker.inputs.GetPrebuiltEcrImageArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = SagemakerFunctions.getPrebuiltEcrImage(GetPrebuiltEcrImageArgs.builder()
     *             .repositoryName("sagemaker-scikit-learn")
     *             .imageTag("2.2-1.0.11.0")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:sagemaker:getPrebuiltEcrImage
     *       Arguments:
     *         repositoryName: sagemaker-scikit-learn
     *         imageTag: 2.2-1.0.11.0
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPrebuiltEcrImage.
     * @return A collection of values returned by getPrebuiltEcrImage.
     */
    public suspend fun getPrebuiltEcrImage(argument: GetPrebuiltEcrImagePlainArgs): GetPrebuiltEcrImageResult = toKotlin(getPrebuiltEcrImagePlain(argument.toJava()).await())

    /**
     * @see [getPrebuiltEcrImage].
     * @param dnsSuffix DNS suffix to use in the registry path. If not specified, the AWS provider sets it to the DNS suffix for the current region.
     * @param imageTag Image tag for the Docker image. If not specified, the AWS provider sets the value to `1`, which for many repositories indicates the latest version. Some repositories, such as XGBoost, do not support `1` or `latest` and specific version must be used.
     * @param region Region to use in the registry path. If not specified, the AWS provider sets it to the current region.
     * @param repositoryName Name of the repository, which is generally the algorithm or library. Values include `autogluon-inference`, `autogluon-training`, `blazingtext`, `djl-inference`, `factorization-machines`, `forecasting-deepar`, `huggingface-pytorch-inference`, `huggingface-pytorch-inference-neuron`, `huggingface-pytorch-inference-neuronx`, `huggingface-pytorch-tgi-inference`, `huggingface-pytorch-training`, `huggingface-pytorch-training-neuronx`, `huggingface-pytorch-trcomp-training`, `huggingface-tensorflow-inference`, `huggingface-tensorflow-training`, `huggingface-tensorflow-trcomp-training`, `image-classification`, `image-classification-neo`, `ipinsights`, `kmeans`, `knn`, `lda`, `linear-learner`, `mxnet-inference`, `mxnet-inference-eia`, `mxnet-training`, `ntm`, `object-detection`, `object2vec`, `pca`, `pytorch-inference`, `pytorch-inference-eia`, `pytorch-inference-graviton`, `pytorch-inference-neuronx`, `pytorch-training`, `pytorch-training-neuronx`, `pytorch-trcomp-training`, `randomcutforest`, `sagemaker-base-python`, `sagemaker-chainer`, `sagemaker-clarify-processing`, `sagemaker-data-wrangler-container`, `sagemaker-debugger-rules`, `sagemaker-geospatial-v1-0`, `sagemaker-inference-mxnet`, `sagemaker-inference-pytorch`, `sagemaker-inference-tensorflow`, `sagemaker-model-monitor-analyzer`, `sagemaker-mxnet`, `sagemaker-mxnet-eia`, `sagemaker-mxnet-serving`, `sagemaker-mxnet-serving-eia`, `sagemaker-neo-mxnet`, `sagemaker-neo-pytorch`, `sagemaker-neo-tensorflow`, `sagemaker-pytorch`, `sagemaker-rl-coach-container`, `sagemaker-rl-mxnet`, `sagemaker-rl-ray-container`, `sagemaker-rl-tensorflow`, `sagemaker-rl-vw-container`, `sagemaker-scikit-learn`, `sagemaker-spark-processing`, `sagemaker-sparkml-serving`, `sagemaker-tensorflow`, `sagemaker-tensorflow-eia`, `sagemaker-tensorflow-scriptmode`, `sagemaker-tensorflow-serving`, `sagemaker-tensorflow-serving-eia`, `sagemaker-tritonserver`, `sagemaker-xgboost`, `semantic-segmentation`, `seq2seq`, `stabilityai-pytorch-inference`, `tei`, `tei-cpu`, `tensorflow-inference`, `tensorflow-inference-eia`, `tensorflow-inference-graviton`, `tensorflow-training`, and `xgboost-neo`.
     * @return A collection of values returned by getPrebuiltEcrImage.
     */
    public suspend fun getPrebuiltEcrImage(
        dnsSuffix: String? = null,
        imageTag: String? = null,
        region: String? = null,
        repositoryName: String,
    ): GetPrebuiltEcrImageResult {
        val argument = GetPrebuiltEcrImagePlainArgs(
            dnsSuffix = dnsSuffix,
            imageTag = imageTag,
            region = region,
            repositoryName = repositoryName,
        )
        return toKotlin(getPrebuiltEcrImagePlain(argument.toJava()).await())
    }

    /**
     * @see [getPrebuiltEcrImage].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;sagemaker&#46;kotlin&#46;inputs&#46;GetPrebuiltEcrImagePlainArgs].
     * @return A collection of values returned by getPrebuiltEcrImage.
     */
    public suspend fun getPrebuiltEcrImage(argument: suspend GetPrebuiltEcrImagePlainArgsBuilder.() -> Unit): GetPrebuiltEcrImageResult {
        val builder = GetPrebuiltEcrImagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getPrebuiltEcrImagePlain(builtArgument.toJava()).await())
    }
}
