@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.SpaceArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.SpaceOwnershipSettingsArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.SpaceOwnershipSettingsArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.SpaceSpaceSettingsArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.SpaceSpaceSettingsArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.SpaceSpaceSharingSettingsArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.SpaceSpaceSharingSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Space resource.
 * ## Example Usage
 * ### Basic usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.Space("example", {
 *     domainId: test.id,
 *     spaceName: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.Space("example",
 *     domain_id=test["id"],
 *     space_name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.Space("example", new()
 *     {
 *         DomainId = test.Id,
 *         SpaceName = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewSpace(ctx, "example", &sagemaker.SpaceArgs{
 * 			DomainId:  pulumi.Any(test.Id),
 * 			SpaceName: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Space;
 * import com.pulumi.aws.sagemaker.SpaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Space("example", SpaceArgs.builder()
 *             .domainId(test.id())
 *             .spaceName("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:Space
 *     properties:
 *       domainId: ${test.id}
 *       spaceName: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker Spaces using the `id`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/space:Space test_space arn:aws:sagemaker:us-west-2:123456789012:space/domain-id/space-name
 * ```
 * @property domainId The ID of the associated Domain.
 * @property ownershipSettings A collection of ownership settings. Required if `space_sharing_settings` is set. See `ownership_settings` Block below.
 * @property spaceDisplayName The name of the space that appears in the SageMaker Studio UI.
 * @property spaceName The name of the space.
 * @property spaceSettings A collection of space settings. See `space_settings` Block below.
 * @property spaceSharingSettings A collection of space sharing settings. Required if `ownership_settings` is set. See `space_sharing_settings` Block below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SpaceArgs(
    public val domainId: Output<String>? = null,
    public val ownershipSettings: Output<SpaceOwnershipSettingsArgs>? = null,
    public val spaceDisplayName: Output<String>? = null,
    public val spaceName: Output<String>? = null,
    public val spaceSettings: Output<SpaceSpaceSettingsArgs>? = null,
    public val spaceSharingSettings: Output<SpaceSpaceSharingSettingsArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.SpaceArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.SpaceArgs =
        com.pulumi.aws.sagemaker.SpaceArgs.builder()
            .domainId(domainId?.applyValue({ args0 -> args0 }))
            .ownershipSettings(ownershipSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .spaceDisplayName(spaceDisplayName?.applyValue({ args0 -> args0 }))
            .spaceName(spaceName?.applyValue({ args0 -> args0 }))
            .spaceSettings(spaceSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .spaceSharingSettings(
                spaceSharingSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SpaceArgs].
 */
@PulumiTagMarker
public class SpaceArgsBuilder internal constructor() {
    private var domainId: Output<String>? = null

    private var ownershipSettings: Output<SpaceOwnershipSettingsArgs>? = null

    private var spaceDisplayName: Output<String>? = null

    private var spaceName: Output<String>? = null

    private var spaceSettings: Output<SpaceSpaceSettingsArgs>? = null

    private var spaceSharingSettings: Output<SpaceSpaceSharingSettingsArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The ID of the associated Domain.
     */
    @JvmName("iqtdqkgogdhgvuab")
    public suspend fun domainId(`value`: Output<String>) {
        this.domainId = value
    }

    /**
     * @param value A collection of ownership settings. Required if `space_sharing_settings` is set. See `ownership_settings` Block below.
     */
    @JvmName("ikslfimdcrugxbdm")
    public suspend fun ownershipSettings(`value`: Output<SpaceOwnershipSettingsArgs>) {
        this.ownershipSettings = value
    }

    /**
     * @param value The name of the space that appears in the SageMaker Studio UI.
     */
    @JvmName("cndtkynmafocytqq")
    public suspend fun spaceDisplayName(`value`: Output<String>) {
        this.spaceDisplayName = value
    }

    /**
     * @param value The name of the space.
     */
    @JvmName("jnklexqbbnndxuhf")
    public suspend fun spaceName(`value`: Output<String>) {
        this.spaceName = value
    }

    /**
     * @param value A collection of space settings. See `space_settings` Block below.
     */
    @JvmName("mtmiqmabbyfhdwqh")
    public suspend fun spaceSettings(`value`: Output<SpaceSpaceSettingsArgs>) {
        this.spaceSettings = value
    }

    /**
     * @param value A collection of space sharing settings. Required if `ownership_settings` is set. See `space_sharing_settings` Block below.
     */
    @JvmName("hfreucipfmjpqhov")
    public suspend fun spaceSharingSettings(`value`: Output<SpaceSpaceSharingSettingsArgs>) {
        this.spaceSharingSettings = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wyotkdtkvcucggno")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the associated Domain.
     */
    @JvmName("xjgyiwmjssxgeuyx")
    public suspend fun domainId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainId = mapped
    }

    /**
     * @param value A collection of ownership settings. Required if `space_sharing_settings` is set. See `ownership_settings` Block below.
     */
    @JvmName("istdtbbrdifmweho")
    public suspend fun ownershipSettings(`value`: SpaceOwnershipSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownershipSettings = mapped
    }

    /**
     * @param argument A collection of ownership settings. Required if `space_sharing_settings` is set. See `ownership_settings` Block below.
     */
    @JvmName("asxusxqnrfxvtpop")
    public suspend fun ownershipSettings(argument: suspend SpaceOwnershipSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SpaceOwnershipSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ownershipSettings = mapped
    }

    /**
     * @param value The name of the space that appears in the SageMaker Studio UI.
     */
    @JvmName("jlisfphuxlchixjn")
    public suspend fun spaceDisplayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spaceDisplayName = mapped
    }

    /**
     * @param value The name of the space.
     */
    @JvmName("kbsndouoiyhwyuta")
    public suspend fun spaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spaceName = mapped
    }

    /**
     * @param value A collection of space settings. See `space_settings` Block below.
     */
    @JvmName("ecoohjpybdqfohsr")
    public suspend fun spaceSettings(`value`: SpaceSpaceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spaceSettings = mapped
    }

    /**
     * @param argument A collection of space settings. See `space_settings` Block below.
     */
    @JvmName("iqvsidtcojtohbgm")
    public suspend fun spaceSettings(argument: suspend SpaceSpaceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SpaceSpaceSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.spaceSettings = mapped
    }

    /**
     * @param value A collection of space sharing settings. Required if `ownership_settings` is set. See `space_sharing_settings` Block below.
     */
    @JvmName("wittwwnfnxylqkfj")
    public suspend fun spaceSharingSettings(`value`: SpaceSpaceSharingSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spaceSharingSettings = mapped
    }

    /**
     * @param argument A collection of space sharing settings. Required if `ownership_settings` is set. See `space_sharing_settings` Block below.
     */
    @JvmName("ppoerlywvgpuujpf")
    public suspend fun spaceSharingSettings(argument: suspend SpaceSpaceSharingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SpaceSpaceSharingSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.spaceSharingSettings = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ywsolutuijenhikv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ikyfcsdtyauqcwwi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SpaceArgs = SpaceArgs(
        domainId = domainId,
        ownershipSettings = ownershipSettings,
        spaceDisplayName = spaceDisplayName,
        spaceName = spaceName,
        spaceSettings = spaceSettings,
        spaceSharingSettings = spaceSharingSettings,
        tags = tags,
    )
}
