@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [StudioLifecycleConfig].
 */
@PulumiTagMarker
public class StudioLifecycleConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StudioLifecycleConfigArgs = StudioLifecycleConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StudioLifecycleConfigArgsBuilder.() -> Unit) {
        val builder = StudioLifecycleConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StudioLifecycleConfig {
        val builtJavaResource = com.pulumi.aws.sagemaker.StudioLifecycleConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StudioLifecycleConfig(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Studio Lifecycle Config resource.
 * ## Example Usage
 * ### Basic usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.sagemaker.StudioLifecycleConfig("example", {
 *     studioLifecycleConfigName: "example",
 *     studioLifecycleConfigAppType: "JupyterServer",
 *     studioLifecycleConfigContent: std.base64encode({
 *         input: "echo Hello",
 *     }).then(invoke => invoke.result),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.sagemaker.StudioLifecycleConfig("example",
 *     studio_lifecycle_config_name="example",
 *     studio_lifecycle_config_app_type="JupyterServer",
 *     studio_lifecycle_config_content=std.base64encode(input="echo Hello").result)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.StudioLifecycleConfig("example", new()
 *     {
 *         StudioLifecycleConfigName = "example",
 *         StudioLifecycleConfigAppType = "JupyterServer",
 *         StudioLifecycleConfigContent = Std.Base64encode.Invoke(new()
 *         {
 *             Input = "echo Hello",
 *         }).Apply(invoke => invoke.Result),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeBase64encode, err := std.Base64encode(ctx, &std.Base64encodeArgs{
 * 			Input: "echo Hello",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sagemaker.NewStudioLifecycleConfig(ctx, "example", &sagemaker.StudioLifecycleConfigArgs{
 * 			StudioLifecycleConfigName:    pulumi.String("example"),
 * 			StudioLifecycleConfigAppType: pulumi.String("JupyterServer"),
 * 			StudioLifecycleConfigContent: pulumi.String(invokeBase64encode.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.StudioLifecycleConfig;
 * import com.pulumi.aws.sagemaker.StudioLifecycleConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new StudioLifecycleConfig("example", StudioLifecycleConfigArgs.builder()
 *             .studioLifecycleConfigName("example")
 *             .studioLifecycleConfigAppType("JupyterServer")
 *             .studioLifecycleConfigContent(StdFunctions.base64encode(Base64encodeArgs.builder()
 *                 .input("echo Hello")
 *                 .build()).result())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:StudioLifecycleConfig
 *     properties:
 *       studioLifecycleConfigName: example
 *       studioLifecycleConfigAppType: JupyterServer
 *       studioLifecycleConfigContent:
 *         fn::invoke:
 *           Function: std:base64encode
 *           Arguments:
 *             input: echo Hello
 *           Return: result
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker Studio Lifecycle Configs using the `studio_lifecycle_config_name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/studioLifecycleConfig:StudioLifecycleConfig example example
 * ```
 */
public class StudioLifecycleConfig internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.StudioLifecycleConfig,
) : KotlinCustomResource(javaResource, StudioLifecycleConfigMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this Studio Lifecycle Config.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The App type that the Lifecycle Configuration is attached to. Valid values are `JupyterServer`, `JupyterLab`, `CodeEditor` and `KernelGateway`.
     */
    public val studioLifecycleConfigAppType: Output<String>
        get() = javaResource.studioLifecycleConfigAppType().applyValue({ args0 -> args0 })

    /**
     * The content of your Studio Lifecycle Configuration script. This content must be base64 encoded.
     */
    public val studioLifecycleConfigContent: Output<String>
        get() = javaResource.studioLifecycleConfigContent().applyValue({ args0 -> args0 })

    /**
     * The name of the Studio Lifecycle Configuration to create.
     */
    public val studioLifecycleConfigName: Output<String>
        get() = javaResource.studioLifecycleConfigName().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object StudioLifecycleConfigMapper : ResourceMapper<StudioLifecycleConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.StudioLifecycleConfig::class == javaResource::class

    override fun map(javaResource: Resource): StudioLifecycleConfig =
        StudioLifecycleConfig(javaResource as com.pulumi.aws.sagemaker.StudioLifecycleConfig)
}

/**
 * @see [StudioLifecycleConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StudioLifecycleConfig].
 */
public suspend fun studioLifecycleConfig(
    name: String,
    block: suspend StudioLifecycleConfigResourceBuilder.() -> Unit,
): StudioLifecycleConfig {
    val builder = StudioLifecycleConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StudioLifecycleConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun studioLifecycleConfig(name: String): StudioLifecycleConfig {
    val builder = StudioLifecycleConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
