@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.StudioLifecycleConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Studio Lifecycle Config resource.
 * ## Example Usage
 * ### Basic usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.sagemaker.StudioLifecycleConfig("example", {
 *     studioLifecycleConfigName: "example",
 *     studioLifecycleConfigAppType: "JupyterServer",
 *     studioLifecycleConfigContent: std.base64encode({
 *         input: "echo Hello",
 *     }).then(invoke => invoke.result),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.sagemaker.StudioLifecycleConfig("example",
 *     studio_lifecycle_config_name="example",
 *     studio_lifecycle_config_app_type="JupyterServer",
 *     studio_lifecycle_config_content=std.base64encode(input="echo Hello").result)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.StudioLifecycleConfig("example", new()
 *     {
 *         StudioLifecycleConfigName = "example",
 *         StudioLifecycleConfigAppType = "JupyterServer",
 *         StudioLifecycleConfigContent = Std.Base64encode.Invoke(new()
 *         {
 *             Input = "echo Hello",
 *         }).Apply(invoke => invoke.Result),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeBase64encode, err := std.Base64encode(ctx, &std.Base64encodeArgs{
 * 			Input: "echo Hello",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sagemaker.NewStudioLifecycleConfig(ctx, "example", &sagemaker.StudioLifecycleConfigArgs{
 * 			StudioLifecycleConfigName:    pulumi.String("example"),
 * 			StudioLifecycleConfigAppType: pulumi.String("JupyterServer"),
 * 			StudioLifecycleConfigContent: pulumi.String(invokeBase64encode.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.StudioLifecycleConfig;
 * import com.pulumi.aws.sagemaker.StudioLifecycleConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new StudioLifecycleConfig("example", StudioLifecycleConfigArgs.builder()
 *             .studioLifecycleConfigName("example")
 *             .studioLifecycleConfigAppType("JupyterServer")
 *             .studioLifecycleConfigContent(StdFunctions.base64encode(Base64encodeArgs.builder()
 *                 .input("echo Hello")
 *                 .build()).result())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:StudioLifecycleConfig
 *     properties:
 *       studioLifecycleConfigName: example
 *       studioLifecycleConfigAppType: JupyterServer
 *       studioLifecycleConfigContent:
 *         fn::invoke:
 *           Function: std:base64encode
 *           Arguments:
 *             input: echo Hello
 *           Return: result
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker Studio Lifecycle Configs using the `studio_lifecycle_config_name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/studioLifecycleConfig:StudioLifecycleConfig example example
 * ```
 * @property studioLifecycleConfigAppType The App type that the Lifecycle Configuration is attached to. Valid values are `JupyterServer`, `JupyterLab`, `CodeEditor` and `KernelGateway`.
 * @property studioLifecycleConfigContent The content of your Studio Lifecycle Configuration script. This content must be base64 encoded.
 * @property studioLifecycleConfigName The name of the Studio Lifecycle Configuration to create.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class StudioLifecycleConfigArgs(
    public val studioLifecycleConfigAppType: Output<String>? = null,
    public val studioLifecycleConfigContent: Output<String>? = null,
    public val studioLifecycleConfigName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.StudioLifecycleConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.StudioLifecycleConfigArgs =
        com.pulumi.aws.sagemaker.StudioLifecycleConfigArgs.builder()
            .studioLifecycleConfigAppType(studioLifecycleConfigAppType?.applyValue({ args0 -> args0 }))
            .studioLifecycleConfigContent(studioLifecycleConfigContent?.applyValue({ args0 -> args0 }))
            .studioLifecycleConfigName(studioLifecycleConfigName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [StudioLifecycleConfigArgs].
 */
@PulumiTagMarker
public class StudioLifecycleConfigArgsBuilder internal constructor() {
    private var studioLifecycleConfigAppType: Output<String>? = null

    private var studioLifecycleConfigContent: Output<String>? = null

    private var studioLifecycleConfigName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The App type that the Lifecycle Configuration is attached to. Valid values are `JupyterServer`, `JupyterLab`, `CodeEditor` and `KernelGateway`.
     */
    @JvmName("svyjhpxwfokmuyuj")
    public suspend fun studioLifecycleConfigAppType(`value`: Output<String>) {
        this.studioLifecycleConfigAppType = value
    }

    /**
     * @param value The content of your Studio Lifecycle Configuration script. This content must be base64 encoded.
     */
    @JvmName("bpuapbahrpqtbtrc")
    public suspend fun studioLifecycleConfigContent(`value`: Output<String>) {
        this.studioLifecycleConfigContent = value
    }

    /**
     * @param value The name of the Studio Lifecycle Configuration to create.
     */
    @JvmName("vnbkpsocloompqdp")
    public suspend fun studioLifecycleConfigName(`value`: Output<String>) {
        this.studioLifecycleConfigName = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pshltcaychwkpkcu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The App type that the Lifecycle Configuration is attached to. Valid values are `JupyterServer`, `JupyterLab`, `CodeEditor` and `KernelGateway`.
     */
    @JvmName("uyygwbgfcqremanx")
    public suspend fun studioLifecycleConfigAppType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.studioLifecycleConfigAppType = mapped
    }

    /**
     * @param value The content of your Studio Lifecycle Configuration script. This content must be base64 encoded.
     */
    @JvmName("slqycpnrohtxkupw")
    public suspend fun studioLifecycleConfigContent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.studioLifecycleConfigContent = mapped
    }

    /**
     * @param value The name of the Studio Lifecycle Configuration to create.
     */
    @JvmName("upguxkjsqsmmykqn")
    public suspend fun studioLifecycleConfigName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.studioLifecycleConfigName = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rvaepjqebopdloik")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jpefadgpwxjwbchv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): StudioLifecycleConfigArgs = StudioLifecycleConfigArgs(
        studioLifecycleConfigAppType = studioLifecycleConfigAppType,
        studioLifecycleConfigContent = studioLifecycleConfigContent,
        studioLifecycleConfigName = studioLifecycleConfigName,
        tags = tags,
    )
}
