@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettings
import com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettings.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [UserProfile].
 */
@PulumiTagMarker
public class UserProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserProfileArgs = UserProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserProfileArgsBuilder.() -> Unit) {
        val builder = UserProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UserProfile {
        val builtJavaResource = com.pulumi.aws.sagemaker.UserProfile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserProfile(builtJavaResource)
    }
}

/**
 * Provides a SageMaker User Profile resource.
 * ## Example Usage
 * ### Basic usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.UserProfile("example", {
 *     domainId: test.id,
 *     userProfileName: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.UserProfile("example",
 *     domain_id=test["id"],
 *     user_profile_name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.UserProfile("example", new()
 *     {
 *         DomainId = test.Id,
 *         UserProfileName = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewUserProfile(ctx, "example", &sagemaker.UserProfileArgs{
 * 			DomainId:        pulumi.Any(test.Id),
 * 			UserProfileName: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.UserProfile;
 * import com.pulumi.aws.sagemaker.UserProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserProfile("example", UserProfileArgs.builder()
 *             .domainId(test.id())
 *             .userProfileName("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:UserProfile
 *     properties:
 *       domainId: ${test.id}
 *       userProfileName: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker User Profiles using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/userProfile:UserProfile test_user_profile arn:aws:sagemaker:us-west-2:123456789012:user-profile/domain-id/profile-name
 * ```
 */
public class UserProfile internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.UserProfile,
) : KotlinCustomResource(javaResource, UserProfileMapper) {
    /**
     * The user profile Amazon Resource Name (ARN).
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ID of the associated Domain.
     */
    public val domainId: Output<String>
        get() = javaResource.domainId().applyValue({ args0 -> args0 })

    /**
     * The ID of the user's profile in the Amazon Elastic File System (EFS) volume.
     */
    public val homeEfsFileSystemUid: Output<String>
        get() = javaResource.homeEfsFileSystemUid().applyValue({ args0 -> args0 })

    /**
     * A specifier for the type of value specified in `single_sign_on_user_value`. Currently, the only supported value is `UserName`. If the Domain's AuthMode is SSO, this field is required. If the Domain's AuthMode is not SSO, this field cannot be specified.
     */
    public val singleSignOnUserIdentifier: Output<String>?
        get() = javaResource.singleSignOnUserIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The username of the associated AWS Single Sign-On User for this User Profile. If the Domain's AuthMode is SSO, this field is required, and must match a valid username of a user in your directory. If the Domain's AuthMode is not SSO, this field cannot be specified.
     */
    public val singleSignOnUserValue: Output<String>?
        get() = javaResource.singleSignOnUserValue().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The name for the User Profile.
     */
    public val userProfileName: Output<String>
        get() = javaResource.userProfileName().applyValue({ args0 -> args0 })

    /**
     * The user settings. See User Settings below.
     */
    public val userSettings: Output<UserProfileUserSettings>?
        get() = javaResource.userSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })
}

public object UserProfileMapper : ResourceMapper<UserProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.UserProfile::class == javaResource::class

    override fun map(javaResource: Resource): UserProfile = UserProfile(
        javaResource as
            com.pulumi.aws.sagemaker.UserProfile,
    )
}

/**
 * @see [UserProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserProfile].
 */
public suspend fun userProfile(name: String, block: suspend UserProfileResourceBuilder.() -> Unit): UserProfile {
    val builder = UserProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userProfile(name: String): UserProfile {
    val builder = UserProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
