@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.WorkforceCognitoConfig
import com.pulumi.aws.sagemaker.kotlin.outputs.WorkforceOidcConfig
import com.pulumi.aws.sagemaker.kotlin.outputs.WorkforceSourceIpConfig
import com.pulumi.aws.sagemaker.kotlin.outputs.WorkforceWorkforceVpcConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.sagemaker.kotlin.outputs.WorkforceCognitoConfig.Companion.toKotlin as workforceCognitoConfigToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.WorkforceOidcConfig.Companion.toKotlin as workforceOidcConfigToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.WorkforceSourceIpConfig.Companion.toKotlin as workforceSourceIpConfigToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.WorkforceWorkforceVpcConfig.Companion.toKotlin as workforceWorkforceVpcConfigToKotlin

/**
 * Builder for [Workforce].
 */
@PulumiTagMarker
public class WorkforceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkforceArgs = WorkforceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkforceArgsBuilder.() -> Unit) {
        val builder = WorkforceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Workforce {
        val builtJavaResource = com.pulumi.aws.sagemaker.Workforce(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Workforce(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Workforce resource.
 * ## Example Usage
 * ### Cognito Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleUserPool = new aws.cognito.UserPool("example", {name: "example"});
 * const exampleUserPoolClient = new aws.cognito.UserPoolClient("example", {
 *     name: "example",
 *     generateSecret: true,
 *     userPoolId: exampleUserPool.id,
 * });
 * const exampleUserPoolDomain = new aws.cognito.UserPoolDomain("example", {
 *     domain: "example",
 *     userPoolId: exampleUserPool.id,
 * });
 * const example = new aws.sagemaker.Workforce("example", {
 *     workforceName: "example",
 *     cognitoConfig: {
 *         clientId: exampleUserPoolClient.id,
 *         userPool: exampleUserPoolDomain.userPoolId,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_user_pool = aws.cognito.UserPool("example", name="example")
 * example_user_pool_client = aws.cognito.UserPoolClient("example",
 *     name="example",
 *     generate_secret=True,
 *     user_pool_id=example_user_pool.id)
 * example_user_pool_domain = aws.cognito.UserPoolDomain("example",
 *     domain="example",
 *     user_pool_id=example_user_pool.id)
 * example = aws.sagemaker.Workforce("example",
 *     workforce_name="example",
 *     cognito_config={
 *         "client_id": example_user_pool_client.id,
 *         "user_pool": example_user_pool_domain.user_pool_id,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleUserPool = new Aws.Cognito.UserPool("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var exampleUserPoolClient = new Aws.Cognito.UserPoolClient("example", new()
 *     {
 *         Name = "example",
 *         GenerateSecret = true,
 *         UserPoolId = exampleUserPool.Id,
 *     });
 *     var exampleUserPoolDomain = new Aws.Cognito.UserPoolDomain("example", new()
 *     {
 *         Domain = "example",
 *         UserPoolId = exampleUserPool.Id,
 *     });
 *     var example = new Aws.Sagemaker.Workforce("example", new()
 *     {
 *         WorkforceName = "example",
 *         CognitoConfig = new Aws.Sagemaker.Inputs.WorkforceCognitoConfigArgs
 *         {
 *             ClientId = exampleUserPoolClient.Id,
 *             UserPool = exampleUserPoolDomain.UserPoolId,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/cognito"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleUserPool, err := cognito.NewUserPool(ctx, "example", &cognito.UserPoolArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleUserPoolClient, err := cognito.NewUserPoolClient(ctx, "example", &cognito.UserPoolClientArgs{
 * 			Name:           pulumi.String("example"),
 * 			GenerateSecret: pulumi.Bool(true),
 * 			UserPoolId:     exampleUserPool.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleUserPoolDomain, err := cognito.NewUserPoolDomain(ctx, "example", &cognito.UserPoolDomainArgs{
 * 			Domain:     pulumi.String("example"),
 * 			UserPoolId: exampleUserPool.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = sagemaker.NewWorkforce(ctx, "example", &sagemaker.WorkforceArgs{
 * 			WorkforceName: pulumi.String("example"),
 * 			CognitoConfig: &sagemaker.WorkforceCognitoConfigArgs{
 * 				ClientId: exampleUserPoolClient.ID(),
 * 				UserPool: exampleUserPoolDomain.UserPoolId,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cognito.UserPool;
 * import com.pulumi.aws.cognito.UserPoolArgs;
 * import com.pulumi.aws.cognito.UserPoolClient;
 * import com.pulumi.aws.cognito.UserPoolClientArgs;
 * import com.pulumi.aws.cognito.UserPoolDomain;
 * import com.pulumi.aws.cognito.UserPoolDomainArgs;
 * import com.pulumi.aws.sagemaker.Workforce;
 * import com.pulumi.aws.sagemaker.WorkforceArgs;
 * import com.pulumi.aws.sagemaker.inputs.WorkforceCognitoConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleUserPool = new UserPool("exampleUserPool", UserPoolArgs.builder()
 *             .name("example")
 *             .build());
 *         var exampleUserPoolClient = new UserPoolClient("exampleUserPoolClient", UserPoolClientArgs.builder()
 *             .name("example")
 *             .generateSecret(true)
 *             .userPoolId(exampleUserPool.id())
 *             .build());
 *         var exampleUserPoolDomain = new UserPoolDomain("exampleUserPoolDomain", UserPoolDomainArgs.builder()
 *             .domain("example")
 *             .userPoolId(exampleUserPool.id())
 *             .build());
 *         var example = new Workforce("example", WorkforceArgs.builder()
 *             .workforceName("example")
 *             .cognitoConfig(WorkforceCognitoConfigArgs.builder()
 *                 .clientId(exampleUserPoolClient.id())
 *                 .userPool(exampleUserPoolDomain.userPoolId())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:Workforce
 *     properties:
 *       workforceName: example
 *       cognitoConfig:
 *         clientId: ${exampleUserPoolClient.id}
 *         userPool: ${exampleUserPoolDomain.userPoolId}
 *   exampleUserPool:
 *     type: aws:cognito:UserPool
 *     name: example
 *     properties:
 *       name: example
 *   exampleUserPoolClient:
 *     type: aws:cognito:UserPoolClient
 *     name: example
 *     properties:
 *       name: example
 *       generateSecret: true
 *       userPoolId: ${exampleUserPool.id}
 *   exampleUserPoolDomain:
 *     type: aws:cognito:UserPoolDomain
 *     name: example
 *     properties:
 *       domain: example
 *       userPoolId: ${exampleUserPool.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Oidc Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.Workforce("example", {
 *     workforceName: "example",
 *     oidcConfig: {
 *         authorizationEndpoint: "https://example.com",
 *         clientId: "example",
 *         clientSecret: "example",
 *         issuer: "https://example.com",
 *         jwksUri: "https://example.com",
 *         logoutEndpoint: "https://example.com",
 *         tokenEndpoint: "https://example.com",
 *         userInfoEndpoint: "https://example.com",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.Workforce("example",
 *     workforce_name="example",
 *     oidc_config={
 *         "authorization_endpoint": "https://example.com",
 *         "client_id": "example",
 *         "client_secret": "example",
 *         "issuer": "https://example.com",
 *         "jwks_uri": "https://example.com",
 *         "logout_endpoint": "https://example.com",
 *         "token_endpoint": "https://example.com",
 *         "user_info_endpoint": "https://example.com",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.Workforce("example", new()
 *     {
 *         WorkforceName = "example",
 *         OidcConfig = new Aws.Sagemaker.Inputs.WorkforceOidcConfigArgs
 *         {
 *             AuthorizationEndpoint = "https://example.com",
 *             ClientId = "example",
 *             ClientSecret = "example",
 *             Issuer = "https://example.com",
 *             JwksUri = "https://example.com",
 *             LogoutEndpoint = "https://example.com",
 *             TokenEndpoint = "https://example.com",
 *             UserInfoEndpoint = "https://example.com",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewWorkforce(ctx, "example", &sagemaker.WorkforceArgs{
 * 			WorkforceName: pulumi.String("example"),
 * 			OidcConfig: &sagemaker.WorkforceOidcConfigArgs{
 * 				AuthorizationEndpoint: pulumi.String("https://example.com"),
 * 				ClientId:              pulumi.String("example"),
 * 				ClientSecret:          pulumi.String("example"),
 * 				Issuer:                pulumi.String("https://example.com"),
 * 				JwksUri:               pulumi.String("https://example.com"),
 * 				LogoutEndpoint:        pulumi.String("https://example.com"),
 * 				TokenEndpoint:         pulumi.String("https://example.com"),
 * 				UserInfoEndpoint:      pulumi.String("https://example.com"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Workforce;
 * import com.pulumi.aws.sagemaker.WorkforceArgs;
 * import com.pulumi.aws.sagemaker.inputs.WorkforceOidcConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workforce("example", WorkforceArgs.builder()
 *             .workforceName("example")
 *             .oidcConfig(WorkforceOidcConfigArgs.builder()
 *                 .authorizationEndpoint("https://example.com")
 *                 .clientId("example")
 *                 .clientSecret("example")
 *                 .issuer("https://example.com")
 *                 .jwksUri("https://example.com")
 *                 .logoutEndpoint("https://example.com")
 *                 .tokenEndpoint("https://example.com")
 *                 .userInfoEndpoint("https://example.com")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:Workforce
 *     properties:
 *       workforceName: example
 *       oidcConfig:
 *         authorizationEndpoint: https://example.com
 *         clientId: example
 *         clientSecret: example
 *         issuer: https://example.com
 *         jwksUri: https://example.com
 *         logoutEndpoint: https://example.com
 *         tokenEndpoint: https://example.com
 *         userInfoEndpoint: https://example.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker Workforces using the `workforce_name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/workforce:Workforce example example
 * ```
 */
public class Workforce internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.Workforce,
) : KotlinCustomResource(javaResource, WorkforceMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this Workforce.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is created using and corresponds to a single Amazon Cognito user pool. Conflicts with `oidc_config`. see Cognito Config details below.
     */
    public val cognitoConfig: Output<WorkforceCognitoConfig>?
        get() = javaResource.cognitoConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> workforceCognitoConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Use this parameter to configure a private workforce using your own OIDC Identity Provider. Conflicts with `cognito_config`. see OIDC Config details below.
     */
    public val oidcConfig: Output<WorkforceOidcConfig>?
        get() = javaResource.oidcConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    workforceOidcConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A list of IP address ranges Used to create an allow list of IP addresses for a private workforce. By default, a workforce isn't restricted to specific IP addresses. see Source Ip Config details below.
     */
    public val sourceIpConfig: Output<WorkforceSourceIpConfig>
        get() = javaResource.sourceIpConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                workforceSourceIpConfigToKotlin(args0)
            })
        })

    /**
     * The subdomain for your OIDC Identity Provider.
     */
    public val subdomain: Output<String>
        get() = javaResource.subdomain().applyValue({ args0 -> args0 })

    /**
     * The name of the Workforce (must be unique).
     */
    public val workforceName: Output<String>
        get() = javaResource.workforceName().applyValue({ args0 -> args0 })

    /**
     * configure a workforce using VPC. see Workforce VPC Config details below.
     */
    public val workforceVpcConfig: Output<WorkforceWorkforceVpcConfig>?
        get() = javaResource.workforceVpcConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> workforceWorkforceVpcConfigToKotlin(args0) })
            }).orElse(null)
        })
}

public object WorkforceMapper : ResourceMapper<Workforce> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.Workforce::class == javaResource::class

    override fun map(javaResource: Resource): Workforce = Workforce(
        javaResource as
            com.pulumi.aws.sagemaker.Workforce,
    )
}

/**
 * @see [Workforce].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Workforce].
 */
public suspend fun workforce(name: String, block: suspend WorkforceResourceBuilder.() -> Unit): Workforce {
    val builder = WorkforceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Workforce].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workforce(name: String): Workforce {
    val builder = WorkforceResourceBuilder()
    builder.name(name)
    return builder.build()
}
