@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.kotlin.outputs.WorkteamMemberDefinition
import com.pulumi.aws.sagemaker.kotlin.outputs.WorkteamNotificationConfiguration
import com.pulumi.aws.sagemaker.kotlin.outputs.WorkteamWorkerAccessConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.sagemaker.kotlin.outputs.WorkteamMemberDefinition.Companion.toKotlin as workteamMemberDefinitionToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.WorkteamNotificationConfiguration.Companion.toKotlin as workteamNotificationConfigurationToKotlin
import com.pulumi.aws.sagemaker.kotlin.outputs.WorkteamWorkerAccessConfiguration.Companion.toKotlin as workteamWorkerAccessConfigurationToKotlin

/**
 * Builder for [Workteam].
 */
@PulumiTagMarker
public class WorkteamResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkteamArgs = WorkteamArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkteamArgsBuilder.() -> Unit) {
        val builder = WorkteamArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Workteam {
        val builtJavaResource = com.pulumi.aws.sagemaker.Workteam(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Workteam(builtJavaResource)
    }
}

/**
 * Provides a SageMaker Workteam resource.
 * ## Example Usage
 * ### Cognito Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.Workteam("example", {
 *     workteamName: "example",
 *     workforceName: exampleAwsSagemakerWorkforce.id,
 *     description: "example",
 *     memberDefinitions: [{
 *         cognitoMemberDefinition: {
 *             clientId: exampleAwsCognitoUserPoolClient.id,
 *             userPool: exampleAwsCognitoUserPoolDomain.userPoolId,
 *             userGroup: exampleAwsCognitoUserGroup.id,
 *         },
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.Workteam("example",
 *     workteam_name="example",
 *     workforce_name=example_aws_sagemaker_workforce["id"],
 *     description="example",
 *     member_definitions=[{
 *         "cognito_member_definition": {
 *             "client_id": example_aws_cognito_user_pool_client["id"],
 *             "user_pool": example_aws_cognito_user_pool_domain["userPoolId"],
 *             "user_group": example_aws_cognito_user_group["id"],
 *         },
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.Workteam("example", new()
 *     {
 *         WorkteamName = "example",
 *         WorkforceName = exampleAwsSagemakerWorkforce.Id,
 *         Description = "example",
 *         MemberDefinitions = new[]
 *         {
 *             new Aws.Sagemaker.Inputs.WorkteamMemberDefinitionArgs
 *             {
 *                 CognitoMemberDefinition = new Aws.Sagemaker.Inputs.WorkteamMemberDefinitionCognitoMemberDefinitionArgs
 *                 {
 *                     ClientId = exampleAwsCognitoUserPoolClient.Id,
 *                     UserPool = exampleAwsCognitoUserPoolDomain.UserPoolId,
 *                     UserGroup = exampleAwsCognitoUserGroup.Id,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewWorkteam(ctx, "example", &sagemaker.WorkteamArgs{
 * 			WorkteamName:  pulumi.String("example"),
 * 			WorkforceName: pulumi.Any(exampleAwsSagemakerWorkforce.Id),
 * 			Description:   pulumi.String("example"),
 * 			MemberDefinitions: sagemaker.WorkteamMemberDefinitionArray{
 * 				&sagemaker.WorkteamMemberDefinitionArgs{
 * 					CognitoMemberDefinition: &sagemaker.WorkteamMemberDefinitionCognitoMemberDefinitionArgs{
 * 						ClientId:  pulumi.Any(exampleAwsCognitoUserPoolClient.Id),
 * 						UserPool:  pulumi.Any(exampleAwsCognitoUserPoolDomain.UserPoolId),
 * 						UserGroup: pulumi.Any(exampleAwsCognitoUserGroup.Id),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Workteam;
 * import com.pulumi.aws.sagemaker.WorkteamArgs;
 * import com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionCognitoMemberDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workteam("example", WorkteamArgs.builder()
 *             .workteamName("example")
 *             .workforceName(exampleAwsSagemakerWorkforce.id())
 *             .description("example")
 *             .memberDefinitions(WorkteamMemberDefinitionArgs.builder()
 *                 .cognitoMemberDefinition(WorkteamMemberDefinitionCognitoMemberDefinitionArgs.builder()
 *                     .clientId(exampleAwsCognitoUserPoolClient.id())
 *                     .userPool(exampleAwsCognitoUserPoolDomain.userPoolId())
 *                     .userGroup(exampleAwsCognitoUserGroup.id())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:Workteam
 *     properties:
 *       workteamName: example
 *       workforceName: ${exampleAwsSagemakerWorkforce.id}
 *       description: example
 *       memberDefinitions:
 *         - cognitoMemberDefinition:
 *             clientId: ${exampleAwsCognitoUserPoolClient.id}
 *             userPool: ${exampleAwsCognitoUserPoolDomain.userPoolId}
 *             userGroup: ${exampleAwsCognitoUserGroup.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Oidc Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.Workteam("example", {
 *     workteamName: "example",
 *     workforceName: exampleAwsSagemakerWorkforce.id,
 *     description: "example",
 *     memberDefinitions: [{
 *         oidcMemberDefinition: {
 *             groups: ["example"],
 *         },
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.Workteam("example",
 *     workteam_name="example",
 *     workforce_name=example_aws_sagemaker_workforce["id"],
 *     description="example",
 *     member_definitions=[{
 *         "oidc_member_definition": {
 *             "groups": ["example"],
 *         },
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.Workteam("example", new()
 *     {
 *         WorkteamName = "example",
 *         WorkforceName = exampleAwsSagemakerWorkforce.Id,
 *         Description = "example",
 *         MemberDefinitions = new[]
 *         {
 *             new Aws.Sagemaker.Inputs.WorkteamMemberDefinitionArgs
 *             {
 *                 OidcMemberDefinition = new Aws.Sagemaker.Inputs.WorkteamMemberDefinitionOidcMemberDefinitionArgs
 *                 {
 *                     Groups = new[]
 *                     {
 *                         "example",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewWorkteam(ctx, "example", &sagemaker.WorkteamArgs{
 * 			WorkteamName:  pulumi.String("example"),
 * 			WorkforceName: pulumi.Any(exampleAwsSagemakerWorkforce.Id),
 * 			Description:   pulumi.String("example"),
 * 			MemberDefinitions: sagemaker.WorkteamMemberDefinitionArray{
 * 				&sagemaker.WorkteamMemberDefinitionArgs{
 * 					OidcMemberDefinition: &sagemaker.WorkteamMemberDefinitionOidcMemberDefinitionArgs{
 * 						Groups: pulumi.StringArray{
 * 							pulumi.String("example"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Workteam;
 * import com.pulumi.aws.sagemaker.WorkteamArgs;
 * import com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionOidcMemberDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workteam("example", WorkteamArgs.builder()
 *             .workteamName("example")
 *             .workforceName(exampleAwsSagemakerWorkforce.id())
 *             .description("example")
 *             .memberDefinitions(WorkteamMemberDefinitionArgs.builder()
 *                 .oidcMemberDefinition(WorkteamMemberDefinitionOidcMemberDefinitionArgs.builder()
 *                     .groups("example")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:Workteam
 *     properties:
 *       workteamName: example
 *       workforceName: ${exampleAwsSagemakerWorkforce.id}
 *       description: example
 *       memberDefinitions:
 *         - oidcMemberDefinition:
 *             groups:
 *               - example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker Workteams using the `workteam_name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/workteam:Workteam example example
 * ```
 */
public class Workteam internal constructor(
    override val javaResource: com.pulumi.aws.sagemaker.Workteam,
) : KotlinCustomResource(javaResource, WorkteamMapper) {
    /**
     * The Amazon Resource Name (ARN) assigned by AWS to this Workteam.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A description of the work team.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
     */
    public val memberDefinitions: Output<List<WorkteamMemberDefinition>>
        get() = javaResource.memberDefinitions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> workteamMemberDefinitionToKotlin(args0) })
            })
        })

    /**
     * Configures notification of workers regarding available or expiring work items. see Notification Configuration details below.
     */
    public val notificationConfiguration: Output<WorkteamNotificationConfiguration>?
        get() = javaResource.notificationConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> workteamNotificationConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The subdomain for your OIDC Identity Provider.
     */
    public val subdomain: Output<String>
        get() = javaResource.subdomain().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Use this optional parameter to constrain access to an Amazon S3 resource based on the IP address using supported IAM global condition keys. The Amazon S3 resource is accessed in the worker portal using a Amazon S3 presigned URL. see Worker Access Configuration details below.
     */
    public val workerAccessConfiguration: Output<WorkteamWorkerAccessConfiguration>
        get() = javaResource.workerAccessConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                workteamWorkerAccessConfigurationToKotlin(args0)
            })
        })

    /**
     * The name of the Workteam (must be unique).
     */
    public val workforceName: Output<String>
        get() = javaResource.workforceName().applyValue({ args0 -> args0 })

    /**
     * The name of the workforce.
     */
    public val workteamName: Output<String>
        get() = javaResource.workteamName().applyValue({ args0 -> args0 })
}

public object WorkteamMapper : ResourceMapper<Workteam> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.sagemaker.Workteam::class == javaResource::class

    override fun map(javaResource: Resource): Workteam = Workteam(
        javaResource as
            com.pulumi.aws.sagemaker.Workteam,
    )
}

/**
 * @see [Workteam].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Workteam].
 */
public suspend fun workteam(name: String, block: suspend WorkteamResourceBuilder.() -> Unit): Workteam {
    val builder = WorkteamResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Workteam].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workteam(name: String): Workteam {
    val builder = WorkteamResourceBuilder()
    builder.name(name)
    return builder.build()
}
