@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin

import com.pulumi.aws.sagemaker.WorkteamArgs.builder
import com.pulumi.aws.sagemaker.kotlin.inputs.WorkteamMemberDefinitionArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.WorkteamMemberDefinitionArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.WorkteamNotificationConfigurationArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.WorkteamNotificationConfigurationArgsBuilder
import com.pulumi.aws.sagemaker.kotlin.inputs.WorkteamWorkerAccessConfigurationArgs
import com.pulumi.aws.sagemaker.kotlin.inputs.WorkteamWorkerAccessConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a SageMaker Workteam resource.
 * ## Example Usage
 * ### Cognito Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.Workteam("example", {
 *     workteamName: "example",
 *     workforceName: exampleAwsSagemakerWorkforce.id,
 *     description: "example",
 *     memberDefinitions: [{
 *         cognitoMemberDefinition: {
 *             clientId: exampleAwsCognitoUserPoolClient.id,
 *             userPool: exampleAwsCognitoUserPoolDomain.userPoolId,
 *             userGroup: exampleAwsCognitoUserGroup.id,
 *         },
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.Workteam("example",
 *     workteam_name="example",
 *     workforce_name=example_aws_sagemaker_workforce["id"],
 *     description="example",
 *     member_definitions=[{
 *         "cognito_member_definition": {
 *             "client_id": example_aws_cognito_user_pool_client["id"],
 *             "user_pool": example_aws_cognito_user_pool_domain["userPoolId"],
 *             "user_group": example_aws_cognito_user_group["id"],
 *         },
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.Workteam("example", new()
 *     {
 *         WorkteamName = "example",
 *         WorkforceName = exampleAwsSagemakerWorkforce.Id,
 *         Description = "example",
 *         MemberDefinitions = new[]
 *         {
 *             new Aws.Sagemaker.Inputs.WorkteamMemberDefinitionArgs
 *             {
 *                 CognitoMemberDefinition = new Aws.Sagemaker.Inputs.WorkteamMemberDefinitionCognitoMemberDefinitionArgs
 *                 {
 *                     ClientId = exampleAwsCognitoUserPoolClient.Id,
 *                     UserPool = exampleAwsCognitoUserPoolDomain.UserPoolId,
 *                     UserGroup = exampleAwsCognitoUserGroup.Id,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewWorkteam(ctx, "example", &sagemaker.WorkteamArgs{
 * 			WorkteamName:  pulumi.String("example"),
 * 			WorkforceName: pulumi.Any(exampleAwsSagemakerWorkforce.Id),
 * 			Description:   pulumi.String("example"),
 * 			MemberDefinitions: sagemaker.WorkteamMemberDefinitionArray{
 * 				&sagemaker.WorkteamMemberDefinitionArgs{
 * 					CognitoMemberDefinition: &sagemaker.WorkteamMemberDefinitionCognitoMemberDefinitionArgs{
 * 						ClientId:  pulumi.Any(exampleAwsCognitoUserPoolClient.Id),
 * 						UserPool:  pulumi.Any(exampleAwsCognitoUserPoolDomain.UserPoolId),
 * 						UserGroup: pulumi.Any(exampleAwsCognitoUserGroup.Id),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Workteam;
 * import com.pulumi.aws.sagemaker.WorkteamArgs;
 * import com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionCognitoMemberDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workteam("example", WorkteamArgs.builder()
 *             .workteamName("example")
 *             .workforceName(exampleAwsSagemakerWorkforce.id())
 *             .description("example")
 *             .memberDefinitions(WorkteamMemberDefinitionArgs.builder()
 *                 .cognitoMemberDefinition(WorkteamMemberDefinitionCognitoMemberDefinitionArgs.builder()
 *                     .clientId(exampleAwsCognitoUserPoolClient.id())
 *                     .userPool(exampleAwsCognitoUserPoolDomain.userPoolId())
 *                     .userGroup(exampleAwsCognitoUserGroup.id())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:Workteam
 *     properties:
 *       workteamName: example
 *       workforceName: ${exampleAwsSagemakerWorkforce.id}
 *       description: example
 *       memberDefinitions:
 *         - cognitoMemberDefinition:
 *             clientId: ${exampleAwsCognitoUserPoolClient.id}
 *             userPool: ${exampleAwsCognitoUserPoolDomain.userPoolId}
 *             userGroup: ${exampleAwsCognitoUserGroup.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Oidc Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sagemaker.Workteam("example", {
 *     workteamName: "example",
 *     workforceName: exampleAwsSagemakerWorkforce.id,
 *     description: "example",
 *     memberDefinitions: [{
 *         oidcMemberDefinition: {
 *             groups: ["example"],
 *         },
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sagemaker.Workteam("example",
 *     workteam_name="example",
 *     workforce_name=example_aws_sagemaker_workforce["id"],
 *     description="example",
 *     member_definitions=[{
 *         "oidc_member_definition": {
 *             "groups": ["example"],
 *         },
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sagemaker.Workteam("example", new()
 *     {
 *         WorkteamName = "example",
 *         WorkforceName = exampleAwsSagemakerWorkforce.Id,
 *         Description = "example",
 *         MemberDefinitions = new[]
 *         {
 *             new Aws.Sagemaker.Inputs.WorkteamMemberDefinitionArgs
 *             {
 *                 OidcMemberDefinition = new Aws.Sagemaker.Inputs.WorkteamMemberDefinitionOidcMemberDefinitionArgs
 *                 {
 *                     Groups = new[]
 *                     {
 *                         "example",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sagemaker"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sagemaker.NewWorkteam(ctx, "example", &sagemaker.WorkteamArgs{
 * 			WorkteamName:  pulumi.String("example"),
 * 			WorkforceName: pulumi.Any(exampleAwsSagemakerWorkforce.Id),
 * 			Description:   pulumi.String("example"),
 * 			MemberDefinitions: sagemaker.WorkteamMemberDefinitionArray{
 * 				&sagemaker.WorkteamMemberDefinitionArgs{
 * 					OidcMemberDefinition: &sagemaker.WorkteamMemberDefinitionOidcMemberDefinitionArgs{
 * 						Groups: pulumi.StringArray{
 * 							pulumi.String("example"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sagemaker.Workteam;
 * import com.pulumi.aws.sagemaker.WorkteamArgs;
 * import com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionArgs;
 * import com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionOidcMemberDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workteam("example", WorkteamArgs.builder()
 *             .workteamName("example")
 *             .workforceName(exampleAwsSagemakerWorkforce.id())
 *             .description("example")
 *             .memberDefinitions(WorkteamMemberDefinitionArgs.builder()
 *                 .oidcMemberDefinition(WorkteamMemberDefinitionOidcMemberDefinitionArgs.builder()
 *                     .groups("example")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:sagemaker:Workteam
 *     properties:
 *       workteamName: example
 *       workforceName: ${exampleAwsSagemakerWorkforce.id}
 *       description: example
 *       memberDefinitions:
 *         - oidcMemberDefinition:
 *             groups:
 *               - example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SageMaker Workteams using the `workteam_name`. For example:
 * ```sh
 * $ pulumi import aws:sagemaker/workteam:Workteam example example
 * ```
 * @property description A description of the work team.
 * @property memberDefinitions A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
 * @property notificationConfiguration Configures notification of workers regarding available or expiring work items. see Notification Configuration details below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property workerAccessConfiguration Use this optional parameter to constrain access to an Amazon S3 resource based on the IP address using supported IAM global condition keys. The Amazon S3 resource is accessed in the worker portal using a Amazon S3 presigned URL. see Worker Access Configuration details below.
 * @property workforceName The name of the Workteam (must be unique).
 * @property workteamName The name of the workforce.
 */
public data class WorkteamArgs(
    public val description: Output<String>? = null,
    public val memberDefinitions: Output<List<WorkteamMemberDefinitionArgs>>? = null,
    public val notificationConfiguration: Output<WorkteamNotificationConfigurationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workerAccessConfiguration: Output<WorkteamWorkerAccessConfigurationArgs>? = null,
    public val workforceName: Output<String>? = null,
    public val workteamName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.WorkteamArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.WorkteamArgs =
        com.pulumi.aws.sagemaker.WorkteamArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .memberDefinitions(
                memberDefinitions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .notificationConfiguration(
                notificationConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workerAccessConfiguration(
                workerAccessConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .workforceName(workforceName?.applyValue({ args0 -> args0 }))
            .workteamName(workteamName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkteamArgs].
 */
@PulumiTagMarker
public class WorkteamArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var memberDefinitions: Output<List<WorkteamMemberDefinitionArgs>>? = null

    private var notificationConfiguration: Output<WorkteamNotificationConfigurationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workerAccessConfiguration: Output<WorkteamWorkerAccessConfigurationArgs>? = null

    private var workforceName: Output<String>? = null

    private var workteamName: Output<String>? = null

    /**
     * @param value A description of the work team.
     */
    @JvmName("kosgqsiibnoffibs")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
     */
    @JvmName("ltleektyjsxlenvs")
    public suspend fun memberDefinitions(`value`: Output<List<WorkteamMemberDefinitionArgs>>) {
        this.memberDefinitions = value
    }

    @JvmName("kikisrlsnfsomife")
    public suspend fun memberDefinitions(vararg values: Output<WorkteamMemberDefinitionArgs>) {
        this.memberDefinitions = Output.all(values.asList())
    }

    /**
     * @param values A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
     */
    @JvmName("muxqodswevosncpc")
    public suspend fun memberDefinitions(values: List<Output<WorkteamMemberDefinitionArgs>>) {
        this.memberDefinitions = Output.all(values)
    }

    /**
     * @param value Configures notification of workers regarding available or expiring work items. see Notification Configuration details below.
     */
    @JvmName("tnnmtjjdbpavfhod")
    public suspend fun notificationConfiguration(`value`: Output<WorkteamNotificationConfigurationArgs>) {
        this.notificationConfiguration = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nmucovblsnvpcyev")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Use this optional parameter to constrain access to an Amazon S3 resource based on the IP address using supported IAM global condition keys. The Amazon S3 resource is accessed in the worker portal using a Amazon S3 presigned URL. see Worker Access Configuration details below.
     */
    @JvmName("uidxjymmpqkkasdy")
    public suspend fun workerAccessConfiguration(`value`: Output<WorkteamWorkerAccessConfigurationArgs>) {
        this.workerAccessConfiguration = value
    }

    /**
     * @param value The name of the Workteam (must be unique).
     */
    @JvmName("wxvghhacueuqonfy")
    public suspend fun workforceName(`value`: Output<String>) {
        this.workforceName = value
    }

    /**
     * @param value The name of the workforce.
     */
    @JvmName("gurfklbuowvlsudu")
    public suspend fun workteamName(`value`: Output<String>) {
        this.workteamName = value
    }

    /**
     * @param value A description of the work team.
     */
    @JvmName("gqtbfwrqovnkdlnx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
     */
    @JvmName("smfyqhufklnfkvem")
    public suspend fun memberDefinitions(`value`: List<WorkteamMemberDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberDefinitions = mapped
    }

    /**
     * @param argument A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
     */
    @JvmName("fuocqwmnuuvnywqk")
    public suspend fun memberDefinitions(argument: List<suspend WorkteamMemberDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WorkteamMemberDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.memberDefinitions = mapped
    }

    /**
     * @param argument A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
     */
    @JvmName("vxbwbyaatgmdadak")
    public suspend fun memberDefinitions(vararg argument: suspend WorkteamMemberDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WorkteamMemberDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.memberDefinitions = mapped
    }

    /**
     * @param argument A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
     */
    @JvmName("amgibybdeoaykxka")
    public suspend fun memberDefinitions(argument: suspend WorkteamMemberDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WorkteamMemberDefinitionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.memberDefinitions = mapped
    }

    /**
     * @param values A list of Member Definitions that contains objects that identify the workers that make up the work team. Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use `cognito_member_definition`. For workforces created using your own OIDC identity provider (IdP) use `oidc_member_definition`. Do not provide input for both of these parameters in a single request. see Member Definition details below.
     */
    @JvmName("qnaktxpbpxjyrofb")
    public suspend fun memberDefinitions(vararg values: WorkteamMemberDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.memberDefinitions = mapped
    }

    /**
     * @param value Configures notification of workers regarding available or expiring work items. see Notification Configuration details below.
     */
    @JvmName("atvpojbowtfkhjar")
    public suspend fun notificationConfiguration(`value`: WorkteamNotificationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationConfiguration = mapped
    }

    /**
     * @param argument Configures notification of workers regarding available or expiring work items. see Notification Configuration details below.
     */
    @JvmName("mmnxpefqpeajoiod")
    public suspend fun notificationConfiguration(argument: suspend WorkteamNotificationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = WorkteamNotificationConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.notificationConfiguration = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("etsoiypqellgpbra")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xsoxupaektqwqbre")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Use this optional parameter to constrain access to an Amazon S3 resource based on the IP address using supported IAM global condition keys. The Amazon S3 resource is accessed in the worker portal using a Amazon S3 presigned URL. see Worker Access Configuration details below.
     */
    @JvmName("mmuqhmhyyuieqamn")
    public suspend fun workerAccessConfiguration(`value`: WorkteamWorkerAccessConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerAccessConfiguration = mapped
    }

    /**
     * @param argument Use this optional parameter to constrain access to an Amazon S3 resource based on the IP address using supported IAM global condition keys. The Amazon S3 resource is accessed in the worker portal using a Amazon S3 presigned URL. see Worker Access Configuration details below.
     */
    @JvmName("thqcyotlhkyuqmnx")
    public suspend fun workerAccessConfiguration(argument: suspend WorkteamWorkerAccessConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = WorkteamWorkerAccessConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.workerAccessConfiguration = mapped
    }

    /**
     * @param value The name of the Workteam (must be unique).
     */
    @JvmName("wuhmfvypyaanpxsi")
    public suspend fun workforceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workforceName = mapped
    }

    /**
     * @param value The name of the workforce.
     */
    @JvmName("grvmywmgwmdhggtk")
    public suspend fun workteamName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workteamName = mapped
    }

    internal fun build(): WorkteamArgs = WorkteamArgs(
        description = description,
        memberDefinitions = memberDefinitions,
        notificationConfiguration = notificationConfiguration,
        tags = tags,
        workerAccessConfiguration = workerAccessConfiguration,
        workforceName = workforceName,
        workteamName = workteamName,
    )
}
