@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.AppImageConfigCodeEditorAppImageConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property containerConfig The configuration used to run the application image container. See Container Config details below.
 * @property fileSystemConfig The URL where the Git repository is located. See File System Config details below.
 */
public data class AppImageConfigCodeEditorAppImageConfigArgs(
    public val containerConfig: Output<AppImageConfigCodeEditorAppImageConfigContainerConfigArgs>? =
        null,
    public val fileSystemConfig: Output<AppImageConfigCodeEditorAppImageConfigFileSystemConfigArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.AppImageConfigCodeEditorAppImageConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.AppImageConfigCodeEditorAppImageConfigArgs = com.pulumi.aws.sagemaker.inputs.AppImageConfigCodeEditorAppImageConfigArgs.builder()
        .containerConfig(containerConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .fileSystemConfig(
            fileSystemConfig?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        ).build()
}

/**
 * Builder for [AppImageConfigCodeEditorAppImageConfigArgs].
 */
@PulumiTagMarker
public class AppImageConfigCodeEditorAppImageConfigArgsBuilder internal constructor() {
    private var containerConfig: Output<AppImageConfigCodeEditorAppImageConfigContainerConfigArgs>? =
        null

    private var fileSystemConfig: Output<AppImageConfigCodeEditorAppImageConfigFileSystemConfigArgs>? =
        null

    /**
     * @param value The configuration used to run the application image container. See Container Config details below.
     */
    @JvmName("ipeleagxxoxgsnlf")
    public suspend fun containerConfig(`value`: Output<AppImageConfigCodeEditorAppImageConfigContainerConfigArgs>) {
        this.containerConfig = value
    }

    /**
     * @param value The URL where the Git repository is located. See File System Config details below.
     */
    @JvmName("eawymmjiqsmnqrfj")
    public suspend fun fileSystemConfig(`value`: Output<AppImageConfigCodeEditorAppImageConfigFileSystemConfigArgs>) {
        this.fileSystemConfig = value
    }

    /**
     * @param value The configuration used to run the application image container. See Container Config details below.
     */
    @JvmName("klwgwnldpeabqoex")
    public suspend fun containerConfig(`value`: AppImageConfigCodeEditorAppImageConfigContainerConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerConfig = mapped
    }

    /**
     * @param argument The configuration used to run the application image container. See Container Config details below.
     */
    @JvmName("nosnnikpmeceufaf")
    public suspend fun containerConfig(argument: suspend AppImageConfigCodeEditorAppImageConfigContainerConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            AppImageConfigCodeEditorAppImageConfigContainerConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.containerConfig = mapped
    }

    /**
     * @param value The URL where the Git repository is located. See File System Config details below.
     */
    @JvmName("lscvycxwgwxsvpih")
    public suspend fun fileSystemConfig(`value`: AppImageConfigCodeEditorAppImageConfigFileSystemConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemConfig = mapped
    }

    /**
     * @param argument The URL where the Git repository is located. See File System Config details below.
     */
    @JvmName("byptjonmotcrktih")
    public suspend fun fileSystemConfig(argument: suspend AppImageConfigCodeEditorAppImageConfigFileSystemConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            AppImageConfigCodeEditorAppImageConfigFileSystemConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.fileSystemConfig = mapped
    }

    internal fun build(): AppImageConfigCodeEditorAppImageConfigArgs =
        AppImageConfigCodeEditorAppImageConfigArgs(
            containerConfig = containerConfig,
            fileSystemConfig = fileSystemConfig,
        )
}
