@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.AppImageConfigCodeEditorAppImageConfigContainerConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property containerArguments The arguments for the container when you're running the application.
 * @property containerEntrypoints The entrypoint used to run the application in the container.
 * @property containerEnvironmentVariables The environment variables to set in the container.
 */
public data class AppImageConfigCodeEditorAppImageConfigContainerConfigArgs(
    public val containerArguments: Output<List<String>>? = null,
    public val containerEntrypoints: Output<List<String>>? = null,
    public val containerEnvironmentVariables: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.AppImageConfigCodeEditorAppImageConfigContainerConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.AppImageConfigCodeEditorAppImageConfigContainerConfigArgs =
        com.pulumi.aws.sagemaker.inputs.AppImageConfigCodeEditorAppImageConfigContainerConfigArgs.builder()
            .containerArguments(containerArguments?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .containerEntrypoints(containerEntrypoints?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .containerEnvironmentVariables(
                containerEnvironmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AppImageConfigCodeEditorAppImageConfigContainerConfigArgs].
 */
@PulumiTagMarker
public class AppImageConfigCodeEditorAppImageConfigContainerConfigArgsBuilder internal constructor() {
    private var containerArguments: Output<List<String>>? = null

    private var containerEntrypoints: Output<List<String>>? = null

    private var containerEnvironmentVariables: Output<Map<String, String>>? = null

    /**
     * @param value The arguments for the container when you're running the application.
     */
    @JvmName("bwaobgvewqygxxeb")
    public suspend fun containerArguments(`value`: Output<List<String>>) {
        this.containerArguments = value
    }

    @JvmName("jcnckebpoyxqprxv")
    public suspend fun containerArguments(vararg values: Output<String>) {
        this.containerArguments = Output.all(values.asList())
    }

    /**
     * @param values The arguments for the container when you're running the application.
     */
    @JvmName("obukgvgpffhlkqux")
    public suspend fun containerArguments(values: List<Output<String>>) {
        this.containerArguments = Output.all(values)
    }

    /**
     * @param value The entrypoint used to run the application in the container.
     */
    @JvmName("apgshektkspnyaym")
    public suspend fun containerEntrypoints(`value`: Output<List<String>>) {
        this.containerEntrypoints = value
    }

    @JvmName("iculpsdlcpwxkdtf")
    public suspend fun containerEntrypoints(vararg values: Output<String>) {
        this.containerEntrypoints = Output.all(values.asList())
    }

    /**
     * @param values The entrypoint used to run the application in the container.
     */
    @JvmName("twatxmcjroymgbuw")
    public suspend fun containerEntrypoints(values: List<Output<String>>) {
        this.containerEntrypoints = Output.all(values)
    }

    /**
     * @param value The environment variables to set in the container.
     */
    @JvmName("nmlveawxaijwoxik")
    public suspend fun containerEnvironmentVariables(`value`: Output<Map<String, String>>) {
        this.containerEnvironmentVariables = value
    }

    /**
     * @param value The arguments for the container when you're running the application.
     */
    @JvmName("ssluchxevyxcqphw")
    public suspend fun containerArguments(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerArguments = mapped
    }

    /**
     * @param values The arguments for the container when you're running the application.
     */
    @JvmName("ornakwrxbgnmhxfb")
    public suspend fun containerArguments(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerArguments = mapped
    }

    /**
     * @param value The entrypoint used to run the application in the container.
     */
    @JvmName("rmfivhxnvnxcpdor")
    public suspend fun containerEntrypoints(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerEntrypoints = mapped
    }

    /**
     * @param values The entrypoint used to run the application in the container.
     */
    @JvmName("lfhuqtdusrutvspf")
    public suspend fun containerEntrypoints(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerEntrypoints = mapped
    }

    /**
     * @param value The environment variables to set in the container.
     */
    @JvmName("otpsaisqwwydrgmg")
    public suspend fun containerEnvironmentVariables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerEnvironmentVariables = mapped
    }

    /**
     * @param values The environment variables to set in the container.
     */
    @JvmName("duufrfqhmatuxxvf")
    public fun containerEnvironmentVariables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerEnvironmentVariables = mapped
    }

    internal fun build(): AppImageConfigCodeEditorAppImageConfigContainerConfigArgs =
        AppImageConfigCodeEditorAppImageConfigContainerConfigArgs(
            containerArguments = containerArguments,
            containerEntrypoints = containerEntrypoints,
            containerEnvironmentVariables = containerEnvironmentVariables,
        )
}
