@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.AppImageConfigJupyterLabImageConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property containerConfig The configuration used to run the application image container. See Container Config details below.
 * @property fileSystemConfig The URL where the Git repository is located. See File System Config details below.
 */
public data class AppImageConfigJupyterLabImageConfigArgs(
    public val containerConfig: Output<AppImageConfigJupyterLabImageConfigContainerConfigArgs>? =
        null,
    public val fileSystemConfig: Output<AppImageConfigJupyterLabImageConfigFileSystemConfigArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.AppImageConfigJupyterLabImageConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.AppImageConfigJupyterLabImageConfigArgs =
        com.pulumi.aws.sagemaker.inputs.AppImageConfigJupyterLabImageConfigArgs.builder()
            .containerConfig(containerConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fileSystemConfig(
                fileSystemConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AppImageConfigJupyterLabImageConfigArgs].
 */
@PulumiTagMarker
public class AppImageConfigJupyterLabImageConfigArgsBuilder internal constructor() {
    private var containerConfig: Output<AppImageConfigJupyterLabImageConfigContainerConfigArgs>? =
        null

    private var fileSystemConfig: Output<AppImageConfigJupyterLabImageConfigFileSystemConfigArgs>? =
        null

    /**
     * @param value The configuration used to run the application image container. See Container Config details below.
     */
    @JvmName("aeqgrritqpldmjcy")
    public suspend fun containerConfig(`value`: Output<AppImageConfigJupyterLabImageConfigContainerConfigArgs>) {
        this.containerConfig = value
    }

    /**
     * @param value The URL where the Git repository is located. See File System Config details below.
     */
    @JvmName("aqkwfvfodicbumoh")
    public suspend fun fileSystemConfig(`value`: Output<AppImageConfigJupyterLabImageConfigFileSystemConfigArgs>) {
        this.fileSystemConfig = value
    }

    /**
     * @param value The configuration used to run the application image container. See Container Config details below.
     */
    @JvmName("ycbufgjyxmhfxfxy")
    public suspend fun containerConfig(`value`: AppImageConfigJupyterLabImageConfigContainerConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerConfig = mapped
    }

    /**
     * @param argument The configuration used to run the application image container. See Container Config details below.
     */
    @JvmName("wihhcevuxukwdiic")
    public suspend fun containerConfig(argument: suspend AppImageConfigJupyterLabImageConfigContainerConfigArgsBuilder.() -> Unit) {
        val toBeMapped = AppImageConfigJupyterLabImageConfigContainerConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.containerConfig = mapped
    }

    /**
     * @param value The URL where the Git repository is located. See File System Config details below.
     */
    @JvmName("cccmntrhaglckdoo")
    public suspend fun fileSystemConfig(`value`: AppImageConfigJupyterLabImageConfigFileSystemConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemConfig = mapped
    }

    /**
     * @param argument The URL where the Git repository is located. See File System Config details below.
     */
    @JvmName("alabaimaaurdwtal")
    public suspend fun fileSystemConfig(argument: suspend AppImageConfigJupyterLabImageConfigFileSystemConfigArgsBuilder.() -> Unit) {
        val toBeMapped = AppImageConfigJupyterLabImageConfigFileSystemConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fileSystemConfig = mapped
    }

    internal fun build(): AppImageConfigJupyterLabImageConfigArgs =
        AppImageConfigJupyterLabImageConfigArgs(
            containerConfig = containerConfig,
            fileSystemConfig = fileSystemConfig,
        )
}
