@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.AppImageConfigJupyterLabImageConfigFileSystemConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property defaultGid The default POSIX group ID (GID). If not specified, defaults to `100`. Valid values are `0` and `100`.
 * @property defaultUid The default POSIX user ID (UID). If not specified, defaults to `1000`. Valid values are `0` and `1000`.
 * @property mountPath The path within the image to mount the user's EFS home directory. The directory should be empty. If not specified, defaults to `/home/sagemaker-user`.
 * > **Note:** When specifying `default_gid` and `default_uid`, Valid value pairs are [`0`, `0`] and [`100`, `1000`].
 */
public data class AppImageConfigJupyterLabImageConfigFileSystemConfigArgs(
    public val defaultGid: Output<Int>? = null,
    public val defaultUid: Output<Int>? = null,
    public val mountPath: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.AppImageConfigJupyterLabImageConfigFileSystemConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.AppImageConfigJupyterLabImageConfigFileSystemConfigArgs =
        com.pulumi.aws.sagemaker.inputs.AppImageConfigJupyterLabImageConfigFileSystemConfigArgs.builder()
            .defaultGid(defaultGid?.applyValue({ args0 -> args0 }))
            .defaultUid(defaultUid?.applyValue({ args0 -> args0 }))
            .mountPath(mountPath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppImageConfigJupyterLabImageConfigFileSystemConfigArgs].
 */
@PulumiTagMarker
public class AppImageConfigJupyterLabImageConfigFileSystemConfigArgsBuilder internal constructor() {
    private var defaultGid: Output<Int>? = null

    private var defaultUid: Output<Int>? = null

    private var mountPath: Output<String>? = null

    /**
     * @param value The default POSIX group ID (GID). If not specified, defaults to `100`. Valid values are `0` and `100`.
     */
    @JvmName("wjkcrlmhwlbhapjr")
    public suspend fun defaultGid(`value`: Output<Int>) {
        this.defaultGid = value
    }

    /**
     * @param value The default POSIX user ID (UID). If not specified, defaults to `1000`. Valid values are `0` and `1000`.
     */
    @JvmName("kuwjwemjqyouoevd")
    public suspend fun defaultUid(`value`: Output<Int>) {
        this.defaultUid = value
    }

    /**
     * @param value The path within the image to mount the user's EFS home directory. The directory should be empty. If not specified, defaults to `/home/sagemaker-user`.
     * > **Note:** When specifying `default_gid` and `default_uid`, Valid value pairs are [`0`, `0`] and [`100`, `1000`].
     */
    @JvmName("gvuuxhfvoljvabcn")
    public suspend fun mountPath(`value`: Output<String>) {
        this.mountPath = value
    }

    /**
     * @param value The default POSIX group ID (GID). If not specified, defaults to `100`. Valid values are `0` and `100`.
     */
    @JvmName("ntslombhuyuwkotb")
    public suspend fun defaultGid(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultGid = mapped
    }

    /**
     * @param value The default POSIX user ID (UID). If not specified, defaults to `1000`. Valid values are `0` and `1000`.
     */
    @JvmName("wwyyepmtnutkreeh")
    public suspend fun defaultUid(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultUid = mapped
    }

    /**
     * @param value The path within the image to mount the user's EFS home directory. The directory should be empty. If not specified, defaults to `/home/sagemaker-user`.
     * > **Note:** When specifying `default_gid` and `default_uid`, Valid value pairs are [`0`, `0`] and [`100`, `1000`].
     */
    @JvmName("vqjdyoidmbolnaoc")
    public suspend fun mountPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountPath = mapped
    }

    internal fun build(): AppImageConfigJupyterLabImageConfigFileSystemConfigArgs =
        AppImageConfigJupyterLabImageConfigFileSystemConfigArgs(
            defaultGid = defaultGid,
            defaultUid = defaultUid,
            mountPath = mountPath,
        )
}
