@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.CodeRepositoryGitConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property branch The default branch for the Git repository.
 * @property repositoryUrl The URL where the Git repository is located.
 * @property secretArn The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to access the git repository. The secret must have a staging label of AWSCURRENT and must be in the following format: `{"username": UserName, "password": Password}`
 */
public data class CodeRepositoryGitConfigArgs(
    public val branch: Output<String>? = null,
    public val repositoryUrl: Output<String>,
    public val secretArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.CodeRepositoryGitConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.CodeRepositoryGitConfigArgs =
        com.pulumi.aws.sagemaker.inputs.CodeRepositoryGitConfigArgs.builder()
            .branch(branch?.applyValue({ args0 -> args0 }))
            .repositoryUrl(repositoryUrl.applyValue({ args0 -> args0 }))
            .secretArn(secretArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CodeRepositoryGitConfigArgs].
 */
@PulumiTagMarker
public class CodeRepositoryGitConfigArgsBuilder internal constructor() {
    private var branch: Output<String>? = null

    private var repositoryUrl: Output<String>? = null

    private var secretArn: Output<String>? = null

    /**
     * @param value The default branch for the Git repository.
     */
    @JvmName("uhjcmjreiihkqdij")
    public suspend fun branch(`value`: Output<String>) {
        this.branch = value
    }

    /**
     * @param value The URL where the Git repository is located.
     */
    @JvmName("nwjrdqsawpsgtlcy")
    public suspend fun repositoryUrl(`value`: Output<String>) {
        this.repositoryUrl = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to access the git repository. The secret must have a staging label of AWSCURRENT and must be in the following format: `{"username": UserName, "password": Password}`
     */
    @JvmName("radhkqstyxdiyodj")
    public suspend fun secretArn(`value`: Output<String>) {
        this.secretArn = value
    }

    /**
     * @param value The default branch for the Git repository.
     */
    @JvmName("gutkfwgvogwlfhob")
    public suspend fun branch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branch = mapped
    }

    /**
     * @param value The URL where the Git repository is located.
     */
    @JvmName("bvmfxlidfntcwwcj")
    public suspend fun repositoryUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repositoryUrl = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the AWS Secrets Manager secret that contains the credentials used to access the git repository. The secret must have a staging label of AWSCURRENT and must be in the following format: `{"username": UserName, "password": Password}`
     */
    @JvmName("ylrpqixhqvvkdesw")
    public suspend fun secretArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretArn = mapped
    }

    internal fun build(): CodeRepositoryGitConfigArgs = CodeRepositoryGitConfigArgs(
        branch = branch,
        repositoryUrl = repositoryUrl ?: throw PulumiNullFieldException("repositoryUrl"),
        secretArn = secretArn,
    )
}
