@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityAppSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property environment Sets the environment variables in the container that the monitoring job runs. A list of key value pairs.
 * @property imageUri The container image that the data quality monitoring job runs.
 * @property postAnalyticsProcessorSourceUri An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.
 * @property recordPreprocessorSourceUri An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.
 */
public data class DataQualityJobDefinitionDataQualityAppSpecificationArgs(
    public val environment: Output<Map<String, String>>? = null,
    public val imageUri: Output<String>,
    public val postAnalyticsProcessorSourceUri: Output<String>? = null,
    public val recordPreprocessorSourceUri: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityAppSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityAppSpecificationArgs =
        com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityAppSpecificationArgs.builder()
            .environment(
                environment?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .imageUri(imageUri.applyValue({ args0 -> args0 }))
            .postAnalyticsProcessorSourceUri(postAnalyticsProcessorSourceUri?.applyValue({ args0 -> args0 }))
            .recordPreprocessorSourceUri(recordPreprocessorSourceUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataQualityJobDefinitionDataQualityAppSpecificationArgs].
 */
@PulumiTagMarker
public class DataQualityJobDefinitionDataQualityAppSpecificationArgsBuilder internal constructor() {
    private var environment: Output<Map<String, String>>? = null

    private var imageUri: Output<String>? = null

    private var postAnalyticsProcessorSourceUri: Output<String>? = null

    private var recordPreprocessorSourceUri: Output<String>? = null

    /**
     * @param value Sets the environment variables in the container that the monitoring job runs. A list of key value pairs.
     */
    @JvmName("xisippjmuagllrnm")
    public suspend fun environment(`value`: Output<Map<String, String>>) {
        this.environment = value
    }

    /**
     * @param value The container image that the data quality monitoring job runs.
     */
    @JvmName("bpuaawwhgnknbacv")
    public suspend fun imageUri(`value`: Output<String>) {
        this.imageUri = value
    }

    /**
     * @param value An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.
     */
    @JvmName("dmcnngbkjfunyysm")
    public suspend fun postAnalyticsProcessorSourceUri(`value`: Output<String>) {
        this.postAnalyticsProcessorSourceUri = value
    }

    /**
     * @param value An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.
     */
    @JvmName("kqrwtuwwxaxldnnh")
    public suspend fun recordPreprocessorSourceUri(`value`: Output<String>) {
        this.recordPreprocessorSourceUri = value
    }

    /**
     * @param value Sets the environment variables in the container that the monitoring job runs. A list of key value pairs.
     */
    @JvmName("qonogdxkamkfodru")
    public suspend fun environment(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environment = mapped
    }

    /**
     * @param values Sets the environment variables in the container that the monitoring job runs. A list of key value pairs.
     */
    @JvmName("ypwqomoeimoevnyd")
    public fun environment(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environment = mapped
    }

    /**
     * @param value The container image that the data quality monitoring job runs.
     */
    @JvmName("pgprocewdjepvqrr")
    public suspend fun imageUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageUri = mapped
    }

    /**
     * @param value An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.
     */
    @JvmName("lxrjlsotgccarvax")
    public suspend fun postAnalyticsProcessorSourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postAnalyticsProcessorSourceUri = mapped
    }

    /**
     * @param value An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.
     */
    @JvmName("rtehgnbknrddmwqq")
    public suspend fun recordPreprocessorSourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordPreprocessorSourceUri = mapped
    }

    internal fun build(): DataQualityJobDefinitionDataQualityAppSpecificationArgs =
        DataQualityJobDefinitionDataQualityAppSpecificationArgs(
            environment = environment,
            imageUri = imageUri ?: throw PulumiNullFieldException("imageUri"),
            postAnalyticsProcessorSourceUri = postAnalyticsProcessorSourceUri,
            recordPreprocessorSourceUri = recordPreprocessorSourceUri,
        )
}
