@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityBaselineConfigConstraintsResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property s3Uri The Amazon S3 URI for the constraints resource.
 */
public data class DataQualityJobDefinitionDataQualityBaselineConfigConstraintsResourceArgs(
    public val s3Uri: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityBaselineConfigConstraintsResourceArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityBaselineConfigConstraintsResourceArgs =
        com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityBaselineConfigConstraintsResourceArgs.builder()
            .s3Uri(s3Uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataQualityJobDefinitionDataQualityBaselineConfigConstraintsResourceArgs].
 */
@PulumiTagMarker
public class DataQualityJobDefinitionDataQualityBaselineConfigConstraintsResourceArgsBuilder
internal constructor() {
    private var s3Uri: Output<String>? = null

    /**
     * @param value The Amazon S3 URI for the constraints resource.
     */
    @JvmName("prcdpcwbbuykcael")
    public suspend fun s3Uri(`value`: Output<String>) {
        this.s3Uri = value
    }

    /**
     * @param value The Amazon S3 URI for the constraints resource.
     */
    @JvmName("bamxahdcoyfqoowc")
    public suspend fun s3Uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Uri = mapped
    }

    internal fun build(): DataQualityJobDefinitionDataQualityBaselineConfigConstraintsResourceArgs =
        DataQualityJobDefinitionDataQualityBaselineConfigConstraintsResourceArgs(
            s3Uri = s3Uri,
        )
}
