@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobInputBatchTransformInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property dataCapturedDestinationS3Uri The Amazon S3 location being used to capture the data.
 * @property datasetFormat The dataset format for your batch transform job. Fields are documented below.
 * @property localPath Path to the filesystem where the batch transform data is available to the container. Defaults to `/opt/ml/processing/input`.
 * @property s3DataDistributionType Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to `FullyReplicated`. Valid values are `FullyReplicated` or `ShardedByS3Key`
 * @property s3InputMode Whether the `Pipe` or `File` is used as the input mode for transferring data for the monitoring job. `Pipe` mode is recommended for large datasets. `File` mode is useful for small files that fit in memory. Defaults to `File`.  Valid values are `Pipe` or `File`
 */
public data class DataQualityJobDefinitionDataQualityJobInputBatchTransformInputArgs(
    public val dataCapturedDestinationS3Uri: Output<String>,
    public val datasetFormat: Output<DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatArgs>,
    public val localPath: Output<String>? = null,
    public val s3DataDistributionType: Output<String>? = null,
    public val s3InputMode: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobInputBatchTransformInputArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobInputBatchTransformInputArgs =
        com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobInputBatchTransformInputArgs.builder()
            .dataCapturedDestinationS3Uri(dataCapturedDestinationS3Uri.applyValue({ args0 -> args0 }))
            .datasetFormat(datasetFormat.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .localPath(localPath?.applyValue({ args0 -> args0 }))
            .s3DataDistributionType(s3DataDistributionType?.applyValue({ args0 -> args0 }))
            .s3InputMode(s3InputMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataQualityJobDefinitionDataQualityJobInputBatchTransformInputArgs].
 */
@PulumiTagMarker
public class DataQualityJobDefinitionDataQualityJobInputBatchTransformInputArgsBuilder internal constructor() {
    private var dataCapturedDestinationS3Uri: Output<String>? = null

    private var datasetFormat:
        Output<DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatArgs>? =
        null

    private var localPath: Output<String>? = null

    private var s3DataDistributionType: Output<String>? = null

    private var s3InputMode: Output<String>? = null

    /**
     * @param value The Amazon S3 location being used to capture the data.
     */
    @JvmName("ghpgldovutvhpbmb")
    public suspend fun dataCapturedDestinationS3Uri(`value`: Output<String>) {
        this.dataCapturedDestinationS3Uri = value
    }

    /**
     * @param value The dataset format for your batch transform job. Fields are documented below.
     */
    @JvmName("nwndbnippatsrojl")
    public suspend fun datasetFormat(`value`: Output<DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatArgs>) {
        this.datasetFormat = value
    }

    /**
     * @param value Path to the filesystem where the batch transform data is available to the container. Defaults to `/opt/ml/processing/input`.
     */
    @JvmName("cnqrcspfdrxpvlsq")
    public suspend fun localPath(`value`: Output<String>) {
        this.localPath = value
    }

    /**
     * @param value Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to `FullyReplicated`. Valid values are `FullyReplicated` or `ShardedByS3Key`
     */
    @JvmName("fxmtrtbtepyclpfp")
    public suspend fun s3DataDistributionType(`value`: Output<String>) {
        this.s3DataDistributionType = value
    }

    /**
     * @param value Whether the `Pipe` or `File` is used as the input mode for transferring data for the monitoring job. `Pipe` mode is recommended for large datasets. `File` mode is useful for small files that fit in memory. Defaults to `File`.  Valid values are `Pipe` or `File`
     */
    @JvmName("cykfrcfvofmcrvrp")
    public suspend fun s3InputMode(`value`: Output<String>) {
        this.s3InputMode = value
    }

    /**
     * @param value The Amazon S3 location being used to capture the data.
     */
    @JvmName("woidgcqmdsvouuoa")
    public suspend fun dataCapturedDestinationS3Uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataCapturedDestinationS3Uri = mapped
    }

    /**
     * @param value The dataset format for your batch transform job. Fields are documented below.
     */
    @JvmName("avpjpqhmqinyfjsj")
    public suspend fun datasetFormat(`value`: DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.datasetFormat = mapped
    }

    /**
     * @param argument The dataset format for your batch transform job. Fields are documented below.
     */
    @JvmName("brkmuwlubsoflldv")
    public suspend fun datasetFormat(argument: suspend DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.datasetFormat = mapped
    }

    /**
     * @param value Path to the filesystem where the batch transform data is available to the container. Defaults to `/opt/ml/processing/input`.
     */
    @JvmName("mtquvanchlylnsrj")
    public suspend fun localPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localPath = mapped
    }

    /**
     * @param value Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to `FullyReplicated`. Valid values are `FullyReplicated` or `ShardedByS3Key`
     */
    @JvmName("iofnqeuqawbjonxv")
    public suspend fun s3DataDistributionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3DataDistributionType = mapped
    }

    /**
     * @param value Whether the `Pipe` or `File` is used as the input mode for transferring data for the monitoring job. `Pipe` mode is recommended for large datasets. `File` mode is useful for small files that fit in memory. Defaults to `File`.  Valid values are `Pipe` or `File`
     */
    @JvmName("qlqihijqcrmbhujq")
    public suspend fun s3InputMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3InputMode = mapped
    }

    internal fun build(): DataQualityJobDefinitionDataQualityJobInputBatchTransformInputArgs =
        DataQualityJobDefinitionDataQualityJobInputBatchTransformInputArgs(
            dataCapturedDestinationS3Uri = dataCapturedDestinationS3Uri ?: throw
                PulumiNullFieldException("dataCapturedDestinationS3Uri"),
            datasetFormat = datasetFormat ?: throw PulumiNullFieldException("datasetFormat"),
            localPath = localPath,
            s3DataDistributionType = s3DataDistributionType,
            s3InputMode = s3InputMode,
        )
}
