@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property csv The CSV dataset used in the monitoring job. Fields are documented below.
 * @property json The JSON dataset used in the monitoring job. Fields are documented below.
 */
public data class DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatArgs(
    public val csv: Output<DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatCsvArgs>? =
        null,
    public val json: Output<DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatJsonArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatArgs =
        com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatArgs.builder()
            .csv(csv?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .json(json?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatArgs].
 */
@PulumiTagMarker
public class DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatArgsBuilder
internal constructor() {
    private var csv:
        Output<DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatCsvArgs>? =
        null

    private var json:
        Output<DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatJsonArgs>? =
        null

    /**
     * @param value The CSV dataset used in the monitoring job. Fields are documented below.
     */
    @JvmName("vfjkiyeefmlyljgi")
    public suspend fun csv(`value`: Output<DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatCsvArgs>) {
        this.csv = value
    }

    /**
     * @param value The JSON dataset used in the monitoring job. Fields are documented below.
     */
    @JvmName("nvmhvphjsrghkjyy")
    public suspend fun json(`value`: Output<DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatJsonArgs>) {
        this.json = value
    }

    /**
     * @param value The CSV dataset used in the monitoring job. Fields are documented below.
     */
    @JvmName("mhckbllhbosiyihu")
    public suspend fun csv(`value`: DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatCsvArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csv = mapped
    }

    /**
     * @param argument The CSV dataset used in the monitoring job. Fields are documented below.
     */
    @JvmName("ahblxypntiyoffqd")
    public suspend fun csv(argument: suspend DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatCsvArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatCsvArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.csv = mapped
    }

    /**
     * @param value The JSON dataset used in the monitoring job. Fields are documented below.
     */
    @JvmName("itiftlevuleudxxo")
    public suspend fun json(`value`: DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatJsonArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.json = mapped
    }

    /**
     * @param argument The JSON dataset used in the monitoring job. Fields are documented below.
     */
    @JvmName("dyjudhuwknyibgjk")
    public suspend fun json(argument: suspend DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatJsonArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatJsonArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.json = mapped
    }

    internal fun build(): DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatArgs =
        DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormatArgs(
            csv = csv,
            json = json,
        )
}
