@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobOutputConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property kmsKeyId The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
 * @property monitoringOutputs Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded. Fields are documented below.
 */
public data class DataQualityJobDefinitionDataQualityJobOutputConfigArgs(
    public val kmsKeyId: Output<String>? = null,
    public val monitoringOutputs: Output<DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobOutputConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobOutputConfigArgs =
        com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobOutputConfigArgs.builder()
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .monitoringOutputs(
                monitoringOutputs.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataQualityJobDefinitionDataQualityJobOutputConfigArgs].
 */
@PulumiTagMarker
public class DataQualityJobDefinitionDataQualityJobOutputConfigArgsBuilder internal constructor() {
    private var kmsKeyId: Output<String>? = null

    private var monitoringOutputs:
        Output<DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsArgs>? = null

    /**
     * @param value The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
     */
    @JvmName("umxgmlnpyrohcfft")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded. Fields are documented below.
     */
    @JvmName("geommxaffaswxtqh")
    public suspend fun monitoringOutputs(`value`: Output<DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsArgs>) {
        this.monitoringOutputs = value
    }

    /**
     * @param value The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
     */
    @JvmName("pxoblbsrnhhhhqxf")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded. Fields are documented below.
     */
    @JvmName("rjyhxnwswvhbvcjk")
    public suspend fun monitoringOutputs(`value`: DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monitoringOutputs = mapped
    }

    /**
     * @param argument Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded. Fields are documented below.
     */
    @JvmName("rdyrlwydlipnfaid")
    public suspend fun monitoringOutputs(argument: suspend DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.monitoringOutputs = mapped
    }

    internal fun build(): DataQualityJobDefinitionDataQualityJobOutputConfigArgs =
        DataQualityJobDefinitionDataQualityJobOutputConfigArgs(
            kmsKeyId = kmsKeyId,
            monitoringOutputs = monitoringOutputs ?: throw PulumiNullFieldException("monitoringOutputs"),
        )
}
