@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3OutputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property localPath The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data. Defaults to `/opt/ml/processing/output`.
 * @property s3UploadMode Whether to upload the results of the monitoring job continuously or after the job completes. Valid values are `Continuous` or `EndOfJob`
 * @property s3Uri A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
 */
public data class DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3OutputArgs(
    public val localPath: Output<String>? = null,
    public val s3UploadMode: Output<String>? = null,
    public val s3Uri: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3OutputArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3OutputArgs =
        com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3OutputArgs.builder()
            .localPath(localPath?.applyValue({ args0 -> args0 }))
            .s3UploadMode(s3UploadMode?.applyValue({ args0 -> args0 }))
            .s3Uri(s3Uri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3OutputArgs].
 */
@PulumiTagMarker
public class DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3OutputArgsBuilder
internal constructor() {
    private var localPath: Output<String>? = null

    private var s3UploadMode: Output<String>? = null

    private var s3Uri: Output<String>? = null

    /**
     * @param value The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data. Defaults to `/opt/ml/processing/output`.
     */
    @JvmName("nbfpjmldlbubkijg")
    public suspend fun localPath(`value`: Output<String>) {
        this.localPath = value
    }

    /**
     * @param value Whether to upload the results of the monitoring job continuously or after the job completes. Valid values are `Continuous` or `EndOfJob`
     */
    @JvmName("ilruvjjvbdbjhqrt")
    public suspend fun s3UploadMode(`value`: Output<String>) {
        this.s3UploadMode = value
    }

    /**
     * @param value A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
     */
    @JvmName("jypvyqcktcmdhijv")
    public suspend fun s3Uri(`value`: Output<String>) {
        this.s3Uri = value
    }

    /**
     * @param value The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data. Defaults to `/opt/ml/processing/output`.
     */
    @JvmName("nspmyagigegkbgmc")
    public suspend fun localPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localPath = mapped
    }

    /**
     * @param value Whether to upload the results of the monitoring job continuously or after the job completes. Valid values are `Continuous` or `EndOfJob`
     */
    @JvmName("pqwmibkyrykhmjfu")
    public suspend fun s3UploadMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3UploadMode = mapped
    }

    /**
     * @param value A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
     */
    @JvmName("eiqlpceeirbqmnqh")
    public suspend fun s3Uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Uri = mapped
    }

    internal fun build(): DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3OutputArgs =
        DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3OutputArgs(
            localPath = localPath,
            s3UploadMode = s3UploadMode,
            s3Uri = s3Uri ?: throw PulumiNullFieldException("s3Uri"),
        )
}
