@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionNetworkConfigVpcConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupIds The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the `subnets` field.
 * @property subnets The ID of the subnets in the VPC to which you want to connect your training job or model.
 */
public data class DataQualityJobDefinitionNetworkConfigVpcConfigArgs(
    public val securityGroupIds: Output<List<String>>,
    public val subnets: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionNetworkConfigVpcConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionNetworkConfigVpcConfigArgs =
        com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionNetworkConfigVpcConfigArgs.builder()
            .securityGroupIds(securityGroupIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnets(subnets.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DataQualityJobDefinitionNetworkConfigVpcConfigArgs].
 */
@PulumiTagMarker
public class DataQualityJobDefinitionNetworkConfigVpcConfigArgsBuilder internal constructor() {
    private var securityGroupIds: Output<List<String>>? = null

    private var subnets: Output<List<String>>? = null

    /**
     * @param value The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the `subnets` field.
     */
    @JvmName("igxtuhcpykrjmmqm")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("sbfagmxucbfkhswa")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the `subnets` field.
     */
    @JvmName("bbikyvyoddncxtbr")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The ID of the subnets in the VPC to which you want to connect your training job or model.
     */
    @JvmName("bduidqaoyikbfuts")
    public suspend fun subnets(`value`: Output<List<String>>) {
        this.subnets = value
    }

    @JvmName("ayryytodhnqfriiu")
    public suspend fun subnets(vararg values: Output<String>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values The ID of the subnets in the VPC to which you want to connect your training job or model.
     */
    @JvmName("wxradtybkrcijeme")
    public suspend fun subnets(values: List<Output<String>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the `subnets` field.
     */
    @JvmName("bjujsldqjejdqdkk")
    public suspend fun securityGroupIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the `subnets` field.
     */
    @JvmName("urvpmsjtyjofhedk")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The ID of the subnets in the VPC to which you want to connect your training job or model.
     */
    @JvmName("wxoipitdvvtgjbti")
    public suspend fun subnets(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param values The ID of the subnets in the VPC to which you want to connect your training job or model.
     */
    @JvmName("jgntghcwutwnghvc")
    public suspend fun subnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    internal fun build(): DataQualityJobDefinitionNetworkConfigVpcConfigArgs =
        DataQualityJobDefinitionNetworkConfigVpcConfigArgs(
            securityGroupIds = securityGroupIds ?: throw PulumiNullFieldException("securityGroupIds"),
            subnets = subnets ?: throw PulumiNullFieldException("subnets"),
        )
}
