@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionStoppingConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxRuntimeInSeconds The maximum runtime allowed in seconds.
 */
public data class DataQualityJobDefinitionStoppingConditionArgs(
    public val maxRuntimeInSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionStoppingConditionArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionStoppingConditionArgs =
        com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionStoppingConditionArgs.builder()
            .maxRuntimeInSeconds(maxRuntimeInSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataQualityJobDefinitionStoppingConditionArgs].
 */
@PulumiTagMarker
public class DataQualityJobDefinitionStoppingConditionArgsBuilder internal constructor() {
    private var maxRuntimeInSeconds: Output<Int>? = null

    /**
     * @param value The maximum runtime allowed in seconds.
     */
    @JvmName("kqnhekkaitajbhvj")
    public suspend fun maxRuntimeInSeconds(`value`: Output<Int>) {
        this.maxRuntimeInSeconds = value
    }

    /**
     * @param value The maximum runtime allowed in seconds.
     */
    @JvmName("btxmkogxmbvkduil")
    public suspend fun maxRuntimeInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxRuntimeInSeconds = mapped
    }

    internal fun build(): DataQualityJobDefinitionStoppingConditionArgs =
        DataQualityJobDefinitionStoppingConditionArgs(
            maxRuntimeInSeconds = maxRuntimeInSeconds,
        )
}
