@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultSpaceSettingsJupyterServerAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property codeRepositories A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
 * @property lifecycleConfigArns The Amazon Resource Name (ARN) of the Lifecycle Configurations.
 */
public data class DomainDefaultSpaceSettingsJupyterServerAppSettingsArgs(
    public val codeRepositories: Output<List<DomainDefaultSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgs>>? = null,
    public val defaultResourceSpec: Output<DomainDefaultSpaceSettingsJupyterServerAppSettingsDefaultResourceSpecArgs>? = null,
    public val lifecycleConfigArns: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultSpaceSettingsJupyterServerAppSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DomainDefaultSpaceSettingsJupyterServerAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultSpaceSettingsJupyterServerAppSettingsArgs.builder()
            .codeRepositories(
                codeRepositories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultResourceSpec(
                defaultResourceSpec?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .lifecycleConfigArns(
                lifecycleConfigArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [DomainDefaultSpaceSettingsJupyterServerAppSettingsArgs].
 */
@PulumiTagMarker
public class DomainDefaultSpaceSettingsJupyterServerAppSettingsArgsBuilder internal constructor() {
    private var codeRepositories:
        Output<List<DomainDefaultSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgs>>? = null

    private var defaultResourceSpec:
        Output<DomainDefaultSpaceSettingsJupyterServerAppSettingsDefaultResourceSpecArgs>? = null

    private var lifecycleConfigArns: Output<List<String>>? = null

    /**
     * @param value A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
     */
    @JvmName("pffaamknpeidgsqn")
    public suspend fun codeRepositories(`value`: Output<List<DomainDefaultSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgs>>) {
        this.codeRepositories = value
    }

    @JvmName("tjycmycpjcleivtu")
    public suspend fun codeRepositories(vararg values: Output<DomainDefaultSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgs>) {
        this.codeRepositories = Output.all(values.asList())
    }

    /**
     * @param values A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
     */
    @JvmName("fjapvphfkrpqpici")
    public suspend fun codeRepositories(values: List<Output<DomainDefaultSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgs>>) {
        this.codeRepositories = Output.all(values)
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
     */
    @JvmName("hffpifgkqdmyfjve")
    public suspend fun defaultResourceSpec(`value`: Output<DomainDefaultSpaceSettingsJupyterServerAppSettingsDefaultResourceSpecArgs>) {
        this.defaultResourceSpec = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("umktgsxbxosbofps")
    public suspend fun lifecycleConfigArns(`value`: Output<List<String>>) {
        this.lifecycleConfigArns = value
    }

    @JvmName("nuiwawgtlxtqfope")
    public suspend fun lifecycleConfigArns(vararg values: Output<String>) {
        this.lifecycleConfigArns = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("xgjskshkrwmibmfc")
    public suspend fun lifecycleConfigArns(values: List<Output<String>>) {
        this.lifecycleConfigArns = Output.all(values)
    }

    /**
     * @param value A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
     */
    @JvmName("sbjpqchxbhoxyvgm")
    public suspend fun codeRepositories(`value`: List<DomainDefaultSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeRepositories = mapped
    }

    /**
     * @param argument A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
     */
    @JvmName("xqtlusrfkxbmsqeh")
    public suspend fun codeRepositories(argument: List<suspend DomainDefaultSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainDefaultSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.codeRepositories = mapped
    }

    /**
     * @param argument A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
     */
    @JvmName("beroexwwgdsrfiiy")
    public suspend fun codeRepositories(vararg argument: suspend DomainDefaultSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainDefaultSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.codeRepositories = mapped
    }

    /**
     * @param argument A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
     */
    @JvmName("upmwtmvmsdjhlyyo")
    public suspend fun codeRepositories(argument: suspend DomainDefaultSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DomainDefaultSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.codeRepositories = mapped
    }

    /**
     * @param values A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
     */
    @JvmName("lefboqdswwxbreoe")
    public suspend fun codeRepositories(vararg values: DomainDefaultSpaceSettingsJupyterServerAppSettingsCodeRepositoryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.codeRepositories = mapped
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
     */
    @JvmName("yqivbhrbuftyyffn")
    public suspend fun defaultResourceSpec(`value`: DomainDefaultSpaceSettingsJupyterServerAppSettingsDefaultResourceSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultResourceSpec = mapped
    }

    /**
     * @param argument The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
     */
    @JvmName("vieabtyrncjlosnw")
    public suspend fun defaultResourceSpec(argument: suspend DomainDefaultSpaceSettingsJupyterServerAppSettingsDefaultResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultSpaceSettingsJupyterServerAppSettingsDefaultResourceSpecArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultResourceSpec = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("lxoollwkagvdgsya")
    public suspend fun lifecycleConfigArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("tgdwyoxxlodfmlxo")
    public suspend fun lifecycleConfigArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    internal fun build(): DomainDefaultSpaceSettingsJupyterServerAppSettingsArgs =
        DomainDefaultSpaceSettingsJupyterServerAppSettingsArgs(
            codeRepositories = codeRepositories,
            defaultResourceSpec = defaultResourceSpec,
            lifecycleConfigArns = lifecycleConfigArns,
        )
}
