@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property customImages A list of custom SageMaker images that are configured to run as a KernelGateway app. see `custom_image` Block below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
 * @property lifecycleConfigArns The Amazon Resource Name (ARN) of the Lifecycle Configurations.
 */
public data class DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgs(
    public val customImages: Output<List<DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgs>>? = null,
    public val defaultResourceSpec: Output<DomainDefaultSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs>? = null,
    public val lifecycleConfigArns: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgs.builder()
            .customImages(
                customImages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultResourceSpec(
                defaultResourceSpec?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .lifecycleConfigArns(
                lifecycleConfigArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgs].
 */
@PulumiTagMarker
public class DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgsBuilder internal constructor() {
    private var customImages:
        Output<List<DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgs>>? = null

    private var defaultResourceSpec:
        Output<DomainDefaultSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs>? = null

    private var lifecycleConfigArns: Output<List<String>>? = null

    /**
     * @param value A list of custom SageMaker images that are configured to run as a KernelGateway app. see `custom_image` Block below.
     */
    @JvmName("bpekwffecwgnocli")
    public suspend fun customImages(`value`: Output<List<DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgs>>) {
        this.customImages = value
    }

    @JvmName("misneiybybrqgdsf")
    public suspend fun customImages(vararg values: Output<DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgs>) {
        this.customImages = Output.all(values.asList())
    }

    /**
     * @param values A list of custom SageMaker images that are configured to run as a KernelGateway app. see `custom_image` Block below.
     */
    @JvmName("fttnsebtjwmbscsp")
    public suspend fun customImages(values: List<Output<DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgs>>) {
        this.customImages = Output.all(values)
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
     */
    @JvmName("gfyixlvmnkavlofk")
    public suspend fun defaultResourceSpec(`value`: Output<DomainDefaultSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs>) {
        this.defaultResourceSpec = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("aqvimtysehpbyrrw")
    public suspend fun lifecycleConfigArns(`value`: Output<List<String>>) {
        this.lifecycleConfigArns = value
    }

    @JvmName("aovnqbyonfeprhba")
    public suspend fun lifecycleConfigArns(vararg values: Output<String>) {
        this.lifecycleConfigArns = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("xwvfdaeguxlunwyp")
    public suspend fun lifecycleConfigArns(values: List<Output<String>>) {
        this.lifecycleConfigArns = Output.all(values)
    }

    /**
     * @param value A list of custom SageMaker images that are configured to run as a KernelGateway app. see `custom_image` Block below.
     */
    @JvmName("iyofpsywwduvnoda")
    public suspend fun customImages(`value`: List<DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a KernelGateway app. see `custom_image` Block below.
     */
    @JvmName("bsynteahwqluxnub")
    public suspend fun customImages(argument: List<suspend DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a KernelGateway app. see `custom_image` Block below.
     */
    @JvmName("radirjiftfofivph")
    public suspend fun customImages(vararg argument: suspend DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a KernelGateway app. see `custom_image` Block below.
     */
    @JvmName("mmdnapiomoysnqsy")
    public suspend fun customImages(argument: suspend DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param values A list of custom SageMaker images that are configured to run as a KernelGateway app. see `custom_image` Block below.
     */
    @JvmName("rhxlhbagplurgupq")
    public suspend fun customImages(vararg values: DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
     */
    @JvmName("exokfafjyphgitmy")
    public suspend fun defaultResourceSpec(`value`: DomainDefaultSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultResourceSpec = mapped
    }

    /**
     * @param argument The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
     */
    @JvmName("uayqyxbnnqyvvwri")
    public suspend fun defaultResourceSpec(argument: suspend DomainDefaultSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultResourceSpec = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("itnusvkqispguwbj")
    public suspend fun lifecycleConfigArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("ukurgubkmhcmetbs")
    public suspend fun lifecycleConfigArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    internal fun build(): DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgs =
        DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgs(
            customImages = customImages,
            defaultResourceSpec = defaultResourceSpec,
            lifecycleConfigArns = lifecycleConfigArns,
        )
}
