@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property canvasAppSettings The Canvas app settings. See `canvas_app_settings` Block below.
 * @property codeEditorAppSettings The Code Editor application settings. See `code_editor_app_settings` Block below.
 * @property customFileSystemConfigs The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio. See `custom_file_system_config` Block below.
 * @property customPosixUserConfig Details about the POSIX identity that is used for file system operations. See `custom_posix_user_config` Block below.
 * @property defaultLandingUri The default experience that the user is directed to when accessing the domain. The supported values are: `studio::`: Indicates that Studio is the default experience. This value can only be passed if StudioWebPortal is set to ENABLED. `app:JupyterServer:`: Indicates that Studio Classic is the default experience.
 * @property executionRole The execution role ARN for the user.
 * @property jupyterLabAppSettings The settings for the JupyterLab application. See `jupyter_lab_app_settings` Block below.
 * @property jupyterServerAppSettings The Jupyter server's app settings. See `jupyter_server_app_settings` Block below.
 * @property kernelGatewayAppSettings The kernel gateway app settings. See `kernel_gateway_app_settings` Block below.
 * @property rSessionAppSettings The RSession app settings. See `r_session_app_settings` Block below.
 * @property rStudioServerProAppSettings A collection of settings that configure user interaction with the RStudioServerPro app. See `r_studio_server_pro_app_settings` Block below.
 * @property securityGroups A list of security group IDs that will be attached to the user.
 * @property sharingSettings The sharing settings. See `sharing_settings` Block below.
 * @property spaceStorageSettings The storage settings for a private space. See `space_storage_settings` Block below.
 * @property studioWebPortal Whether the user can access Studio. If this value is set to `DISABLED`, the user cannot access Studio, even if that is the default experience for the domain. Valid values are `ENABLED` and `DISABLED`.
 * @property tensorBoardAppSettings The TensorBoard app settings. See `tensor_board_app_settings` Block below.
 */
public data class DomainDefaultUserSettingsArgs(
    public val canvasAppSettings: Output<DomainDefaultUserSettingsCanvasAppSettingsArgs>? = null,
    public val codeEditorAppSettings: Output<DomainDefaultUserSettingsCodeEditorAppSettingsArgs>? =
        null,
    public val customFileSystemConfigs: Output<List<DomainDefaultUserSettingsCustomFileSystemConfigArgs>>? = null,
    public val customPosixUserConfig: Output<DomainDefaultUserSettingsCustomPosixUserConfigArgs>? =
        null,
    public val defaultLandingUri: Output<String>? = null,
    public val executionRole: Output<String>,
    public val jupyterLabAppSettings: Output<DomainDefaultUserSettingsJupyterLabAppSettingsArgs>? =
        null,
    public val jupyterServerAppSettings: Output<DomainDefaultUserSettingsJupyterServerAppSettingsArgs>? = null,
    public val kernelGatewayAppSettings: Output<DomainDefaultUserSettingsKernelGatewayAppSettingsArgs>? = null,
    public val rSessionAppSettings: Output<DomainDefaultUserSettingsRSessionAppSettingsArgs>? = null,
    public val rStudioServerProAppSettings: Output<DomainDefaultUserSettingsRStudioServerProAppSettingsArgs>? = null,
    public val securityGroups: Output<List<String>>? = null,
    public val sharingSettings: Output<DomainDefaultUserSettingsSharingSettingsArgs>? = null,
    public val spaceStorageSettings: Output<DomainDefaultUserSettingsSpaceStorageSettingsArgs>? =
        null,
    public val studioWebPortal: Output<String>? = null,
    public val tensorBoardAppSettings: Output<DomainDefaultUserSettingsTensorBoardAppSettingsArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsArgs.builder()
            .canvasAppSettings(canvasAppSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .codeEditorAppSettings(
                codeEditorAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customFileSystemConfigs(
                customFileSystemConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .customPosixUserConfig(
                customPosixUserConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .defaultLandingUri(defaultLandingUri?.applyValue({ args0 -> args0 }))
            .executionRole(executionRole.applyValue({ args0 -> args0 }))
            .jupyterLabAppSettings(
                jupyterLabAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .jupyterServerAppSettings(
                jupyterServerAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kernelGatewayAppSettings(
                kernelGatewayAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .rSessionAppSettings(
                rSessionAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .rStudioServerProAppSettings(
                rStudioServerProAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sharingSettings(sharingSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .spaceStorageSettings(
                spaceStorageSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .studioWebPortal(studioWebPortal?.applyValue({ args0 -> args0 }))
            .tensorBoardAppSettings(
                tensorBoardAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DomainDefaultUserSettingsArgs].
 */
@PulumiTagMarker
public class DomainDefaultUserSettingsArgsBuilder internal constructor() {
    private var canvasAppSettings: Output<DomainDefaultUserSettingsCanvasAppSettingsArgs>? = null

    private var codeEditorAppSettings: Output<DomainDefaultUserSettingsCodeEditorAppSettingsArgs>? =
        null

    private var customFileSystemConfigs:
        Output<List<DomainDefaultUserSettingsCustomFileSystemConfigArgs>>? = null

    private var customPosixUserConfig: Output<DomainDefaultUserSettingsCustomPosixUserConfigArgs>? =
        null

    private var defaultLandingUri: Output<String>? = null

    private var executionRole: Output<String>? = null

    private var jupyterLabAppSettings: Output<DomainDefaultUserSettingsJupyterLabAppSettingsArgs>? =
        null

    private var jupyterServerAppSettings:
        Output<DomainDefaultUserSettingsJupyterServerAppSettingsArgs>? = null

    private var kernelGatewayAppSettings:
        Output<DomainDefaultUserSettingsKernelGatewayAppSettingsArgs>? = null

    private var rSessionAppSettings: Output<DomainDefaultUserSettingsRSessionAppSettingsArgs>? = null

    private var rStudioServerProAppSettings:
        Output<DomainDefaultUserSettingsRStudioServerProAppSettingsArgs>? = null

    private var securityGroups: Output<List<String>>? = null

    private var sharingSettings: Output<DomainDefaultUserSettingsSharingSettingsArgs>? = null

    private var spaceStorageSettings: Output<DomainDefaultUserSettingsSpaceStorageSettingsArgs>? =
        null

    private var studioWebPortal: Output<String>? = null

    private var tensorBoardAppSettings: Output<DomainDefaultUserSettingsTensorBoardAppSettingsArgs>? =
        null

    /**
     * @param value The Canvas app settings. See `canvas_app_settings` Block below.
     */
    @JvmName("pojscnwgaravjijb")
    public suspend fun canvasAppSettings(`value`: Output<DomainDefaultUserSettingsCanvasAppSettingsArgs>) {
        this.canvasAppSettings = value
    }

    /**
     * @param value The Code Editor application settings. See `code_editor_app_settings` Block below.
     */
    @JvmName("gjoqradkrooqrcre")
    public suspend fun codeEditorAppSettings(`value`: Output<DomainDefaultUserSettingsCodeEditorAppSettingsArgs>) {
        this.codeEditorAppSettings = value
    }

    /**
     * @param value The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio. See `custom_file_system_config` Block below.
     */
    @JvmName("mbggolvvkdnpmkkc")
    public suspend fun customFileSystemConfigs(`value`: Output<List<DomainDefaultUserSettingsCustomFileSystemConfigArgs>>) {
        this.customFileSystemConfigs = value
    }

    @JvmName("kgmjnbvwtldgkrhk")
    public suspend fun customFileSystemConfigs(vararg values: Output<DomainDefaultUserSettingsCustomFileSystemConfigArgs>) {
        this.customFileSystemConfigs = Output.all(values.asList())
    }

    /**
     * @param values The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio. See `custom_file_system_config` Block below.
     */
    @JvmName("npmgrtaixefeuvkk")
    public suspend fun customFileSystemConfigs(values: List<Output<DomainDefaultUserSettingsCustomFileSystemConfigArgs>>) {
        this.customFileSystemConfigs = Output.all(values)
    }

    /**
     * @param value Details about the POSIX identity that is used for file system operations. See `custom_posix_user_config` Block below.
     */
    @JvmName("rdvkxjjqxcwrrkyv")
    public suspend fun customPosixUserConfig(`value`: Output<DomainDefaultUserSettingsCustomPosixUserConfigArgs>) {
        this.customPosixUserConfig = value
    }

    /**
     * @param value The default experience that the user is directed to when accessing the domain. The supported values are: `studio::`: Indicates that Studio is the default experience. This value can only be passed if StudioWebPortal is set to ENABLED. `app:JupyterServer:`: Indicates that Studio Classic is the default experience.
     */
    @JvmName("xsytxctpfwixmsbt")
    public suspend fun defaultLandingUri(`value`: Output<String>) {
        this.defaultLandingUri = value
    }

    /**
     * @param value The execution role ARN for the user.
     */
    @JvmName("rsnltlmaacvhmxea")
    public suspend fun executionRole(`value`: Output<String>) {
        this.executionRole = value
    }

    /**
     * @param value The settings for the JupyterLab application. See `jupyter_lab_app_settings` Block below.
     */
    @JvmName("dquewbbnlvecfsrg")
    public suspend fun jupyterLabAppSettings(`value`: Output<DomainDefaultUserSettingsJupyterLabAppSettingsArgs>) {
        this.jupyterLabAppSettings = value
    }

    /**
     * @param value The Jupyter server's app settings. See `jupyter_server_app_settings` Block below.
     */
    @JvmName("elheavycaxkhcvgy")
    public suspend fun jupyterServerAppSettings(`value`: Output<DomainDefaultUserSettingsJupyterServerAppSettingsArgs>) {
        this.jupyterServerAppSettings = value
    }

    /**
     * @param value The kernel gateway app settings. See `kernel_gateway_app_settings` Block below.
     */
    @JvmName("umbngaponbtdqaqa")
    public suspend fun kernelGatewayAppSettings(`value`: Output<DomainDefaultUserSettingsKernelGatewayAppSettingsArgs>) {
        this.kernelGatewayAppSettings = value
    }

    /**
     * @param value The RSession app settings. See `r_session_app_settings` Block below.
     */
    @JvmName("goghrmjebqpwsroj")
    public suspend fun rSessionAppSettings(`value`: Output<DomainDefaultUserSettingsRSessionAppSettingsArgs>) {
        this.rSessionAppSettings = value
    }

    /**
     * @param value A collection of settings that configure user interaction with the RStudioServerPro app. See `r_studio_server_pro_app_settings` Block below.
     */
    @JvmName("woaxxsglcfcgoess")
    public suspend fun rStudioServerProAppSettings(`value`: Output<DomainDefaultUserSettingsRStudioServerProAppSettingsArgs>) {
        this.rStudioServerProAppSettings = value
    }

    /**
     * @param value A list of security group IDs that will be attached to the user.
     */
    @JvmName("paagdulhgeencadu")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("nstyxklsgwbaowqc")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values A list of security group IDs that will be attached to the user.
     */
    @JvmName("begtkdffmbucdtgy")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value The sharing settings. See `sharing_settings` Block below.
     */
    @JvmName("qtfghvdclrvsbysi")
    public suspend fun sharingSettings(`value`: Output<DomainDefaultUserSettingsSharingSettingsArgs>) {
        this.sharingSettings = value
    }

    /**
     * @param value The storage settings for a private space. See `space_storage_settings` Block below.
     */
    @JvmName("lachfpedanfyhpgj")
    public suspend fun spaceStorageSettings(`value`: Output<DomainDefaultUserSettingsSpaceStorageSettingsArgs>) {
        this.spaceStorageSettings = value
    }

    /**
     * @param value Whether the user can access Studio. If this value is set to `DISABLED`, the user cannot access Studio, even if that is the default experience for the domain. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("fayivthyvejpuahl")
    public suspend fun studioWebPortal(`value`: Output<String>) {
        this.studioWebPortal = value
    }

    /**
     * @param value The TensorBoard app settings. See `tensor_board_app_settings` Block below.
     */
    @JvmName("mrtecjgniucjspcs")
    public suspend fun tensorBoardAppSettings(`value`: Output<DomainDefaultUserSettingsTensorBoardAppSettingsArgs>) {
        this.tensorBoardAppSettings = value
    }

    /**
     * @param value The Canvas app settings. See `canvas_app_settings` Block below.
     */
    @JvmName("ughjnufndrodqsgj")
    public suspend fun canvasAppSettings(`value`: DomainDefaultUserSettingsCanvasAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.canvasAppSettings = mapped
    }

    /**
     * @param argument The Canvas app settings. See `canvas_app_settings` Block below.
     */
    @JvmName("akwcjqrihdsrihrw")
    public suspend fun canvasAppSettings(argument: suspend DomainDefaultUserSettingsCanvasAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultUserSettingsCanvasAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.canvasAppSettings = mapped
    }

    /**
     * @param value The Code Editor application settings. See `code_editor_app_settings` Block below.
     */
    @JvmName("swnrjgrqeipaocsl")
    public suspend fun codeEditorAppSettings(`value`: DomainDefaultUserSettingsCodeEditorAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeEditorAppSettings = mapped
    }

    /**
     * @param argument The Code Editor application settings. See `code_editor_app_settings` Block below.
     */
    @JvmName("pmurpyyeeyplfyhn")
    public suspend fun codeEditorAppSettings(argument: suspend DomainDefaultUserSettingsCodeEditorAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultUserSettingsCodeEditorAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.codeEditorAppSettings = mapped
    }

    /**
     * @param value The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio. See `custom_file_system_config` Block below.
     */
    @JvmName("dxpgmvnicqgjlwdt")
    public suspend fun customFileSystemConfigs(`value`: List<DomainDefaultUserSettingsCustomFileSystemConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customFileSystemConfigs = mapped
    }

    /**
     * @param argument The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio. See `custom_file_system_config` Block below.
     */
    @JvmName("xdqdegxnauwnhqyp")
    public suspend fun customFileSystemConfigs(argument: List<suspend DomainDefaultUserSettingsCustomFileSystemConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainDefaultUserSettingsCustomFileSystemConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customFileSystemConfigs = mapped
    }

    /**
     * @param argument The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio. See `custom_file_system_config` Block below.
     */
    @JvmName("cyjmktceotbegyrj")
    public suspend fun customFileSystemConfigs(vararg argument: suspend DomainDefaultUserSettingsCustomFileSystemConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainDefaultUserSettingsCustomFileSystemConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customFileSystemConfigs = mapped
    }

    /**
     * @param argument The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio. See `custom_file_system_config` Block below.
     */
    @JvmName("ialxxntnbachglad")
    public suspend fun customFileSystemConfigs(argument: suspend DomainDefaultUserSettingsCustomFileSystemConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DomainDefaultUserSettingsCustomFileSystemConfigArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.customFileSystemConfigs = mapped
    }

    /**
     * @param values The settings for assigning a custom file system to a user profile. Permitted users can access this file system in Amazon SageMaker Studio. See `custom_file_system_config` Block below.
     */
    @JvmName("vvprtwwnhwboxaux")
    public suspend fun customFileSystemConfigs(vararg values: DomainDefaultUserSettingsCustomFileSystemConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customFileSystemConfigs = mapped
    }

    /**
     * @param value Details about the POSIX identity that is used for file system operations. See `custom_posix_user_config` Block below.
     */
    @JvmName("pjgrnugmckogpdfy")
    public suspend fun customPosixUserConfig(`value`: DomainDefaultUserSettingsCustomPosixUserConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customPosixUserConfig = mapped
    }

    /**
     * @param argument Details about the POSIX identity that is used for file system operations. See `custom_posix_user_config` Block below.
     */
    @JvmName("wcxsxyvrytusgjgm")
    public suspend fun customPosixUserConfig(argument: suspend DomainDefaultUserSettingsCustomPosixUserConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultUserSettingsCustomPosixUserConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customPosixUserConfig = mapped
    }

    /**
     * @param value The default experience that the user is directed to when accessing the domain. The supported values are: `studio::`: Indicates that Studio is the default experience. This value can only be passed if StudioWebPortal is set to ENABLED. `app:JupyterServer:`: Indicates that Studio Classic is the default experience.
     */
    @JvmName("shyygvgkbyfsnuco")
    public suspend fun defaultLandingUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultLandingUri = mapped
    }

    /**
     * @param value The execution role ARN for the user.
     */
    @JvmName("cadtusjyubeqimvf")
    public suspend fun executionRole(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.executionRole = mapped
    }

    /**
     * @param value The settings for the JupyterLab application. See `jupyter_lab_app_settings` Block below.
     */
    @JvmName("dvwmesqrgaiydkuu")
    public suspend fun jupyterLabAppSettings(`value`: DomainDefaultUserSettingsJupyterLabAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jupyterLabAppSettings = mapped
    }

    /**
     * @param argument The settings for the JupyterLab application. See `jupyter_lab_app_settings` Block below.
     */
    @JvmName("hsddsgyjdmoxkedh")
    public suspend fun jupyterLabAppSettings(argument: suspend DomainDefaultUserSettingsJupyterLabAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultUserSettingsJupyterLabAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.jupyterLabAppSettings = mapped
    }

    /**
     * @param value The Jupyter server's app settings. See `jupyter_server_app_settings` Block below.
     */
    @JvmName("rhvcxofhgicrsfqi")
    public suspend fun jupyterServerAppSettings(`value`: DomainDefaultUserSettingsJupyterServerAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jupyterServerAppSettings = mapped
    }

    /**
     * @param argument The Jupyter server's app settings. See `jupyter_server_app_settings` Block below.
     */
    @JvmName("eqoqkroxqwgwbbbl")
    public suspend fun jupyterServerAppSettings(argument: suspend DomainDefaultUserSettingsJupyterServerAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultUserSettingsJupyterServerAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.jupyterServerAppSettings = mapped
    }

    /**
     * @param value The kernel gateway app settings. See `kernel_gateway_app_settings` Block below.
     */
    @JvmName("mfwgmylnhxjsepvw")
    public suspend fun kernelGatewayAppSettings(`value`: DomainDefaultUserSettingsKernelGatewayAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kernelGatewayAppSettings = mapped
    }

    /**
     * @param argument The kernel gateway app settings. See `kernel_gateway_app_settings` Block below.
     */
    @JvmName("vgugtekcsoiardvy")
    public suspend fun kernelGatewayAppSettings(argument: suspend DomainDefaultUserSettingsKernelGatewayAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultUserSettingsKernelGatewayAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kernelGatewayAppSettings = mapped
    }

    /**
     * @param value The RSession app settings. See `r_session_app_settings` Block below.
     */
    @JvmName("bbvphwiyepqjlrjb")
    public suspend fun rSessionAppSettings(`value`: DomainDefaultUserSettingsRSessionAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rSessionAppSettings = mapped
    }

    /**
     * @param argument The RSession app settings. See `r_session_app_settings` Block below.
     */
    @JvmName("qpyssaxujxrrmpbx")
    public suspend fun rSessionAppSettings(argument: suspend DomainDefaultUserSettingsRSessionAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultUserSettingsRSessionAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rSessionAppSettings = mapped
    }

    /**
     * @param value A collection of settings that configure user interaction with the RStudioServerPro app. See `r_studio_server_pro_app_settings` Block below.
     */
    @JvmName("dokyfltywrvwpixo")
    public suspend fun rStudioServerProAppSettings(`value`: DomainDefaultUserSettingsRStudioServerProAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rStudioServerProAppSettings = mapped
    }

    /**
     * @param argument A collection of settings that configure user interaction with the RStudioServerPro app. See `r_studio_server_pro_app_settings` Block below.
     */
    @JvmName("iruwejyytrwywvdw")
    public suspend fun rStudioServerProAppSettings(argument: suspend DomainDefaultUserSettingsRStudioServerProAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultUserSettingsRStudioServerProAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rStudioServerProAppSettings = mapped
    }

    /**
     * @param value A list of security group IDs that will be attached to the user.
     */
    @JvmName("saeisbhaotmotmua")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values A list of security group IDs that will be attached to the user.
     */
    @JvmName("fnotoxbrihvdmgfo")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value The sharing settings. See `sharing_settings` Block below.
     */
    @JvmName("xdpwynajdmergbst")
    public suspend fun sharingSettings(`value`: DomainDefaultUserSettingsSharingSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharingSettings = mapped
    }

    /**
     * @param argument The sharing settings. See `sharing_settings` Block below.
     */
    @JvmName("hooemvbjkkijeoky")
    public suspend fun sharingSettings(argument: suspend DomainDefaultUserSettingsSharingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultUserSettingsSharingSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sharingSettings = mapped
    }

    /**
     * @param value The storage settings for a private space. See `space_storage_settings` Block below.
     */
    @JvmName("oagxbapynopahmaj")
    public suspend fun spaceStorageSettings(`value`: DomainDefaultUserSettingsSpaceStorageSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spaceStorageSettings = mapped
    }

    /**
     * @param argument The storage settings for a private space. See `space_storage_settings` Block below.
     */
    @JvmName("wkklhexugpyqhpoa")
    public suspend fun spaceStorageSettings(argument: suspend DomainDefaultUserSettingsSpaceStorageSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultUserSettingsSpaceStorageSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.spaceStorageSettings = mapped
    }

    /**
     * @param value Whether the user can access Studio. If this value is set to `DISABLED`, the user cannot access Studio, even if that is the default experience for the domain. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("mdfxfonxovlhmvtu")
    public suspend fun studioWebPortal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.studioWebPortal = mapped
    }

    /**
     * @param value The TensorBoard app settings. See `tensor_board_app_settings` Block below.
     */
    @JvmName("pcwdecrthklhcerj")
    public suspend fun tensorBoardAppSettings(`value`: DomainDefaultUserSettingsTensorBoardAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tensorBoardAppSettings = mapped
    }

    /**
     * @param argument The TensorBoard app settings. See `tensor_board_app_settings` Block below.
     */
    @JvmName("lqkmynsfnunhvvqe")
    public suspend fun tensorBoardAppSettings(argument: suspend DomainDefaultUserSettingsTensorBoardAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultUserSettingsTensorBoardAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tensorBoardAppSettings = mapped
    }

    internal fun build(): DomainDefaultUserSettingsArgs = DomainDefaultUserSettingsArgs(
        canvasAppSettings = canvasAppSettings,
        codeEditorAppSettings = codeEditorAppSettings,
        customFileSystemConfigs = customFileSystemConfigs,
        customPosixUserConfig = customPosixUserConfig,
        defaultLandingUri = defaultLandingUri,
        executionRole = executionRole ?: throw PulumiNullFieldException("executionRole"),
        jupyterLabAppSettings = jupyterLabAppSettings,
        jupyterServerAppSettings = jupyterServerAppSettings,
        kernelGatewayAppSettings = kernelGatewayAppSettings,
        rSessionAppSettings = rSessionAppSettings,
        rStudioServerProAppSettings = rStudioServerProAppSettings,
        securityGroups = securityGroups,
        sharingSettings = sharingSettings,
        spaceStorageSettings = spaceStorageSettings,
        studioWebPortal = studioWebPortal,
        tensorBoardAppSettings = tensorBoardAppSettings,
    )
}
