@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCanvasAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property directDeploySettings The model deployment settings for the SageMaker Canvas application. See `direct_deploy_settings` Block below.
 * @property generativeAiSettings
 * @property identityProviderOauthSettings The settings for connecting to an external data source with OAuth. See `identity_provider_oauth_settings` Block below.
 * @property kendraSettings The settings for document querying. See `kendra_settings` Block below.
 * @property modelRegisterSettings The model registry settings for the SageMaker Canvas application. See `model_register_settings` Block below.
 * @property timeSeriesForecastingSettings Time series forecast settings for the Canvas app. See `time_series_forecasting_settings` Block below.
 * @property workspaceSettings The workspace settings for the SageMaker Canvas application. See `workspace_settings` Block below.
 */
public data class DomainDefaultUserSettingsCanvasAppSettingsArgs(
    public val directDeploySettings: Output<DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettingsArgs>? = null,
    public val generativeAiSettings: Output<DomainDefaultUserSettingsCanvasAppSettingsGenerativeAiSettingsArgs>? = null,
    public val identityProviderOauthSettings: Output<List<DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs>>? =
        null,
    public val kendraSettings: Output<DomainDefaultUserSettingsCanvasAppSettingsKendraSettingsArgs>? =
        null,
    public val modelRegisterSettings: Output<DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettingsArgs>? = null,
    public val timeSeriesForecastingSettings: Output<DomainDefaultUserSettingsCanvasAppSettingsTimeSeriesForecastingSettingsArgs>? = null,
    public val workspaceSettings: Output<DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCanvasAppSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCanvasAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCanvasAppSettingsArgs.builder()
            .directDeploySettings(
                directDeploySettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .generativeAiSettings(
                generativeAiSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .identityProviderOauthSettings(
                identityProviderOauthSettings?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .kendraSettings(kendraSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .modelRegisterSettings(
                modelRegisterSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .timeSeriesForecastingSettings(
                timeSeriesForecastingSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .workspaceSettings(
                workspaceSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DomainDefaultUserSettingsCanvasAppSettingsArgs].
 */
@PulumiTagMarker
public class DomainDefaultUserSettingsCanvasAppSettingsArgsBuilder internal constructor() {
    private var directDeploySettings:
        Output<DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettingsArgs>? = null

    private var generativeAiSettings:
        Output<DomainDefaultUserSettingsCanvasAppSettingsGenerativeAiSettingsArgs>? = null

    private var identityProviderOauthSettings:
        Output<List<DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs>>? =
        null

    private var kendraSettings: Output<DomainDefaultUserSettingsCanvasAppSettingsKendraSettingsArgs>? =
        null

    private var modelRegisterSettings:
        Output<DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettingsArgs>? = null

    private var timeSeriesForecastingSettings:
        Output<DomainDefaultUserSettingsCanvasAppSettingsTimeSeriesForecastingSettingsArgs>? = null

    private var workspaceSettings:
        Output<DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettingsArgs>? = null

    /**
     * @param value The model deployment settings for the SageMaker Canvas application. See `direct_deploy_settings` Block below.
     */
    @JvmName("pkdpoihkanyojbjf")
    public suspend fun directDeploySettings(`value`: Output<DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettingsArgs>) {
        this.directDeploySettings = value
    }

    /**
     * @param value
     */
    @JvmName("eldvowuwmjggnpfo")
    public suspend fun generativeAiSettings(`value`: Output<DomainDefaultUserSettingsCanvasAppSettingsGenerativeAiSettingsArgs>) {
        this.generativeAiSettings = value
    }

    /**
     * @param value The settings for connecting to an external data source with OAuth. See `identity_provider_oauth_settings` Block below.
     */
    @JvmName("ajtawuqcqdyidumb")
    public suspend fun identityProviderOauthSettings(`value`: Output<List<DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs>>) {
        this.identityProviderOauthSettings = value
    }

    @JvmName("xtcpmnccwmcomvdx")
    public suspend fun identityProviderOauthSettings(vararg values: Output<DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs>) {
        this.identityProviderOauthSettings = Output.all(values.asList())
    }

    /**
     * @param values The settings for connecting to an external data source with OAuth. See `identity_provider_oauth_settings` Block below.
     */
    @JvmName("cuymiwitmkbteyfg")
    public suspend fun identityProviderOauthSettings(values: List<Output<DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs>>) {
        this.identityProviderOauthSettings = Output.all(values)
    }

    /**
     * @param value The settings for document querying. See `kendra_settings` Block below.
     */
    @JvmName("pcaqhtrbfekmmlur")
    public suspend fun kendraSettings(`value`: Output<DomainDefaultUserSettingsCanvasAppSettingsKendraSettingsArgs>) {
        this.kendraSettings = value
    }

    /**
     * @param value The model registry settings for the SageMaker Canvas application. See `model_register_settings` Block below.
     */
    @JvmName("ioynywsfonifqmpy")
    public suspend fun modelRegisterSettings(`value`: Output<DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettingsArgs>) {
        this.modelRegisterSettings = value
    }

    /**
     * @param value Time series forecast settings for the Canvas app. See `time_series_forecasting_settings` Block below.
     */
    @JvmName("bgmqvwmtadanuyby")
    public suspend fun timeSeriesForecastingSettings(`value`: Output<DomainDefaultUserSettingsCanvasAppSettingsTimeSeriesForecastingSettingsArgs>) {
        this.timeSeriesForecastingSettings = value
    }

    /**
     * @param value The workspace settings for the SageMaker Canvas application. See `workspace_settings` Block below.
     */
    @JvmName("bprgwkwwgbcaxqjd")
    public suspend fun workspaceSettings(`value`: Output<DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettingsArgs>) {
        this.workspaceSettings = value
    }

    /**
     * @param value The model deployment settings for the SageMaker Canvas application. See `direct_deploy_settings` Block below.
     */
    @JvmName("xagkeqkwdvgaxsut")
    public suspend fun directDeploySettings(`value`: DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directDeploySettings = mapped
    }

    /**
     * @param argument The model deployment settings for the SageMaker Canvas application. See `direct_deploy_settings` Block below.
     */
    @JvmName("dfqnqwtnfrilekxh")
    public suspend fun directDeploySettings(argument: suspend DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.directDeploySettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("xvsarlwuticlelpj")
    public suspend fun generativeAiSettings(`value`: DomainDefaultUserSettingsCanvasAppSettingsGenerativeAiSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.generativeAiSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("twfobfjmnohntxeb")
    public suspend fun generativeAiSettings(argument: suspend DomainDefaultUserSettingsCanvasAppSettingsGenerativeAiSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultUserSettingsCanvasAppSettingsGenerativeAiSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.generativeAiSettings = mapped
    }

    /**
     * @param value The settings for connecting to an external data source with OAuth. See `identity_provider_oauth_settings` Block below.
     */
    @JvmName("aegwdqquqmbdvxjh")
    public suspend fun identityProviderOauthSettings(`value`: List<DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityProviderOauthSettings = mapped
    }

    /**
     * @param argument The settings for connecting to an external data source with OAuth. See `identity_provider_oauth_settings` Block below.
     */
    @JvmName("twyyeiiblkfmnbja")
    public suspend fun identityProviderOauthSettings(argument: List<suspend DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.identityProviderOauthSettings = mapped
    }

    /**
     * @param argument The settings for connecting to an external data source with OAuth. See `identity_provider_oauth_settings` Block below.
     */
    @JvmName("pmxwtnuxnkflhavs")
    public suspend fun identityProviderOauthSettings(vararg argument: suspend DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.identityProviderOauthSettings = mapped
    }

    /**
     * @param argument The settings for connecting to an external data source with OAuth. See `identity_provider_oauth_settings` Block below.
     */
    @JvmName("srkjlwkhcugbierq")
    public suspend fun identityProviderOauthSettings(argument: suspend DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.identityProviderOauthSettings = mapped
    }

    /**
     * @param values The settings for connecting to an external data source with OAuth. See `identity_provider_oauth_settings` Block below.
     */
    @JvmName("yhotwljkvgxiduou")
    public suspend fun identityProviderOauthSettings(vararg values: DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identityProviderOauthSettings = mapped
    }

    /**
     * @param value The settings for document querying. See `kendra_settings` Block below.
     */
    @JvmName("rmsypyteounycorw")
    public suspend fun kendraSettings(`value`: DomainDefaultUserSettingsCanvasAppSettingsKendraSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kendraSettings = mapped
    }

    /**
     * @param argument The settings for document querying. See `kendra_settings` Block below.
     */
    @JvmName("gqvretkamtyebkgo")
    public suspend fun kendraSettings(argument: suspend DomainDefaultUserSettingsCanvasAppSettingsKendraSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultUserSettingsCanvasAppSettingsKendraSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.kendraSettings = mapped
    }

    /**
     * @param value The model registry settings for the SageMaker Canvas application. See `model_register_settings` Block below.
     */
    @JvmName("xifrufhehieaejcj")
    public suspend fun modelRegisterSettings(`value`: DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelRegisterSettings = mapped
    }

    /**
     * @param argument The model registry settings for the SageMaker Canvas application. See `model_register_settings` Block below.
     */
    @JvmName("ajvgoyjqaryjiagu")
    public suspend fun modelRegisterSettings(argument: suspend DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.modelRegisterSettings = mapped
    }

    /**
     * @param value Time series forecast settings for the Canvas app. See `time_series_forecasting_settings` Block below.
     */
    @JvmName("xsxugfpyfrnbvpgb")
    public suspend fun timeSeriesForecastingSettings(`value`: DomainDefaultUserSettingsCanvasAppSettingsTimeSeriesForecastingSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeSeriesForecastingSettings = mapped
    }

    /**
     * @param argument Time series forecast settings for the Canvas app. See `time_series_forecasting_settings` Block below.
     */
    @JvmName("bgnuikqhonvddwny")
    public suspend fun timeSeriesForecastingSettings(argument: suspend DomainDefaultUserSettingsCanvasAppSettingsTimeSeriesForecastingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultUserSettingsCanvasAppSettingsTimeSeriesForecastingSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.timeSeriesForecastingSettings = mapped
    }

    /**
     * @param value The workspace settings for the SageMaker Canvas application. See `workspace_settings` Block below.
     */
    @JvmName("roxpqumtwlegbutf")
    public suspend fun workspaceSettings(`value`: DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceSettings = mapped
    }

    /**
     * @param argument The workspace settings for the SageMaker Canvas application. See `workspace_settings` Block below.
     */
    @JvmName("almegebhoqvjapua")
    public suspend fun workspaceSettings(argument: suspend DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.workspaceSettings = mapped
    }

    internal fun build(): DomainDefaultUserSettingsCanvasAppSettingsArgs =
        DomainDefaultUserSettingsCanvasAppSettingsArgs(
            directDeploySettings = directDeploySettings,
            generativeAiSettings = generativeAiSettings,
            identityProviderOauthSettings = identityProviderOauthSettings,
            kendraSettings = kendraSettings,
            modelRegisterSettings = modelRegisterSettings,
            timeSeriesForecastingSettings = timeSeriesForecastingSettings,
            workspaceSettings = workspaceSettings,
        )
}
