@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property s3ArtifactPath The Amazon S3 bucket used to store artifacts generated by Canvas. Updating the Amazon S3 location impacts existing configuration settings, and Canvas users no longer have access to their artifacts. Canvas users must log out and log back in to apply the new location.
 * @property s3KmsKeyId The Amazon Web Services Key Management Service (KMS) encryption key ID that is used to encrypt artifacts generated by Canvas in the Amazon S3 bucket.
 */
public data class DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettingsArgs(
    public val s3ArtifactPath: Output<String>? = null,
    public val s3KmsKeyId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettingsArgs.builder()
            .s3ArtifactPath(s3ArtifactPath?.applyValue({ args0 -> args0 }))
            .s3KmsKeyId(s3KmsKeyId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettingsArgs].
 */
@PulumiTagMarker
public class DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettingsArgsBuilder internal constructor() {
    private var s3ArtifactPath: Output<String>? = null

    private var s3KmsKeyId: Output<String>? = null

    /**
     * @param value The Amazon S3 bucket used to store artifacts generated by Canvas. Updating the Amazon S3 location impacts existing configuration settings, and Canvas users no longer have access to their artifacts. Canvas users must log out and log back in to apply the new location.
     */
    @JvmName("bgonyshrgwvavhpa")
    public suspend fun s3ArtifactPath(`value`: Output<String>) {
        this.s3ArtifactPath = value
    }

    /**
     * @param value The Amazon Web Services Key Management Service (KMS) encryption key ID that is used to encrypt artifacts generated by Canvas in the Amazon S3 bucket.
     */
    @JvmName("amvlkufdgspikkmn")
    public suspend fun s3KmsKeyId(`value`: Output<String>) {
        this.s3KmsKeyId = value
    }

    /**
     * @param value The Amazon S3 bucket used to store artifacts generated by Canvas. Updating the Amazon S3 location impacts existing configuration settings, and Canvas users no longer have access to their artifacts. Canvas users must log out and log back in to apply the new location.
     */
    @JvmName("evacngpsyembbmxq")
    public suspend fun s3ArtifactPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3ArtifactPath = mapped
    }

    /**
     * @param value The Amazon Web Services Key Management Service (KMS) encryption key ID that is used to encrypt artifacts generated by Canvas in the Amazon S3 bucket.
     */
    @JvmName("mlbjisomawyeabkf")
    public suspend fun s3KmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3KmsKeyId = mapped
    }

    internal fun build(): DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettingsArgs =
        DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettingsArgs(
            s3ArtifactPath = s3ArtifactPath,
            s3KmsKeyId = s3KmsKeyId,
        )
}
