@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCodeEditorAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property customImages A list of custom SageMaker images that are configured to run as a CodeEditor app. see `custom_image` Block below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
 * @property lifecycleConfigArns The Amazon Resource Name (ARN) of the Lifecycle Configurations.
 */
public data class DomainDefaultUserSettingsCodeEditorAppSettingsArgs(
    public val customImages: Output<List<DomainDefaultUserSettingsCodeEditorAppSettingsCustomImageArgs>>? = null,
    public val defaultResourceSpec: Output<DomainDefaultUserSettingsCodeEditorAppSettingsDefaultResourceSpecArgs>? = null,
    public val lifecycleConfigArns: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCodeEditorAppSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCodeEditorAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCodeEditorAppSettingsArgs.builder()
            .customImages(
                customImages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultResourceSpec(
                defaultResourceSpec?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .lifecycleConfigArns(
                lifecycleConfigArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [DomainDefaultUserSettingsCodeEditorAppSettingsArgs].
 */
@PulumiTagMarker
public class DomainDefaultUserSettingsCodeEditorAppSettingsArgsBuilder internal constructor() {
    private var customImages:
        Output<List<DomainDefaultUserSettingsCodeEditorAppSettingsCustomImageArgs>>? = null

    private var defaultResourceSpec:
        Output<DomainDefaultUserSettingsCodeEditorAppSettingsDefaultResourceSpecArgs>? = null

    private var lifecycleConfigArns: Output<List<String>>? = null

    /**
     * @param value A list of custom SageMaker images that are configured to run as a CodeEditor app. see `custom_image` Block below.
     */
    @JvmName("ecfkffdvqmefkotv")
    public suspend fun customImages(`value`: Output<List<DomainDefaultUserSettingsCodeEditorAppSettingsCustomImageArgs>>) {
        this.customImages = value
    }

    @JvmName("bfbiutsjdxtvfplj")
    public suspend fun customImages(vararg values: Output<DomainDefaultUserSettingsCodeEditorAppSettingsCustomImageArgs>) {
        this.customImages = Output.all(values.asList())
    }

    /**
     * @param values A list of custom SageMaker images that are configured to run as a CodeEditor app. see `custom_image` Block below.
     */
    @JvmName("eieuinehrixuqiio")
    public suspend fun customImages(values: List<Output<DomainDefaultUserSettingsCodeEditorAppSettingsCustomImageArgs>>) {
        this.customImages = Output.all(values)
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
     */
    @JvmName("tlwfebvxocfnqhsp")
    public suspend fun defaultResourceSpec(`value`: Output<DomainDefaultUserSettingsCodeEditorAppSettingsDefaultResourceSpecArgs>) {
        this.defaultResourceSpec = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("nyiojmeghavcbebs")
    public suspend fun lifecycleConfigArns(`value`: Output<List<String>>) {
        this.lifecycleConfigArns = value
    }

    @JvmName("drmhdofoyuanagow")
    public suspend fun lifecycleConfigArns(vararg values: Output<String>) {
        this.lifecycleConfigArns = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("xhsxwmkyetmfryqj")
    public suspend fun lifecycleConfigArns(values: List<Output<String>>) {
        this.lifecycleConfigArns = Output.all(values)
    }

    /**
     * @param value A list of custom SageMaker images that are configured to run as a CodeEditor app. see `custom_image` Block below.
     */
    @JvmName("vpxkwfgqchgeuhrg")
    public suspend fun customImages(`value`: List<DomainDefaultUserSettingsCodeEditorAppSettingsCustomImageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a CodeEditor app. see `custom_image` Block below.
     */
    @JvmName("llntxqfjffbjjgdr")
    public suspend fun customImages(argument: List<suspend DomainDefaultUserSettingsCodeEditorAppSettingsCustomImageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainDefaultUserSettingsCodeEditorAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a CodeEditor app. see `custom_image` Block below.
     */
    @JvmName("jqjabbwjqkffojja")
    public suspend fun customImages(vararg argument: suspend DomainDefaultUserSettingsCodeEditorAppSettingsCustomImageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainDefaultUserSettingsCodeEditorAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a CodeEditor app. see `custom_image` Block below.
     */
    @JvmName("hsnmetjrhmhkauvp")
    public suspend fun customImages(argument: suspend DomainDefaultUserSettingsCodeEditorAppSettingsCustomImageArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DomainDefaultUserSettingsCodeEditorAppSettingsCustomImageArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param values A list of custom SageMaker images that are configured to run as a CodeEditor app. see `custom_image` Block below.
     */
    @JvmName("cdixnatleuplomaq")
    public suspend fun customImages(vararg values: DomainDefaultUserSettingsCodeEditorAppSettingsCustomImageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
     */
    @JvmName("tkfdmbajieqmqhdu")
    public suspend fun defaultResourceSpec(`value`: DomainDefaultUserSettingsCodeEditorAppSettingsDefaultResourceSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultResourceSpec = mapped
    }

    /**
     * @param argument The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
     */
    @JvmName("gaemewpxkvkagbqb")
    public suspend fun defaultResourceSpec(argument: suspend DomainDefaultUserSettingsCodeEditorAppSettingsDefaultResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultUserSettingsCodeEditorAppSettingsDefaultResourceSpecArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultResourceSpec = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("depabmfvflwavyhk")
    public suspend fun lifecycleConfigArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("fctyipeklcpmvpbt")
    public suspend fun lifecycleConfigArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    internal fun build(): DomainDefaultUserSettingsCodeEditorAppSettingsArgs =
        DomainDefaultUserSettingsCodeEditorAppSettingsArgs(
            customImages = customImages,
            defaultResourceSpec = defaultResourceSpec,
            lifecycleConfigArns = lifecycleConfigArns,
        )
}
