@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCustomFileSystemConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property efsFileSystemConfig The default EBS storage settings for a private space. See `efs_file_system_config` Block below.
 */
public data class DomainDefaultUserSettingsCustomFileSystemConfigArgs(
    public val efsFileSystemConfig: Output<DomainDefaultUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCustomFileSystemConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCustomFileSystemConfigArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCustomFileSystemConfigArgs.builder()
            .efsFileSystemConfig(
                efsFileSystemConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DomainDefaultUserSettingsCustomFileSystemConfigArgs].
 */
@PulumiTagMarker
public class DomainDefaultUserSettingsCustomFileSystemConfigArgsBuilder internal constructor() {
    private var efsFileSystemConfig:
        Output<DomainDefaultUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgs>? = null

    /**
     * @param value The default EBS storage settings for a private space. See `efs_file_system_config` Block below.
     */
    @JvmName("vampacqeqvnxeavc")
    public suspend fun efsFileSystemConfig(`value`: Output<DomainDefaultUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgs>) {
        this.efsFileSystemConfig = value
    }

    /**
     * @param value The default EBS storage settings for a private space. See `efs_file_system_config` Block below.
     */
    @JvmName("fypweiarclnjnmmg")
    public suspend fun efsFileSystemConfig(`value`: DomainDefaultUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.efsFileSystemConfig = mapped
    }

    /**
     * @param argument The default EBS storage settings for a private space. See `efs_file_system_config` Block below.
     */
    @JvmName("rmveqclfqpfgpcdx")
    public suspend fun efsFileSystemConfig(argument: suspend DomainDefaultUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.efsFileSystemConfig = mapped
    }

    internal fun build(): DomainDefaultUserSettingsCustomFileSystemConfigArgs =
        DomainDefaultUserSettingsCustomFileSystemConfigArgs(
            efsFileSystemConfig = efsFileSystemConfig,
        )
}
