@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fileSystemId The ID of your Amazon EFS file system.
 * @property fileSystemPath The path to the file system directory that is accessible in Amazon SageMaker Studio. Permitted users can access only this directory and below.
 */
public data class DomainDefaultUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgs(
    public val fileSystemId: Output<String>,
    public val fileSystemPath: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgs.builder()
            .fileSystemId(fileSystemId.applyValue({ args0 -> args0 }))
            .fileSystemPath(fileSystemPath.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainDefaultUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgs].
 */
@PulumiTagMarker
public class DomainDefaultUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgsBuilder internal constructor() {
    private var fileSystemId: Output<String>? = null

    private var fileSystemPath: Output<String>? = null

    /**
     * @param value The ID of your Amazon EFS file system.
     */
    @JvmName("clditjtxaagxhrlw")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value The path to the file system directory that is accessible in Amazon SageMaker Studio. Permitted users can access only this directory and below.
     */
    @JvmName("iovlyfbyhwpypijy")
    public suspend fun fileSystemPath(`value`: Output<String>) {
        this.fileSystemPath = value
    }

    /**
     * @param value The ID of your Amazon EFS file system.
     */
    @JvmName("pllbvgsggrwhwvyk")
    public suspend fun fileSystemId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    /**
     * @param value The path to the file system directory that is accessible in Amazon SageMaker Studio. Permitted users can access only this directory and below.
     */
    @JvmName("ioifekibhmyarkyp")
    public suspend fun fileSystemPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileSystemPath = mapped
    }

    internal fun build(): DomainDefaultUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgs =
        DomainDefaultUserSettingsCustomFileSystemConfigEfsFileSystemConfigArgs(
            fileSystemId = fileSystemId ?: throw PulumiNullFieldException("fileSystemId"),
            fileSystemPath = fileSystemPath ?: throw PulumiNullFieldException("fileSystemPath"),
        )
}
