@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCustomPosixUserConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property gid The POSIX group ID.
 * @property uid The POSIX user ID.
 */
public data class DomainDefaultUserSettingsCustomPosixUserConfigArgs(
    public val gid: Output<Int>,
    public val uid: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCustomPosixUserConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCustomPosixUserConfigArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCustomPosixUserConfigArgs.builder()
            .gid(gid.applyValue({ args0 -> args0 }))
            .uid(uid.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainDefaultUserSettingsCustomPosixUserConfigArgs].
 */
@PulumiTagMarker
public class DomainDefaultUserSettingsCustomPosixUserConfigArgsBuilder internal constructor() {
    private var gid: Output<Int>? = null

    private var uid: Output<Int>? = null

    /**
     * @param value The POSIX group ID.
     */
    @JvmName("hjupaivdbbclsqio")
    public suspend fun gid(`value`: Output<Int>) {
        this.gid = value
    }

    /**
     * @param value The POSIX user ID.
     */
    @JvmName("xpaiymkeuyvhdqto")
    public suspend fun uid(`value`: Output<Int>) {
        this.uid = value
    }

    /**
     * @param value The POSIX group ID.
     */
    @JvmName("oqkermyqstwesdqw")
    public suspend fun gid(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gid = mapped
    }

    /**
     * @param value The POSIX user ID.
     */
    @JvmName("xbtxagjtjclltocm")
    public suspend fun uid(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uid = mapped
    }

    internal fun build(): DomainDefaultUserSettingsCustomPosixUserConfigArgs =
        DomainDefaultUserSettingsCustomPosixUserConfigArgs(
            gid = gid ?: throw PulumiNullFieldException("gid"),
            uid = uid ?: throw PulumiNullFieldException("uid"),
        )
}
