@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsJupyterLabAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property codeRepositories A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
 * @property customImages A list of custom SageMaker images that are configured to run as a JupyterLab app. see `custom_image` Block below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
 * @property lifecycleConfigArns The Amazon Resource Name (ARN) of the Lifecycle Configurations.
 */
public data class DomainDefaultUserSettingsJupyterLabAppSettingsArgs(
    public val codeRepositories: Output<List<DomainDefaultUserSettingsJupyterLabAppSettingsCodeRepositoryArgs>>? = null,
    public val customImages: Output<List<DomainDefaultUserSettingsJupyterLabAppSettingsCustomImageArgs>>? = null,
    public val defaultResourceSpec: Output<DomainDefaultUserSettingsJupyterLabAppSettingsDefaultResourceSpecArgs>? = null,
    public val lifecycleConfigArns: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsJupyterLabAppSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsJupyterLabAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsJupyterLabAppSettingsArgs.builder()
            .codeRepositories(
                codeRepositories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .customImages(
                customImages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultResourceSpec(
                defaultResourceSpec?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .lifecycleConfigArns(
                lifecycleConfigArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [DomainDefaultUserSettingsJupyterLabAppSettingsArgs].
 */
@PulumiTagMarker
public class DomainDefaultUserSettingsJupyterLabAppSettingsArgsBuilder internal constructor() {
    private var codeRepositories:
        Output<List<DomainDefaultUserSettingsJupyterLabAppSettingsCodeRepositoryArgs>>? = null

    private var customImages:
        Output<List<DomainDefaultUserSettingsJupyterLabAppSettingsCustomImageArgs>>? = null

    private var defaultResourceSpec:
        Output<DomainDefaultUserSettingsJupyterLabAppSettingsDefaultResourceSpecArgs>? = null

    private var lifecycleConfigArns: Output<List<String>>? = null

    /**
     * @param value A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
     */
    @JvmName("aouetnnxivanaedq")
    public suspend fun codeRepositories(`value`: Output<List<DomainDefaultUserSettingsJupyterLabAppSettingsCodeRepositoryArgs>>) {
        this.codeRepositories = value
    }

    @JvmName("ofarryulbiyteuik")
    public suspend fun codeRepositories(vararg values: Output<DomainDefaultUserSettingsJupyterLabAppSettingsCodeRepositoryArgs>) {
        this.codeRepositories = Output.all(values.asList())
    }

    /**
     * @param values A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
     */
    @JvmName("mvublavsljqbpqxl")
    public suspend fun codeRepositories(values: List<Output<DomainDefaultUserSettingsJupyterLabAppSettingsCodeRepositoryArgs>>) {
        this.codeRepositories = Output.all(values)
    }

    /**
     * @param value A list of custom SageMaker images that are configured to run as a JupyterLab app. see `custom_image` Block below.
     */
    @JvmName("uelobvsykafwrfpu")
    public suspend fun customImages(`value`: Output<List<DomainDefaultUserSettingsJupyterLabAppSettingsCustomImageArgs>>) {
        this.customImages = value
    }

    @JvmName("okgvrcvwfaubbqih")
    public suspend fun customImages(vararg values: Output<DomainDefaultUserSettingsJupyterLabAppSettingsCustomImageArgs>) {
        this.customImages = Output.all(values.asList())
    }

    /**
     * @param values A list of custom SageMaker images that are configured to run as a JupyterLab app. see `custom_image` Block below.
     */
    @JvmName("adshtotjiilvrcgd")
    public suspend fun customImages(values: List<Output<DomainDefaultUserSettingsJupyterLabAppSettingsCustomImageArgs>>) {
        this.customImages = Output.all(values)
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
     */
    @JvmName("vdvvoalsubvahkku")
    public suspend fun defaultResourceSpec(`value`: Output<DomainDefaultUserSettingsJupyterLabAppSettingsDefaultResourceSpecArgs>) {
        this.defaultResourceSpec = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("qccqoscnawakyexh")
    public suspend fun lifecycleConfigArns(`value`: Output<List<String>>) {
        this.lifecycleConfigArns = value
    }

    @JvmName("jkrhskkxycvdleep")
    public suspend fun lifecycleConfigArns(vararg values: Output<String>) {
        this.lifecycleConfigArns = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("lrokqqaifnfdqrck")
    public suspend fun lifecycleConfigArns(values: List<Output<String>>) {
        this.lifecycleConfigArns = Output.all(values)
    }

    /**
     * @param value A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
     */
    @JvmName("lrxgmreibpajsgae")
    public suspend fun codeRepositories(`value`: List<DomainDefaultUserSettingsJupyterLabAppSettingsCodeRepositoryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeRepositories = mapped
    }

    /**
     * @param argument A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
     */
    @JvmName("efjrjakxpnftmowc")
    public suspend fun codeRepositories(argument: List<suspend DomainDefaultUserSettingsJupyterLabAppSettingsCodeRepositoryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainDefaultUserSettingsJupyterLabAppSettingsCodeRepositoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.codeRepositories = mapped
    }

    /**
     * @param argument A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
     */
    @JvmName("hxxrohsrptexrdnp")
    public suspend fun codeRepositories(vararg argument: suspend DomainDefaultUserSettingsJupyterLabAppSettingsCodeRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainDefaultUserSettingsJupyterLabAppSettingsCodeRepositoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.codeRepositories = mapped
    }

    /**
     * @param argument A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
     */
    @JvmName("njuxucwofvcesqpe")
    public suspend fun codeRepositories(argument: suspend DomainDefaultUserSettingsJupyterLabAppSettingsCodeRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DomainDefaultUserSettingsJupyterLabAppSettingsCodeRepositoryArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.codeRepositories = mapped
    }

    /**
     * @param values A list of Git repositories that SageMaker automatically displays to users for cloning in the JupyterServer application. see `code_repository` Block below.
     */
    @JvmName("tatmqsxmfdjnbdsn")
    public suspend fun codeRepositories(vararg values: DomainDefaultUserSettingsJupyterLabAppSettingsCodeRepositoryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.codeRepositories = mapped
    }

    /**
     * @param value A list of custom SageMaker images that are configured to run as a JupyterLab app. see `custom_image` Block below.
     */
    @JvmName("hlrppdnkbcetvefm")
    public suspend fun customImages(`value`: List<DomainDefaultUserSettingsJupyterLabAppSettingsCustomImageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a JupyterLab app. see `custom_image` Block below.
     */
    @JvmName("fuclqusuegdenamh")
    public suspend fun customImages(argument: List<suspend DomainDefaultUserSettingsJupyterLabAppSettingsCustomImageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainDefaultUserSettingsJupyterLabAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a JupyterLab app. see `custom_image` Block below.
     */
    @JvmName("qhiijcnbylghrulv")
    public suspend fun customImages(vararg argument: suspend DomainDefaultUserSettingsJupyterLabAppSettingsCustomImageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainDefaultUserSettingsJupyterLabAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a JupyterLab app. see `custom_image` Block below.
     */
    @JvmName("rerymetpbitjhwck")
    public suspend fun customImages(argument: suspend DomainDefaultUserSettingsJupyterLabAppSettingsCustomImageArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DomainDefaultUserSettingsJupyterLabAppSettingsCustomImageArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param values A list of custom SageMaker images that are configured to run as a JupyterLab app. see `custom_image` Block below.
     */
    @JvmName("snampxarkhwamtlv")
    public suspend fun customImages(vararg values: DomainDefaultUserSettingsJupyterLabAppSettingsCustomImageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
     */
    @JvmName("kngadcqgcpqaesgf")
    public suspend fun defaultResourceSpec(`value`: DomainDefaultUserSettingsJupyterLabAppSettingsDefaultResourceSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultResourceSpec = mapped
    }

    /**
     * @param argument The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see `default_resource_spec` Block below.
     */
    @JvmName("hhmqesfwfobevedw")
    public suspend fun defaultResourceSpec(argument: suspend DomainDefaultUserSettingsJupyterLabAppSettingsDefaultResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultUserSettingsJupyterLabAppSettingsDefaultResourceSpecArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultResourceSpec = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("arakdcnqrcjtrqrv")
    public suspend fun lifecycleConfigArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("lppnyxoekfribthi")
    public suspend fun lifecycleConfigArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    internal fun build(): DomainDefaultUserSettingsJupyterLabAppSettingsArgs =
        DomainDefaultUserSettingsJupyterLabAppSettingsArgs(
            codeRepositories = codeRepositories,
            customImages = customImages,
            defaultResourceSpec = defaultResourceSpec,
            lifecycleConfigArns = lifecycleConfigArns,
        )
}
